/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.laf;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.providers.ILookAndFeelStarter;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class CrossPlatformLookAndFeelStarter
implements ILookAndFeelStarter {
    private IApplication application;

    public void start() throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        File propFile = new File(this.application.getConfigPath() + "/laf-cross-platform.properties");
        if (propFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(propFile));
                String theme = props.getProperty("current-theme");
                if (!StringUtil.isEmpty((String)theme)) {
                    MetalLookAndFeel.setCurrentTheme((MetalTheme)Class.forName(theme).newInstance());
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public void setApplication(IApplication application) {
        this.application = application;
    }
}

