/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.schemas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Driver;
import pl.mpak.orbada.db.DriverClassLoaderManager;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.schemas.SelectUrlTemplateDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.DriverAssignableClasses;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.id.UniqueID;

public class DriverEditDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private String drv_id;
    private int modalResult = 0;
    private Driver driver;
    private RecordLink driverLink;
    private JButton buttonAdd;
    private JButton buttonCancel;
    private JButton buttonDel;
    private JButton buttonOk;
    private JButton buttonResolveUrl;
    private JCheckBox checkPublicDriver;
    private Action cmAddLibrary;
    private Action cmCancel;
    private Action cmDelLibrary;
    private Action cmOk;
    private Action cmOpenSource;
    private Action cmRefreshDrivers;
    private Action cmResolveUrl;
    private JComboBox comboDrvClassName;
    private JComboBox comboDrvLibrarySource;
    private JComboBox comboDrvTypeName;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JList listExtraLibrary;
    private TextField textDrvName;
    private TextField textDrvUrlTemplate;

    public DriverEditDialog(String drv_id) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.drv_id = drv_id;
        this.initComponents();
        this.init();
    }

    public DriverEditDialog(Driver driver) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.driver = driver;
        this.initComponents();
        this.init();
    }

    public static String showDialog(String drv_id) throws IntrospectionException, UseDBException {
        DriverEditDialog dialog = new DriverEditDialog(drv_id);
        dialog.setVisible(true);
        return dialog.getModalResult() == 1 ? dialog.drv_id : null;
    }

    public static String showDialog(Driver driver) throws IntrospectionException, UseDBException {
        DriverEditDialog dialog = new DriverEditDialog(driver);
        dialog.setVisible(true);
        return dialog.getModalResult() == 1 ? dialog.drv_id : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IntrospectionException, UseDBException {
        Query query = InternalDatabase.get().createQuery();
        try {
            try {
                query.open("select dtp_name from driver_types order by dtp_name");
                this.comboDrvTypeName.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray(null, (Query)query)));
            }
            catch (Exception e) {
                ExceptionUtil.processException((Throwable)e);
            }
            try {
                query.open("select distinct drv_library_source from drivers order by drv_library_source");
                this.comboDrvLibrarySource.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray(null, (Query)query)));
            }
            catch (Exception e) {
                ExceptionUtil.processException((Throwable)e);
            }
        }
        finally {
            query.close();
        }
        this.listExtraLibrary.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DriverEditDialog.this.cmDelLibrary.setEnabled(DriverEditDialog.this.listExtraLibrary.getSelectedIndex() >= 0);
            }
        });
        this.listExtraLibrary.setModel(new DefaultListModel());
        this.driverLink = new RecordLink();
        this.driverLink.add("DRV_NAME", (Component)this.textDrvName, (IFieldRequires)new FieldRequeiredNotNull(stringManager.getString("DriverEditDialog-driver-name")));
        this.driverLink.add("DRV_LIBRARY_SOURCE", (Component)this.comboDrvLibrarySource, "selectedItem");
        this.driverLink.add("DRV_TYPE_NAME", (Component)this.comboDrvTypeName, "selectedItem");
        this.driverLink.add("DRV_CLASS_NAME", (Component)this.comboDrvClassName, "selectedItem");
        this.driverLink.add("DRV_URL_TEMPLATE", (Component)this.textDrvUrlTemplate);
        if (this.drv_id != null) {
            this.driver = new Driver(Application.get().getOrbadaDatabase(), this.drv_id);
        } else if (this.driver != null) {
            this.driver.setId(new UniqueID().toString());
            if (!Application.get().isUserAdmin() || this.driver.getUsrId() != null) {
                this.driver.setUsrId(Application.get().getUserId());
            }
        } else {
            this.driver = new Driver(Application.get().getOrbadaDatabase());
            this.driver.setUsrId(Application.get().getUserId());
        }
        this.driverLink.updateComponents((BufferedRecord)this.driver);
        this.checkPublicDriver.setEnabled(Application.get().isUserAdmin());
        this.checkPublicDriver.setSelected(this.driver.getUsrId() == null);
        this.extraLibToDialog();
        this.updateUrlList();
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonAdd, this.buttonDel});
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void extraLibToDialog() {
        DefaultListModel model = (DefaultListModel)this.listExtraLibrary.getModel();
        model.clear();
        if (!this.driver.fieldByName("DRV_EXTRA_LIBRARY").isNull()) {
            try {
                StringTokenizer st = new StringTokenizer(this.driver.fieldByName("DRV_EXTRA_LIBRARY").getString(), ";");
                while (st.hasMoreTokens()) {
                    model.addElement(st.nextToken());
                }
                if (model.size() > 0) {
                    this.listExtraLibrary.setSelectedIndex(0);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void dialogToExtraLib() {
        DefaultListModel model = (DefaultListModel)this.listExtraLibrary.getModel();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < model.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(model.get(i));
        }
        this.driver.fieldByName("DRV_EXTRA_LIBRARY").setString(sb.toString());
    }

    protected void refreshClassList() {
        Class[] classes;
        this.comboDrvClassName.removeAllItems();
        if (this.comboDrvLibrarySource.getSelectedItem() == null || "".equals(this.comboDrvLibrarySource.getSelectedItem())) {
            return;
        }
        URL url = null;
        try {
            url = new File(this.comboDrvLibrarySource.getSelectedItem().toString()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            ExceptionUtil.processException((Throwable)e);
            return;
        }
        DriverAssignableClasses cl = new DriverAssignableClasses(url);
        try {
            classes = cl.getDriverClasses();
        }
        catch (Exception e) {
            ExceptionUtil.processException((Throwable)e);
            return;
        }
        for (int i = 0; i < classes.length; ++i) {
            this.comboDrvClassName.addItem(classes[i].getName());
        }
    }

    private void updateUrlList() {
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmOpenSource = new Action();
        this.cmRefreshDrivers = new Action();
        this.cmResolveUrl = new Action();
        this.cmAddLibrary = new Action();
        this.cmDelLibrary = new Action();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.comboDrvTypeName = new JComboBox();
        this.jButton1 = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.textDrvName = new TextField();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.comboDrvClassName = new JComboBox();
        this.comboDrvLibrarySource = new JComboBox();
        this.jButton2 = new JButton();
        this.textDrvUrlTemplate = new TextField();
        this.buttonResolveUrl = new JButton();
        this.checkPublicDriver = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listExtraLibrary = new JList();
        this.buttonAdd = new JButton();
        this.buttonDel = new JButton();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmOpenSource.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/open16.gif"));
        this.cmOpenSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverEditDialog.this.cmOpenSourceActionPerformed(evt);
            }
        });
        this.cmRefreshDrivers.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshDrivers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverEditDialog.this.cmRefreshDriversActionPerformed(evt);
            }
        });
        this.cmResolveUrl.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmResolveUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverEditDialog.this.cmResolveUrlActionPerformed(evt);
            }
        });
        this.cmAddLibrary.setText(stringManager.getString("cmAddLibrary-text"));
        this.cmAddLibrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverEditDialog.this.cmAddLibraryActionPerformed(evt);
            }
        });
        this.cmDelLibrary.setText(stringManager.getString("cmDelLibrary-text"));
        this.cmDelLibrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverEditDialog.this.cmDelLibraryActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("DriverEditDialog-title"));
        this.setModal(true);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor((Component)this.textDrvName);
        this.jLabel1.setText(stringManager.getString("DriverEditDialog-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("DriverEditDialog-driver-source-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setLabelFor(this.comboDrvTypeName);
        this.jLabel3.setText(stringManager.getString("DriverEditDialog-driver-kind-dd"));
        this.comboDrvTypeName.setEditable(true);
        this.jButton1.setAction((javax.swing.Action)this.cmOpenSource);
        this.jButton1.setPreferredSize(new Dimension(25, 25));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("DriverEditDialog-class-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(stringManager.getString("DriverEditDialog-url-pattern-dd"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.comboDrvClassName.setEditable(true);
        this.comboDrvClassName.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        this.comboDrvLibrarySource.setEditable(true);
        this.jButton2.setAction((javax.swing.Action)this.cmRefreshDrivers);
        this.jButton2.setMargin(new Insets(1, 1, 1, 1));
        this.jButton2.setPreferredSize(new Dimension(25, 25));
        this.buttonResolveUrl.setAction((javax.swing.Action)this.cmResolveUrl);
        this.buttonResolveUrl.setMargin(new Insets(1, 1, 1, 1));
        this.buttonResolveUrl.setPreferredSize(new Dimension(25, 25));
        this.checkPublicDriver.setText(stringManager.getString("DriverEditDialog-all-user-show"));
        this.jLabel6.setText(stringManager.getString("extra-libraries-dd"));
        this.listExtraLibrary.setFixedCellHeight(18);
        this.jScrollPane1.setViewportView(this.listExtraLibrary);
        this.buttonAdd.setAction((javax.swing.Action)this.cmAddLibrary);
        this.buttonAdd.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdd.setPreferredSize(new Dimension(85, 25));
        this.buttonDel.setAction((javax.swing.Action)this.cmDelLibrary);
        this.buttonDel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDel.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 381, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.buttonDel, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, 145, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textDrvName, -1, 323, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboDrvLibrarySource, GroupLayout.Alignment.TRAILING, 0, 264, Short.MAX_VALUE).addComponent(this.comboDrvTypeName, 0, 264, Short.MAX_VALUE).addComponent(this.comboDrvClassName, 0, 264, Short.MAX_VALUE).addComponent((Component)this.textDrvUrlTemplate, GroupLayout.Alignment.TRAILING, -1, 264, Short.MAX_VALUE).addComponent(this.checkPublicDriver)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.buttonResolveUrl, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE))))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.jLabel6)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textDrvName, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboDrvLibrarySource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboDrvTypeName, -2, -1, -2))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboDrvClassName, -2, -1, -2)).addComponent(this.jButton2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textDrvUrlTemplate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPublicDriver)).addComponent(this.buttonResolveUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonAdd, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDel, -2, -1, -2)).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cmRefreshDriversActionPerformed(ActionEvent evt) {
        this.refreshClassList();
    }

    private void cmOpenSourceActionPerformed(ActionEvent evt) {
        JFileChooser fileChoose = new JFileChooser(".");
        if (this.comboDrvLibrarySource.getSelectedItem() != null && !this.comboDrvLibrarySource.getSelectedItem().equals("")) {
            fileChoose.setSelectedFile(new File(this.comboDrvLibrarySource.getSelectedItem().toString()));
        }
        fileChoose.addChoosableFileFilter((FileFilter)new FileExtensionFilter(stringManager.getString("jar-files"), new String[]{".jar", ".zip"}));
        int returnVal = fileChoose.showOpenDialog(this);
        if (returnVal == 0) {
            this.comboDrvLibrarySource.setSelectedItem(fileChoose.getSelectedFile().getAbsoluteFile());
            this.refreshClassList();
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.driverLink.updateRecord((BufferedRecord)this.driver);
            if (this.checkPublicDriver.isSelected()) {
                this.driver.setUsrId(null);
            } else if (this.driver.getUsrId() == null) {
                this.driver.setUsrId(Application.get().getUserId());
            }
            this.dialogToExtraLib();
            if (this.driver.isChanged()) {
                if (this.drv_id == null) {
                    this.driver.applyInsert();
                } else {
                    this.driver.applyUpdate();
                }
                this.drv_id = this.driver.getId();
            }
            this.modalResult = 1;
            DriverClassLoaderManager.reset();
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmResolveUrlActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String url = SelectUrlTemplateDialog.show(((JTextField)DriverEditDialog.this.comboDrvTypeName.getEditor().getEditorComponent()).getText(), ((JTextField)DriverEditDialog.this.comboDrvClassName.getEditor().getEditorComponent()).getText());
                if (url != null) {
                    DriverEditDialog.this.textDrvUrlTemplate.setText(url);
                }
            }
        });
    }

    private void cmAddLibraryActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.listExtraLibrary.getModel();
        JFileChooser fileChoose = new JFileChooser(".");
        fileChoose.addChoosableFileFilter((FileFilter)new FileExtensionFilter(stringManager.getString("jar-files"), new String[]{".jar", ".zip"}));
        int returnVal = fileChoose.showOpenDialog(this);
        if (returnVal == 0) {
            model.addElement(fileChoose.getSelectedFile().getAbsoluteFile());
        }
    }

    private void cmDelLibraryActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.listExtraLibrary.getModel();
        if (this.listExtraLibrary.getSelectedIndex() >= 0 && MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)"Usun\u0105\u0107 wybran\u0105 bibliotek\u0119 z listy ?", (int[])ModalResult.YESNO, (int)3) == 5) {
            model.remove(this.listExtraLibrary.getSelectedIndex());
        }
    }
}

