/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.schemas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Driver;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.schemas.DriverEditDialog;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class DriverListDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ISettings settings;
    private JButton buttonClose;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonFunctions;
    private JButton buttonNew;
    private Action cmClose;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmExport;
    private Action cmFunctions;
    private Action cmImport;
    private Action cmNew;
    private JScrollPane jScrollPane1;
    private JMenuItem menuExport;
    private JMenuItem menuImport;
    private JPopupMenu popupFunctions;
    private ViewTable tableDrivers;

    public DriverListDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DriverListDialog dialog = new DriverListDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-driver-list-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.tableDrivers.getQuery().setDatabase(InternalDatabase.get());
        this.tableDrivers.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void afterOpen(EventObject e) {
                DriverListDialog.this.cmNew.setEnabled(true);
                DriverListDialog.this.cmImport.setEnabled(true);
            }

            public void afterClose(EventObject e) {
                DriverListDialog.this.cmNew.setEnabled(false);
                DriverListDialog.this.cmEdit.setEnabled(false);
                DriverListDialog.this.cmDelete.setEnabled(false);
                DriverListDialog.this.cmImport.setEnabled(false);
                DriverListDialog.this.cmExport.setEnabled(false);
            }
        });
        this.tableDrivers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DriverListDialog.this.tableDrivers.getSelectedRow() >= 0) {
                    try {
                        DriverListDialog.this.tableDrivers.getQuery().getRecord(DriverListDialog.this.tableDrivers.getSelectedRow());
                        DriverListDialog.this.cmEdit.setEnabled(e.getFirstIndex() >= 0 && (Application.get().isUserAdmin() || !DriverListDialog.this.tableDrivers.getQuery().fieldByName("drv_usr_id").isNull()));
                        DriverListDialog.this.cmDelete.setEnabled(e.getFirstIndex() >= 0 && (Application.get().isUserAdmin() || !DriverListDialog.this.tableDrivers.getQuery().fieldByName("drv_usr_id").isNull()));
                        DriverListDialog.this.cmExport.setEnabled(e.getFirstIndex() >= 0 && (Application.get().isUserAdmin() || !DriverListDialog.this.tableDrivers.getQuery().fieldByName("drv_usr_id").isNull()));
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    DriverListDialog.this.cmEdit.setEnabled(false);
                    DriverListDialog.this.cmDelete.setEnabled(false);
                    DriverListDialog.this.cmExport.setEnabled(false);
                }
            }
        });
        try {
            this.tableDrivers.addColumn((TableColumn)new QueryTableColumn("drv_name", stringManager.getString("DriverListDialog-driver-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableDrivers.addColumn((TableColumn)new QueryTableColumn("drv_type_name", stringManager.getString("DriverListDialog-kind"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableDrivers.addColumn((TableColumn)new QueryTableColumn("drv_class_name", stringManager.getString("DriverListDialog-class"), 200));
            this.tableDrivers.addColumn((TableColumn)new QueryTableColumn("drv_url_template", stringManager.getString("DriverListDialog-url-pattern"), 250));
            this.tableDrivers.getQuery().setSqlText("select * from drivers where drv_usr_id = :drv_usr_id or drv_usr_id is null order by drv_name");
            this.tableDrivers.getQuery().paramByName("drv_usr_id").setString(Application.get().getUserId());
            this.tableDrivers.getQuery().open();
            if (!this.tableDrivers.getQuery().isEmpty()) {
                this.tableDrivers.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonEdit, this.buttonDelete, this.buttonClose, this.buttonFunctions});
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        this.tableDrivers.getQuery().close();
        super.dispose();
    }

    public void refreshQuery(final String drv_id) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lastRow = DriverListDialog.this.tableDrivers.getSelectedRow();
                try {
                    String id = drv_id;
                    if (DriverListDialog.this.tableDrivers.getQuery().isActive() && DriverListDialog.this.tableDrivers.getSelectedRow() >= 0 && id == null) {
                        DriverListDialog.this.tableDrivers.getQuery().getRecord(lastRow);
                        id = DriverListDialog.this.tableDrivers.getQuery().fieldByName("drv_id").getString();
                    }
                    DriverListDialog.this.tableDrivers.getQuery().refresh();
                    if (id != null && DriverListDialog.this.tableDrivers.getQuery().locate("drv_id", new Variant(id))) {
                        DriverListDialog.this.tableDrivers.changeSelection(DriverListDialog.this.tableDrivers.getQuery().getCurrentRecord().getIndex(), 0);
                    } else if (DriverListDialog.this.tableDrivers.getRowCount() > lastRow && lastRow >= 0) {
                        DriverListDialog.this.tableDrivers.changeSelection(lastRow, 0);
                    } else if (DriverListDialog.this.tableDrivers.getRowCount() > 0) {
                        DriverListDialog.this.tableDrivers.changeSelection(0, 0);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.cmFunctions = new Action();
        this.popupFunctions = new JPopupMenu();
        this.menuExport = new JMenuItem();
        this.menuImport = new JMenuItem();
        this.cmExport = new Action();
        this.cmImport = new Action();
        this.buttonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableDrivers = new ViewTable();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.buttonFunctions = new JButton();
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverListDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmNew.setEnabled(false);
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverListDialog.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setEnabled(false);
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverListDialog.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setEnabled(false);
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverListDialog.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmFunctions.setActionCommandKey("cmFunctions");
        this.cmFunctions.setText(stringManager.getString("DriverListDialog-cmFunctions-text"));
        this.cmFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverListDialog.this.cmFunctionsActionPerformed(evt);
            }
        });
        this.menuExport.setAction((javax.swing.Action)this.cmExport);
        this.popupFunctions.add(this.menuExport);
        this.menuImport.setAction((javax.swing.Action)this.cmImport);
        this.popupFunctions.add(this.menuImport);
        this.cmExport.setActionCommandKey("cmExport");
        this.cmExport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/export.gif"));
        this.cmExport.setText(stringManager.getString("DriverListDialog-cmExport-text"));
        this.cmExport.setTooltip(stringManager.getString("DriverListDialog-cmExport-hint"));
        this.cmExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverListDialog.this.cmExportActionPerformed(evt);
            }
        });
        this.cmImport.setActionCommandKey("cmImport");
        this.cmImport.setEnabled(false);
        this.cmImport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/import.gif"));
        this.cmImport.setText(stringManager.getString("DriverListDialog-cmImport-text"));
        this.cmImport.setTooltip(stringManager.getString("DriverListDialog-cmImport-hint"));
        this.cmImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverListDialog.this.cmImportActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("DriverListDialog-title"));
        this.setModal(true);
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(85, 25));
        this.jScrollPane1.setViewportView((Component)((Object)this.tableDrivers));
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.buttonFunctions.setAction((javax.swing.Action)this.cmFunctions);
        this.buttonFunctions.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFunctions.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 597, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFunctions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 154, Short.MAX_VALUE).addComponent(this.buttonClose, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 264, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonClose, -2, -1, -2).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2)).addComponent(this.buttonFunctions, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        if (this.tableDrivers.getQuery().isActive() && this.tableDrivers.getSelectedRow() >= 0) {
            try {
                this.tableDrivers.getQuery().getRecord(this.tableDrivers.getSelectedRow());
                String drv_id = this.tableDrivers.getQuery().fieldByName("DRV_ID").getString();
                String drv_name = this.tableDrivers.getQuery().fieldByName("DRV_NAME").getString();
                if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)String.format(stringManager.getString("DriverListDialog-delete-q"), drv_id, drv_name), (int[])ModalResult.YESNO, (int)3) == 5) {
                    Driver driver = new Driver(Application.get().getOrbadaDatabase());
                    driver.getPrimaryKeyField().setValue(new Variant(drv_id));
                    driver.applyDelete();
                    this.refreshQuery(null);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableDrivers.getQuery().isActive() && this.tableDrivers.getSelectedRow() >= 0) {
                this.tableDrivers.getQuery().getRecord(this.tableDrivers.getSelectedRow());
                String drv_id = DriverEditDialog.showDialog(this.tableDrivers.getQuery().fieldByName("drv_id").getString());
                if (drv_id != null) {
                    this.refreshQuery(drv_id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            String drv_id;
            if (this.tableDrivers.getQuery().isActive() && (drv_id = DriverEditDialog.showDialog((String)null)) != null) {
                this.refreshQuery(drv_id);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmFunctionsActionPerformed(ActionEvent evt) {
        this.popupFunctions.show(this.buttonFunctions, 0, this.buttonFunctions.getHeight());
    }

    private void cmExportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableDrivers.getQuery().isActive() && this.tableDrivers.getSelectedRow() >= 0) {
                this.tableDrivers.getQuery().getRecord(this.tableDrivers.getSelectedRow());
                File file = FileUtil.selectFileToSave((Component)this, (String)stringManager.getString("DriverListDialog-save-driver"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("DriverListDialog-driver-file"), new String[]{".xml.ojdbcdriver"})});
                if (file != null) {
                    Driver driver = new Driver(InternalDatabase.get(), this.tableDrivers.getQuery().fieldByName("drv_id").getString());
                    driver.storeToXML((OutputStream)new FileOutputStream(file), null, "utf-8");
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmImportActionPerformed(ActionEvent evt) {
        try {
            File file;
            if (this.tableDrivers.getQuery().isActive() && (file = FileUtil.selectFileToOpen((Component)this, (String)stringManager.getString("DriverListDialog-open-driver"), (File)null, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("DriverListDialog-driver-file"), new String[]{".xml.ojdbcdriver"})})) != null) {
                Driver driver = new Driver(InternalDatabase.get());
                driver.loadFromXML((InputStream)new FileInputStream(file));
                String drv_id = DriverEditDialog.showDialog(driver);
                if (drv_id != null) {
                    this.refreshQuery(drv_id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

