/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.schemas;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class GeneralSchemaSettingServicePanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private String schemaId;
    private ISettings settings;
    private JCheckBox checkDisableLoadSqlSyntaxInfo;
    private JCheckBox checkUseGlobalSettingsDisableLoadSqlSyntaxInfo;

    public GeneralSchemaSettingServicePanel(String schemaId) {
        this.schemaId = schemaId;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = Application.get().getSettings(this.schemaId, "orbada-settings");
        this.restoreSettings();
    }

    private void enableControls() {
        this.checkDisableLoadSqlSyntaxInfo.setEnabled(!this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo.isSelected());
    }

    private void initComponents() {
        this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo = new JCheckBox();
        this.checkDisableLoadSqlSyntaxInfo = new JCheckBox();
        this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo.setText(this.stringManager.getString("useGlobalSettings-text"));
        this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GeneralSchemaSettingServicePanel.this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfoItemStateChanged(evt);
            }
        });
        this.checkDisableLoadSqlSyntaxInfo.setText(this.stringManager.getString("OrbadaSettingsDialog-checkDisableLoadSqlSyntaxInfo-text"));
        this.checkDisableLoadSqlSyntaxInfo.setToolTipText(this.stringManager.getString("OrbadaSettingsDialog-checkDisableLoadSqlSyntaxInfo-hint"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.checkDisableLoadSqlSyntaxInfo)).addComponent(this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo)).addContainerGap(75, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDisableLoadSqlSyntaxInfo).addContainerGap(296, Short.MAX_VALUE)));
    }

    private void checkUseGlobalSettingsDisableLoadSqlSyntaxInfoItemStateChanged(ItemEvent evt) {
        this.enableControls();
    }

    public void restoreSettings() {
        this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo.setSelected(this.settings.getValue("use-global-settings-disable-load-sql-syntax-info", Boolean.valueOf(true)));
        this.checkDisableLoadSqlSyntaxInfo.setSelected(this.settings.getValue("disable-load-sql-syntax-info", Boolean.valueOf(false)));
        this.enableControls();
    }

    public void applySettings() {
        this.settings.setValue("use-global-settings-disable-load-sql-syntax-info", Boolean.valueOf(this.checkUseGlobalSettingsDisableLoadSqlSyntaxInfo.isSelected()));
        this.settings.setValue("disable-load-sql-syntax-info", Boolean.valueOf(this.checkDisableLoadSqlSyntaxInfo.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }
}

