/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.schemas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.ConnectionFactory;
import pl.mpak.orbada.db.DriverClassLoaderManager;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Schema;
import pl.mpak.orbada.gui.schemas.PropertyDialog;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.plugins.providers.SchemaSettingsProvider;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.FieldLinkType;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.usedb.gui.swing.QueryComboBoxModel;
import pl.mpak.usedb.gui.swing.QueryListCellRenderer;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StreamUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPool;
import pl.mpak.util.variant.Variant;
import pl.mpak.waitdlg.WaitDialog;

public class SchemaEditDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private String sch_id;
    private int modalResult = 0;
    private Schema schema;
    private RecordLink schemaLink;
    private Query queryDrivers;
    private ArrayList<SchemaSetting> settinsList = new ArrayList();
    private JButton buttonAddJdbcProperty;
    private JButton buttonAddUserProperty;
    private JButton buttonCancel;
    private JButton buttonIcon;
    private JButton buttonOk;
    private JButton buttonTest;
    private JCheckBox checkPublicSchema;
    private JCheckBox checkSchAutoCommit;
    private Action cmAddJdbcProperty;
    private Action cmAddUserProperties;
    private Action cmCancel;
    private Action cmOk;
    private Action cmRefreshUrl;
    private Action cmSelectIcon;
    private Action cmTest;
    private ComboBox comboSchDrvId;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelDrvUrlTemplate;
    private JTabbedPane tabbetSettings;
    private TextArea textProperties;
    private TextField textSchDatabase;
    private TextField textSchHost;
    private TextField textSchName;
    private JPasswordField textSchPassword;
    private TextField textSchPort;
    private TextField textSchUrl;
    private TextField textSchUser;
    private TextArea textUserProperties;

    public SchemaEditDialog(String sch_id) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.sch_id = sch_id;
        this.initComponents();
        this.init();
    }

    public SchemaEditDialog(Schema schema) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.schema = schema;
        this.initComponents();
        this.init();
    }

    public static String showDialog(String sch_id) throws IntrospectionException, UseDBException {
        SchemaEditDialog dialog = new SchemaEditDialog(sch_id);
        dialog.setVisible(true);
        if (dialog.getModalResult() == 1) {
            return dialog.sch_id;
        }
        return null;
    }

    public static String showDialog(Schema schema) throws IntrospectionException, UseDBException {
        SchemaEditDialog dialog = new SchemaEditDialog(schema);
        dialog.setVisible(true);
        if (dialog.getModalResult() == 1) {
            return dialog.sch_id;
        }
        return null;
    }

    private void init() throws IntrospectionException, UseDBException {
        this.queryDrivers = InternalDatabase.get().createQuery();
        try {
            this.queryDrivers.setCacheData(true);
            this.queryDrivers.setSqlText("select drv_id, drv_name, drv_type_name, drv_url_template, drv_class_name from drivers where drv_usr_id = :drv_usr_id or drv_usr_id is null order by drv_name, drv_id");
            this.queryDrivers.paramByName("drv_usr_id").setString(Application.get().getUserId());
            this.queryDrivers.open();
            this.comboSchDrvId.setModel((ComboBoxModel)new QueryComboBoxModel(this.queryDrivers, "drv_id"));
            this.comboSchDrvId.setRenderer((ListCellRenderer)new QueryListCellRenderer(this.queryDrivers, "drv_id", "drv_name"));
            this.comboSchDrvId.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        try {
                            if (SchemaEditDialog.this.queryDrivers.locate("drv_id", new Variant(e.getItem()))) {
                                SchemaEditDialog.this.labelDrvUrlTemplate.setText(SchemaEditDialog.this.queryDrivers.fieldByName("drv_url_template").getString());
                                SchemaEditDialog.this.setSettingsVisible(SchemaEditDialog.this.queryDrivers.fieldByName("drv_type_name").getString());
                            } else {
                                SchemaEditDialog.this.labelDrvUrlTemplate.setText(" ");
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            ExceptionUtil.processException((Throwable)e);
        }
        this.schemaLink = new RecordLink();
        this.schemaLink.add("SCH_NAME", (Component)this.textSchName, (IFieldRequires)new FieldRequeiredNotNull(stringManager.getString("SchemaEditDialog-schema-name")));
        this.schemaLink.add("SCH_DRV_ID", (Component)this.comboSchDrvId, "selectedItem");
        this.schemaLink.add("SCH_HOST", (Component)this.textSchHost);
        this.schemaLink.add("SCH_USER", (Component)this.textSchUser);
        this.schemaLink.add("SCH_PASSWORD", (Component)this.textSchPassword);
        this.schemaLink.add("SCH_DATABASE", (Component)this.textSchDatabase);
        this.schemaLink.add("SCH_PORT", (Component)this.textSchPort, "text", 3);
        this.schemaLink.add("SCH_URL", (Component)this.textSchUrl);
        this.schemaLink.add("SCH_AUTO_COMMIT", (Component)this.checkSchAutoCommit, "selected", FieldLinkType.Boolean_TN);
        this.schemaLink.add("SCH_PROPERTIES", (Component)this.textProperties);
        this.schemaLink.add("SCH_USER_PROPERTIES", (Component)this.textUserProperties);
        if (this.sch_id != null) {
            this.schema = new Schema(InternalDatabase.get(), this.sch_id);
        } else if (this.schema != null) {
            this.schema.fieldByName("sch_id").setString(new UniqueID().toString());
            this.schema.fieldByName("sch_selected").setValue(null);
            if (!Application.get().isUserAdmin() || this.schema.getUsrId() != null) {
                this.schema.setUsrId(Application.get().getUserId());
            }
        } else {
            this.schema = new Schema(InternalDatabase.get());
            this.schema.setUsrId(Application.get().getUserId());
            this.schema.fieldByName("SCH_NAME").setString("{user}@{host}");
        }
        SchemaSettingsProvider[] sspa = (SchemaSettingsProvider[])Application.get().getServiceArray(SchemaSettingsProvider.class);
        if (sspa != null) {
            for (SchemaSettingsProvider ssp : sspa) {
                this.addSettings(ssp);
            }
        }
        this.schemaLink.updateComponents((BufferedRecord)this.schema);
        this.checkPublicSchema.setEnabled(Application.get().isUserAdmin());
        this.checkPublicSchema.setSelected(this.schema.getUsrId() == null);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel, this.buttonTest, this.buttonIcon, this.buttonAddJdbcProperty, this.buttonAddUserProperty});
        this.updateIcon();
        this.pack();
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void addSettings(SchemaSettingsProvider ssp) {
        Component c = ssp.getSettingsComponent(this.schema.getSchId());
        this.settinsList.add(new SchemaSetting(ssp, c));
    }

    private void setSettingsVisible(String driverType) {
        for (SchemaSetting ss : this.settinsList) {
            if (ss.settings.isForDriverType(driverType)) {
                this.tabbetSettings.addTab(ss.settings.getDescription(), ss.settings.getIcon(), ss.component);
                continue;
            }
            this.tabbetSettings.remove(ss.component);
        }
    }

    private void applySettings() {
        for (SchemaSetting ss : this.settinsList) {
            if (!(ss.component instanceof ISettingsComponent)) continue;
            ISettingsComponent isc = (ISettingsComponent)ss.component;
            try {
                if (ss.component.isVisible()) {
                    isc.applySettings();
                    continue;
                }
                isc.cancelSettings();
            }
            catch (Throwable e) {
                ExceptionUtil.processException((Throwable)e);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)e.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cancelSettings() {
        for (SchemaSetting ss : this.settinsList) {
            if (!(ss.component instanceof ISettingsComponent)) continue;
            ISettingsComponent isc = (ISettingsComponent)ss.component;
            try {
                isc.cancelSettings();
            }
            catch (Throwable e) {
                ExceptionUtil.processException((Throwable)e);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)e.getMessage(), (int)1, (int)0);
            }
        }
    }

    public int getModalResult() {
        return this.modalResult;
    }

    private void updateIcon() {
        if (this.schema.fieldByName("sch_icon").getValue().isNullValue()) {
            this.cmSelectIcon.setSmallIcon(null);
        } else {
            try {
                this.cmSelectIcon.setSmallIcon((Icon)new ImageIcon(this.schema.fieldByName("sch_icon").getValue().getBinary()));
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    @Override
    public void dispose() {
        this.settinsList.clear();
        this.queryDrivers.close();
        super.dispose();
    }

    private void updateSchema() throws Exception {
        this.schemaLink.updateRecord((BufferedRecord)this.schema);
        if (this.checkPublicSchema.isSelected()) {
            this.schema.setUsrId(null);
        } else if (this.schema.getUsrId() == null) {
            this.schema.setUsrId(Application.get().getUserId());
        }
        if (this.schema.isChanged()) {
            if (this.sch_id == null) {
                this.schema.applyInsert();
                this.sch_id = this.schema.getSchId();
            } else {
                this.schema.applyUpdate();
            }
        }
        this.applySettings();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmRefreshUrl = new Action();
        this.cmSelectIcon = new Action();
        this.cmTest = new Action();
        this.cmAddJdbcProperty = new Action();
        this.cmAddUserProperties = new Action();
        this.tabbetSettings = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textSchName = new TextField();
        this.jLabel2 = new JLabel();
        this.comboSchDrvId = new ComboBox();
        this.jLabel3 = new JLabel();
        this.textSchHost = new TextField();
        this.jLabel4 = new JLabel();
        this.textSchUser = new TextField();
        this.jLabel5 = new JLabel();
        this.textSchPassword = new JPasswordField();
        this.jLabel6 = new JLabel();
        this.textSchDatabase = new TextField();
        this.jLabel7 = new JLabel();
        this.textSchPort = new TextField();
        this.labelDrvUrlTemplate = new JLabel();
        this.jLabel8 = new JLabel();
        this.textSchUrl = new TextField();
        this.jButton1 = new JButton();
        this.checkSchAutoCommit = new JCheckBox();
        this.checkPublicSchema = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.textProperties = new TextArea();
        this.jLabel10 = new JLabel();
        this.buttonAddJdbcProperty = new JButton();
        this.jPanel1 = new JPanel();
        this.buttonAddUserProperty = new JButton();
        this.jLabel11 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textUserProperties = new TextArea();
        this.buttonTest = new JButton();
        this.buttonIcon = new JButton();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmRefreshUrl.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshUrl.setTooltip(stringManager.getString("SchemaEditDialog-cmRefreshUrl-hint"));
        this.cmRefreshUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaEditDialog.this.cmRefreshUrlActionPerformed(evt);
            }
        });
        this.cmSelectIcon.setActionCommandKey("cmSelectIcon");
        this.cmSelectIcon.setText(stringManager.getString("SchemaEditDialog-cmSelectIcon-text"));
        this.cmSelectIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaEditDialog.this.cmSelectIconActionPerformed(evt);
            }
        });
        this.cmTest.setText(stringManager.getString("SchemaEditDialog-cmTest-text"));
        this.cmTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaEditDialog.this.cmTestActionPerformed(evt);
            }
        });
        this.cmAddJdbcProperty.setActionCommandKey("cmAddJdbcProperty");
        this.cmAddJdbcProperty.setText(stringManager.getString("SchemaEditDialog-cmAddJdbcProperty-text"));
        this.cmAddJdbcProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaEditDialog.this.cmAddJdbcPropertyActionPerformed(evt);
            }
        });
        this.cmAddUserProperties.setActionCommandKey("cmAddUserProperties");
        this.cmAddUserProperties.setText(stringManager.getString("SchemaEditDialog-cmAddUserProperties-text"));
        this.cmAddUserProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaEditDialog.this.cmAddUserPropertiesActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("SchemaEditDialog-title"));
        this.setModal(true);
        this.tabbetSettings.setFocusable(false);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor((Component)this.textSchName);
        this.jLabel1.setText(stringManager.getString("SchemaEditDialog-schema-name-dd"));
        this.textSchName.setToolTipText(stringManager.getString("SchemaEditDilalog-sch_name-hint"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setLabelFor((Component)this.comboSchDrvId);
        this.jLabel2.setText(stringManager.getString("SchemaEditDialog-driver-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setLabelFor((Component)this.textSchHost);
        this.jLabel3.setText(stringManager.getString("SchemaEditDialog-host-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setLabelFor((Component)this.textSchUser);
        this.jLabel4.setText(stringManager.getString("SchemaEditDialog-user-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setLabelFor(this.textSchPassword);
        this.jLabel5.setText(stringManager.getString("SchemaEditDialog-password-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setLabelFor((Component)this.textSchDatabase);
        this.jLabel6.setText(stringManager.getString("SchemaEditDialog-database-dd"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setLabelFor((Component)this.textSchPort);
        this.jLabel7.setText(stringManager.getString("SchemaEditDialog-port-dd"));
        this.labelDrvUrlTemplate.setText(" ");
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setLabelFor((Component)this.textSchUrl);
        this.jLabel8.setText(stringManager.getString("SchemaEditDialog-url-dd"));
        this.jButton1.setAction((javax.swing.Action)this.cmRefreshUrl);
        this.checkSchAutoCommit.setText(stringManager.getString("SchemaEditDialog-auto-commit"));
        this.checkPublicSchema.setText(stringManager.getString("SchemaEditDialog-all-show-schema"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel7, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel6, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel5, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 164, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkPublicSchema).addComponent(this.labelDrvUrlTemplate, -1, 333, Short.MAX_VALUE).addComponent((Component)this.comboSchDrvId, -1, 333, Short.MAX_VALUE).addComponent((Component)this.textSchPort, -2, 112, -2).addComponent(this.checkSchAutoCommit, GroupLayout.Alignment.TRAILING, -1, 333, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.textSchUrl, -1, 304, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 23, -2)).addComponent((Component)this.textSchName, GroupLayout.Alignment.TRAILING, -1, 333, Short.MAX_VALUE).addComponent((Component)this.textSchHost, GroupLayout.Alignment.TRAILING, -1, 333, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.textSchPassword, GroupLayout.Alignment.LEADING).addComponent((Component)this.textSchUser, GroupLayout.Alignment.LEADING, -2, 212, -2)).addComponent((Component)this.textSchDatabase, GroupLayout.Alignment.TRAILING, -1, 333, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textSchName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboSchDrvId, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textSchHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textSchUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.textSchPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textSchDatabase, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.textSchPort, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDrvUrlTemplate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1, -2, 23, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.textSchUrl, -2, -1, -2).addComponent(this.jLabel8))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSchAutoCommit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPublicSchema).addContainerGap(55, Short.MAX_VALUE)));
        this.tabbetSettings.addTab(stringManager.getString("SchemaEditDialog-general"), this.jPanel2);
        this.textProperties.setColumns(20);
        this.textProperties.setRows(5);
        this.textProperties.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane1.setViewportView((Component)this.textProperties);
        this.jLabel10.setText(stringManager.getString("SchemaEditDialog-jdbc-param-info-ext"));
        this.buttonAddJdbcProperty.setAction((javax.swing.Action)this.cmAddJdbcProperty);
        this.buttonAddJdbcProperty.setPreferredSize(new Dimension(85, 25));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addComponent(this.buttonAddJdbcProperty, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10, -1, 414, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 503, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 285, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.buttonAddJdbcProperty, -2, -1, -2)).addContainerGap()));
        this.tabbetSettings.addTab(stringManager.getString("SchemaEditDialog-jdbc-params"), this.jPanel3);
        this.buttonAddUserProperty.setAction((javax.swing.Action)this.cmAddUserProperties);
        this.buttonAddUserProperty.setPreferredSize(new Dimension(85, 25));
        this.jLabel11.setText(stringManager.getString("SchemaEditDialog-other-params-info-ext"));
        this.textUserProperties.setColumns(20);
        this.textUserProperties.setRows(5);
        this.textUserProperties.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane2.setViewportView((Component)this.textUserProperties);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 503, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.buttonAddUserProperty, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11, -1, 414, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 271, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.buttonAddUserProperty, -2, -1, -2)).addContainerGap()));
        this.tabbetSettings.addTab(stringManager.getString("SchemaEditDialog-other-params"), this.jPanel1);
        this.buttonTest.setAction((javax.swing.Action)this.cmTest);
        this.buttonTest.setMargin(new Insets(2, 2, 2, 2));
        this.buttonTest.setPreferredSize(new Dimension(85, 25));
        this.buttonIcon.setAction((javax.swing.Action)this.cmSelectIcon);
        this.buttonIcon.setMargin(new Insets(2, 2, 2, 2));
        this.buttonIcon.setPreferredSize(new Dimension(85, 25));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbetSettings, -1, 528, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonTest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonIcon, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 176, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbetSettings, -1, 366, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonTest, -2, -1, -2).addComponent(this.buttonIcon, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmRefreshUrlActionPerformed(ActionEvent evt) {
        try {
            this.updateSchema();
            this.textSchUrl.setText(this.schema.replacePatts(this.labelDrvUrlTemplate.getText()));
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.cancelSettings();
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.updateSchema();
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmSelectIconActionPerformed(ActionEvent evt) {
        File file;
        if (!this.schema.fieldByName("sch_icon").getValue().isNullValue()) {
            switch (MessageBox.show((Component)this, (String)stringManager.getString("SchemaEditDialog-icon"), (String)stringManager.getString("SchemaEditDialog-icon-selected-q"), (int[])ModalResult.YESNOCANCEL, (int)3)) {
                case 2: {
                    return;
                }
                case 5: {
                    this.schema.fieldByName("sch_icon").setValue(null);
                    this.updateIcon();
                    return;
                }
            }
        }
        if ((file = FileUtil.selectFileToOpen((Component)this, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("SchemaEditDialog-pic-file"), new String[]{".jpg", ".jpeg", ".gif", ".png"})})) != null) {
            try {
                this.schema.fieldByName("sch_icon").setValue(new Variant(StreamUtil.stream2Array((InputStream)new FileInputStream(file))));
                this.updateIcon();
            }
            catch (IOException ex) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
            }
        }
    }

    private void cmTestActionPerformed(ActionEvent evt) {
        try {
            this.schemaLink.updateRecord((BufferedRecord)this.schema);
            TaskPool.getTaskPool().addTask(new Task(stringManager.getString("SchemaEditDialog-connection-testing")){
                String url;
                String user;
                String password;
                {
                    this.url = SchemaEditDialog.this.textSchUrl.getText();
                    this.user = SchemaEditDialog.this.textSchUser.getText();
                    this.password = new String(SchemaEditDialog.this.textSchPassword.getPassword());
                }

                public void run() {
                    WaitDialog.showWaitDialog((String)this.getDescription(), (int)100);
                    try {
                        ConnectionFactory cf = ConnectionFactory.createInstance(this.url, this.user, this.password, SchemaEditDialog.this.schema);
                        Database database = cf.createDatabase(true);
                        database.close();
                        WaitDialog.hideWaitDialog();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox.show((Component)SchemaEditDialog.this, (String)stringManager.getString("SchemaEditDialog-success"), (String)stringManager.getString("SchemaEditDialog-test-success"), (int)1, (int)1);
                            }
                        });
                    }
                    catch (Throwable ex) {
                        WaitDialog.hideWaitDialog();
                        ExceptionUtil.processException((Throwable)ex);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox.show((Component)SchemaEditDialog.this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                            }
                        });
                    }
                }
            });
        }
        catch (UseDBException ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmAddJdbcPropertyActionPerformed(ActionEvent evt) {
        try {
            this.schemaLink.updateRecord((BufferedRecord)this.schema);
            pl.mpak.orbada.db.Driver driver = new pl.mpak.orbada.db.Driver(InternalDatabase.get(), this.schema.getDrvId());
            Driver sqlDriver = DriverClassLoaderManager.getDriver(driver.fieldByName("DRV_LIBRARY_SOURCE").getValue().toString(), driver.fieldByName("DRV_EXTRA_LIBRARY").getValue().toString(), driver.fieldByName("drv_class_name").getValue().toString());
            DriverPropertyInfo[] dpi = sqlDriver.getPropertyInfo(this.schema.replacePatts(driver.fieldByName("drv_url_template").getString()), new Properties());
            String[] propList = new String[dpi.length];
            for (int i = 0; i < dpi.length; ++i) {
                propList[i] = dpi[i].name;
            }
            String property = PropertyDialog.show(propList);
            if (property != null) {
                if (this.textProperties.getText().length() > 0) {
                    this.textProperties.append("\n");
                }
                this.textProperties.append(property);
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)String.format(stringManager.getString("SchemaEditDialog-problem-on-load-driver"), ex.getMessage()), (int)1, (int)0);
        }
    }

    private void cmAddUserPropertiesActionPerformed(ActionEvent evt) {
        String property = PropertyDialog.show(Database.useDbParameters);
        if (property != null) {
            if (this.textUserProperties.getText().length() > 0) {
                this.textUserProperties.append("\n");
            }
            this.textUserProperties.append(property);
        }
    }

    private final class SchemaSetting {
        private SchemaSettingsProvider settings;
        private Component component;

        public SchemaSetting(SchemaSettingsProvider settings, Component component) {
            this.settings = settings;
            this.component = component;
        }
    }
}

