/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.schemas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.ConnectionFactory;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Schema;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.schemas.DriverListDialog;
import pl.mpak.orbada.gui.schemas.SchemaEditDialog;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryComboBoxModel;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPool;
import pl.mpak.util.variant.Variant;

public class SchemaListDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ISettings settings;
    private Query queryDrivers;
    private Query queryHosts;
    private Query queryUsers;
    private JButton buttonClose;
    private JButton buttonConnect;
    private JButton buttonDelete;
    private JButton buttonDrivers;
    private JButton buttonEdit;
    private JButton buttonFunctions;
    private JButton buttonNew;
    private Action cmClone;
    private Action cmClose;
    private Action cmConnect;
    private Action cmDelete;
    private Action cmDrivers;
    private Action cmEdit;
    private Action cmExport;
    private Action cmFunctions;
    private Action cmImport;
    private Action cmNew;
    private ComboBox comboDriver;
    private ComboBox comboHost;
    private ComboBox comboUser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JMenuItem menuClone;
    private JMenuItem menuExport;
    private JMenuItem menuImport;
    private JPopupMenu popupFunctions;
    private ViewTable tableSchemas;
    private TextField textSchHost;
    private JPasswordField textSchPassword;
    private TextField textSchUrl;
    private TextField textSchUser;

    public SchemaListDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaListDialog dialog = new SchemaListDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        try {
            this.queryDrivers = InternalDatabase.get().createQuery();
            this.queryDrivers.setCacheData(true);
            this.queryDrivers.open("select cast(null as varchar(100)) sname from dual union select distinct drv_name sname from schemas, drivers where sch_drv_id = drv_id order by 1");
            this.queryHosts = InternalDatabase.get().createQuery();
            this.queryHosts.setCacheData(true);
            this.queryHosts.open("select cast(null as varchar(100)) sname from dual union select distinct upper(sch_host) sname from schemas where sch_host is not null order by 1");
            this.queryUsers = InternalDatabase.get().createQuery();
            this.queryUsers.setCacheData(true);
            this.queryUsers.open("select cast(null as varchar(100)) sname from dual union select distinct upper(sch_user) sname from schemas order by 1");
            this.comboDriver.setModel((ComboBoxModel)new QueryComboBoxModel(this.queryDrivers, "sname"));
            this.comboHost.setModel((ComboBoxModel)new QueryComboBoxModel(this.queryHosts, "sname"));
            this.comboUser.setModel((ComboBoxModel)new QueryComboBoxModel(this.queryUsers, "sname"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.settings = Application.get().getSettings("orbada-schema-list-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.comboDriver.setText(this.settings.getValue("driver-selected", (String)null));
        this.comboHost.setText(this.settings.getValue("host-selected", (String)null));
        this.comboUser.setText(this.settings.getValue("user-selected", (String)null));
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.getRootPane().setDefaultButton(this.buttonConnect);
        TableRowChangeKeyListener trckl = new TableRowChangeKeyListener((JTable)((Object)this.tableSchemas));
        this.textSchHost.addKeyListener((KeyListener)trckl);
        this.textSchUser.addKeyListener((KeyListener)trckl);
        this.textSchPassword.addKeyListener((KeyListener)trckl);
        this.textSchUrl.addKeyListener((KeyListener)trckl);
        this.tableSchemas.getQuery().setDatabase(InternalDatabase.get());
        this.tableSchemas.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void afterOpen(EventObject e) {
                SchemaListDialog.this.cmNew.setEnabled(true);
                SchemaListDialog.this.cmImport.setEnabled(true);
            }

            public void afterClose(EventObject e) {
                SchemaListDialog.this.cmNew.setEnabled(false);
                SchemaListDialog.this.cmClone.setEnabled(false);
                SchemaListDialog.this.cmEdit.setEnabled(false);
                SchemaListDialog.this.cmDelete.setEnabled(false);
                SchemaListDialog.this.cmExport.setEnabled(false);
                SchemaListDialog.this.cmImport.setEnabled(false);
            }
        });
        this.tableSchemas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SchemaListDialog.this.cmConnect.setEnabled(e.getFirstIndex() >= 0);
                SchemaListDialog.this.cmClone.setEnabled(e.getFirstIndex() >= 0);
                SchemaListDialog.this.cmEdit.setEnabled(e.getFirstIndex() >= 0);
                SchemaListDialog.this.cmDelete.setEnabled(e.getFirstIndex() >= 0);
                SchemaListDialog.this.cmExport.setEnabled(e.getFirstIndex() >= 0);
                int rowIndex = SchemaListDialog.this.tableSchemas.getSelectedRow();
                if (rowIndex >= 0 && SchemaListDialog.this.tableSchemas.getQuery().isActive()) {
                    try {
                        SchemaListDialog.this.tableSchemas.getQuery().getRecord(rowIndex);
                        SchemaListDialog.this.textSchHost.setText(SchemaListDialog.this.tableSchemas.getQuery().fieldByName("sch_host").getString());
                        SchemaListDialog.this.textSchUser.setText(SchemaListDialog.this.tableSchemas.getQuery().fieldByName("sch_user").getString());
                        SchemaListDialog.this.textSchPassword.setText(SchemaListDialog.this.tableSchemas.getQuery().fieldByName("sch_password").getString());
                        SchemaListDialog.this.textSchUrl.setText(SchemaListDialog.this.tableSchemas.getQuery().fieldByName("sch_url").getString());
                        if (SchemaListDialog.this.tableSchemas.getQuery().fieldByName("sch_usr_id").isNull()) {
                            SchemaListDialog.this.cmEdit.setEnabled(Application.get().isUserAdmin());
                            SchemaListDialog.this.cmDelete.setEnabled(Application.get().isUserAdmin());
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    SchemaListDialog.this.textSchHost.setText("");
                    SchemaListDialog.this.textSchUser.setText("");
                    SchemaListDialog.this.textSchPassword.setText("");
                    SchemaListDialog.this.textSchUrl.setText("");
                }
            }
        });
        try {
            this.tableSchemas.addColumn((TableColumn)new QueryTableColumn("sch_public_name", stringManager.getString("SchemaListDialog-schema-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableSchemas.addColumn((TableColumn)new QueryTableColumn("sch_user", stringManager.getString("SchemaListDialog-user"), 70));
            this.tableSchemas.addColumn((TableColumn)new QueryTableColumn("sch_selected", stringManager.getString("SchemaListDialog-selected"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableSchemas.addColumn((TableColumn)new QueryTableColumn("drv_name", stringManager.getString("SchemaListDialog-driver"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)));
            this.tableSchemas.addColumn((TableColumn)new QueryTableColumn("sch_db_version", stringManager.getString("SchemaListDialog-version"), 70));
            this.tableSchemas.addColumn((TableColumn)new QueryTableColumn("sch_url", stringManager.getString("SchemaListDialog-connection-url"), 250));
            this.tableSchemas.getQuery().setSqlText("select sch_id, sch_name, sch_public_name, drv_name, drv_type_name, drv_class_name, sch_host, sch_user, sch_password, sch_url, sch_db_version, sch_selected, sch_usr_id\n  from schemas left outer join drivers on (sch_drv_id = drv_id)\n where (sch_usr_id = :sch_usr_id or sch_usr_id is null)\n   and (upper(sch_host) = :SCH_HOST or :SCH_HOST is null)\n   and (drv_name = :DRV_NAME or :DRV_NAME is null)\n   and (upper(sch_user) = :SCH_USER or :SCH_USER is null)\n order by sch_selected desc, sch_name");
            this.refreshQuery(null);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        int height = SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonFunctions, this.buttonEdit, this.buttonDelete, this.buttonDrivers});
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonConnect, this.buttonClose}, (int)height);
        this.textSchPassword.requestFocusInWindow();
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        this.settings.setValue("driver-selected", this.comboDriver.getText());
        this.settings.setValue("host-selected", this.comboHost.getText());
        this.settings.setValue("user-selected", this.comboUser.getText());
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        if (this.queryDrivers != null) {
            this.queryDrivers.close();
        }
        if (this.queryHosts != null) {
            this.queryHosts.close();
        }
        if (this.queryUsers != null) {
            this.queryUsers.close();
        }
        this.tableSchemas.getQuery().close();
        super.dispose();
    }

    public void refreshQuery(final String sch_id) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lastRow = SchemaListDialog.this.tableSchemas.getSelectedRow();
                try {
                    String id = sch_id;
                    if (id == null && SchemaListDialog.this.tableSchemas.getQuery().isActive() && lastRow >= 0) {
                        SchemaListDialog.this.tableSchemas.getQuery().getRecord(lastRow);
                        id = SchemaListDialog.this.tableSchemas.getQuery().fieldByName("sch_id").getString();
                    }
                    SchemaListDialog.this.tableSchemas.getQuery().close();
                    SchemaListDialog.this.tableSchemas.getQuery().paramByName("sch_usr_id").setString(Application.get().getUserId());
                    SchemaListDialog.this.tableSchemas.getQuery().paramByName("SCH_HOST").setString(SchemaListDialog.this.comboHost.getText());
                    SchemaListDialog.this.tableSchemas.getQuery().paramByName("DRV_NAME").setString(SchemaListDialog.this.comboDriver.getText());
                    SchemaListDialog.this.tableSchemas.getQuery().paramByName("SCH_USER").setString(SchemaListDialog.this.comboUser.getText());
                    SchemaListDialog.this.tableSchemas.getQuery().open();
                    if (id != null && SchemaListDialog.this.tableSchemas.getQuery().locate("SCH_ID", new Variant(id))) {
                        SchemaListDialog.this.tableSchemas.changeSelection(SchemaListDialog.this.tableSchemas.getQuery().getCurrentRecord().getIndex(), 0);
                    } else if (SchemaListDialog.this.tableSchemas.getRowCount() > lastRow && lastRow >= 0) {
                        SchemaListDialog.this.tableSchemas.setRowSelectionInterval(lastRow, lastRow);
                    } else if (SchemaListDialog.this.tableSchemas.getRowCount() > 0) {
                        SchemaListDialog.this.tableSchemas.setRowSelectionInterval(0, 0);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void focusPassword() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaListDialog.this.textSchPassword.requestFocusInWindow();
            }
        });
    }

    private void refreshFilters() {
        try {
            final String driver = this.comboDriver.getText();
            final String host = this.comboHost.getText();
            final String user = this.comboUser.getText();
            this.queryDrivers.refresh();
            this.queryHosts.refresh();
            this.queryUsers.refresh();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SchemaListDialog.this.comboDriver.setModel((ComboBoxModel)new QueryComboBoxModel(SchemaListDialog.this.queryDrivers, "sname"));
                    SchemaListDialog.this.comboHost.setModel((ComboBoxModel)new QueryComboBoxModel(SchemaListDialog.this.queryHosts, "sname"));
                    SchemaListDialog.this.comboUser.setModel((ComboBoxModel)new QueryComboBoxModel(SchemaListDialog.this.queryUsers, "sname"));
                    SchemaListDialog.this.comboDriver.setSelectedItem((Object)driver);
                    SchemaListDialog.this.comboHost.setSelectedItem((Object)host);
                    SchemaListDialog.this.comboUser.setSelectedItem((Object)user);
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.cmConnect = new Action();
        this.cmDrivers = new Action();
        this.cmClone = new Action();
        this.cmFunctions = new Action();
        this.popupFunctions = new JPopupMenu();
        this.menuClone = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuExport = new JMenuItem();
        this.menuImport = new JMenuItem();
        this.cmExport = new Action();
        this.cmImport = new Action();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textSchHost = new TextField();
        this.jLabel2 = new JLabel();
        this.textSchUser = new TextField();
        this.jLabel3 = new JLabel();
        this.textSchPassword = new JPasswordField();
        this.jLabel4 = new JLabel();
        this.textSchUrl = new TextField();
        this.jScrollPane1 = new JScrollPane();
        this.tableSchemas = new ViewTable();
        this.jLabel5 = new JLabel();
        this.comboDriver = new ComboBox();
        this.comboHost = new ComboBox();
        this.jLabel6 = new JLabel();
        this.comboUser = new ComboBox();
        this.jLabel7 = new JLabel();
        this.buttonNew = new JButton();
        this.buttonFunctions = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.buttonDrivers = new JButton();
        this.buttonConnect = new JButton();
        this.buttonClose = new JButton();
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmNew.setActionCommandKey("cmNew");
        this.cmNew.setEnabled(false);
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setActionCommandKey("cmEdit");
        this.cmEdit.setEnabled(false);
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setActionCommandKey("cmDelete");
        this.cmDelete.setEnabled(false);
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmConnect.setActionCommandKey("cmConnect");
        this.cmConnect.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmConnect.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/connect16.gif"));
        this.cmConnect.setText(stringManager.getString("cmConnect-text"));
        this.cmConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmConnectActionPerformed(evt);
            }
        });
        this.cmDrivers.setActionCommandKey("cmDrivers");
        this.cmDrivers.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/driverproperties.gif"));
        this.cmDrivers.setText(stringManager.getString("SchemaListDialog-cmDriver-text"));
        this.cmDrivers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmDriversActionPerformed(evt);
            }
        });
        this.cmClone.setActionCommandKey("cmClone");
        this.cmClone.setEnabled(false);
        this.cmClone.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/copy.gif"));
        this.cmClone.setText(stringManager.getString("SchemaListDialog-cmClone-text"));
        this.cmClone.setTooltip(stringManager.getString("SchemaListDialog-cmClone-hint"));
        this.cmClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmCloneActionPerformed(evt);
            }
        });
        this.cmFunctions.setActionCommandKey("cmFunctions");
        this.cmFunctions.setText(stringManager.getString("SchemaListDialog-cmFunctions-text"));
        this.cmFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmFunctionsActionPerformed(evt);
            }
        });
        this.menuClone.setAction((javax.swing.Action)this.cmClone);
        this.popupFunctions.add(this.menuClone);
        this.popupFunctions.add(this.jSeparator1);
        this.menuExport.setAction((javax.swing.Action)this.cmExport);
        this.popupFunctions.add(this.menuExport);
        this.menuImport.setAction((javax.swing.Action)this.cmImport);
        this.popupFunctions.add(this.menuImport);
        this.cmExport.setActionCommandKey("cmExport");
        this.cmExport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/export.gif"));
        this.cmExport.setText(stringManager.getString("SchemaListDialog-cmExport-text"));
        this.cmExport.setTooltip(stringManager.getString("SchemaListDialog-cmExport-hint"));
        this.cmExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmExportActionPerformed(evt);
            }
        });
        this.cmImport.setActionCommandKey("cmImport");
        this.cmImport.setEnabled(false);
        this.cmImport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/import.gif"));
        this.cmImport.setText(stringManager.getString("SchemaListDialog-cmImport-text"));
        this.cmImport.setTooltip(stringManager.getString("SchemaListDialog-cmImport-hint"));
        this.cmImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaListDialog.this.cmImportActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("SchemaListDialog-title"));
        this.setModal(true);
        this.jPanel1.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.jPanel1.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        this.jLabel1.setLabelFor((Component)this.textSchHost);
        this.jLabel1.setText(stringManager.getString("SchemaListDialog-host-dd"));
        this.textSchHost.setEditable(false);
        this.textSchHost.setFocusable(false);
        this.jLabel2.setLabelFor((Component)this.textSchUser);
        this.jLabel2.setText(stringManager.getString("SchemaListDialog-user-dd"));
        this.jLabel3.setLabelFor(this.textSchPassword);
        this.jLabel3.setText(stringManager.getString("SchemaListDialog-password-dd"));
        this.jLabel4.setLabelFor((Component)this.textSchUrl);
        this.jLabel4.setText(stringManager.getString("SchemaListDialog-url-dd"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap()).addComponent((Component)this.textSchUser, -1, 217, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addContainerGap()).addComponent(this.textSchPassword, -1, 217, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addContainerGap()).addComponent((Component)this.textSchUrl, -1, 217, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap()).addComponent((Component)this.textSchHost, -1, 217, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSchHost, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSchUser, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textSchPassword, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSchUrl, -2, -1, -2).addContainerGap(180, Short.MAX_VALUE)));
        this.tableSchemas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SchemaListDialog.this.tableSchemasMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)((Object)this.tableSchemas));
        this.jLabel5.setText(stringManager.getString("SchemaListDialog-driver-dd"));
        this.comboDriver.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SchemaListDialog.this.comboDriverItemStateChanged(evt);
            }
        });
        this.comboHost.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SchemaListDialog.this.comboHostItemStateChanged(evt);
            }
        });
        this.jLabel6.setText(stringManager.getString("SchemaListDialog-host-dd"));
        this.comboUser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SchemaListDialog.this.comboUserItemStateChanged(evt);
            }
        });
        this.jLabel7.setText(stringManager.getString("SchemaListDialog-user-dd"));
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonFunctions.setAction((javax.swing.Action)this.cmFunctions);
        this.buttonFunctions.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFunctions.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.buttonDrivers.setAction((javax.swing.Action)this.cmDrivers);
        this.buttonDrivers.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDrivers.setPreferredSize(new Dimension(95, 25));
        this.buttonConnect.setAction((javax.swing.Action)this.cmConnect);
        this.buttonConnect.setMargin(new Insets(2, 2, 2, 2));
        this.buttonConnect.setPreferredSize(new Dimension(85, 25));
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 551, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent((Component)this.comboDriver, -1, 186, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent((Component)this.comboHost, -1, 176, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.comboUser, -1, 177, Short.MAX_VALUE).addComponent(this.jLabel7))).addGroup(layout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 98, Short.MAX_VALUE).addComponent(this.buttonFunctions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDrivers, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.buttonConnect, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose, -2, -1, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.comboHost, -2, -1, -2).addComponent((Component)this.comboUser, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboDriver, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 311, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonClose, -2, -1, -2).addComponent(this.buttonConnect, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2).addComponent(this.buttonDrivers, -2, -1, -2).addComponent(this.buttonFunctions, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmConnectActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSchemas.getSelectedRow() >= 0) {
                this.tableSchemas.getQuery().getRecord(this.tableSchemas.getSelectedRow());
                TaskPool.getTaskPool().addTask(new Task(stringManager.getString("SchemaListDialog-connecting")){
                    String url;
                    String user;
                    String password;
                    String sch_id;
                    {
                        this.url = SchemaListDialog.this.textSchUrl.getText();
                        this.user = SchemaListDialog.this.textSchUser.getText();
                        this.password = new String(SchemaListDialog.this.textSchPassword.getPassword());
                        this.sch_id = SchemaListDialog.this.tableSchemas.getQuery().fieldByName("sch_id").getString();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        final PleaseWait wait = new PleaseWait(ImageManager.getImage((String)"/res/orbada48.png"), this.getDescription());
                        Application.get().startPleaseWait(wait);
                        try {
                            ConnectionFactory cf = ConnectionFactory.createInstance(this.url, this.user, this.password, this.sch_id);
                            cf.createDatabase();
                        }
                        catch (Exception ex) {
                            try {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Application.get().stopPleaseWait(wait);
                                        MessageBox.show((Component)SchemaListDialog.this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                                        ExceptionUtil.processException((Throwable)ex);
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                EventQueue.invokeLater(new Runnable(wait){
                                    final /* synthetic */ PleaseWait val$wait;
                                    {
                                        this.val$wait = pleaseWait;
                                    }

                                    @Override
                                    public void run() {
                                        Application.get().stopPleaseWait(this.val$wait);
                                    }
                                });
                                throw throwable;
                            }
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
                if ((evt.getModifiers() & 2) != 2) {
                    this.dispose();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        if (this.tableSchemas.getQuery().isActive() && this.tableSchemas.getSelectedRow() >= 0) {
            try {
                this.tableSchemas.getQuery().getRecord(this.tableSchemas.getSelectedRow());
                String sch_id = this.tableSchemas.getQuery().fieldByName("sch_id").getString();
                String sch_name = this.tableSchemas.getQuery().fieldByName("SCH_NAME").getString();
                if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)String.format(stringManager.getString("SchemaListDialog-delete-schema-q"), sch_id, sch_name), (int[])ModalResult.YESNO, (int)3) == 5) {
                    Schema schema = new Schema(InternalDatabase.get());
                    schema.getPrimaryKeyField().setValue(new Variant(sch_id));
                    schema.applyDelete();
                    Application.get().postPluginMessage(new PluginMessage(null, "schema-deleted", (Object)sch_id));
                    this.refreshFilters();
                    this.refreshQuery(null);
                    this.focusPassword();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSchemas.getQuery().isActive() && this.tableSchemas.getSelectedRow() >= 0) {
                this.tableSchemas.getQuery().getRecord(this.tableSchemas.getSelectedRow());
                String sch_id = this.tableSchemas.getQuery().fieldByName("sch_id").getString();
                if (SchemaEditDialog.showDialog(sch_id) != null) {
                    Application.get().postPluginMessage(new PluginMessage(null, "schema-updated", (Object)sch_id));
                    this.refreshFilters();
                    this.refreshQuery(sch_id);
                    this.focusPassword();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            String sch_id;
            if (this.tableSchemas.getQuery().isActive() && (sch_id = SchemaEditDialog.showDialog((String)null)) != null) {
                Application.get().postPluginMessage(new PluginMessage(null, "schema-inserted", (Object)sch_id));
                this.refreshFilters();
                this.refreshQuery(sch_id);
                this.focusPassword();
            }
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmDriversActionPerformed(ActionEvent evt) {
        DriverListDialog.showDialog();
    }

    private void tableSchemasMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.cmConnect.performe();
        }
    }

    private void cmCloneActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSchemas.getQuery().isActive() && this.tableSchemas.getSelectedRow() >= 0) {
                this.tableSchemas.getQuery().getRecord(this.tableSchemas.getSelectedRow());
                Schema schema = new Schema(InternalDatabase.get(), this.tableSchemas.getQuery().fieldByName("sch_id").getString());
                String sch_id = SchemaEditDialog.showDialog(schema);
                if (sch_id != null) {
                    Application.get().postPluginMessage(new PluginMessage(null, "schema-inserted", (Object)sch_id));
                    this.refreshFilters();
                    this.refreshQuery(sch_id);
                    this.focusPassword();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void comboDriverItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.refreshQuery(null);
        }
    }

    private void comboHostItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.refreshQuery(null);
        }
    }

    private void comboUserItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.refreshQuery(null);
        }
    }

    private void cmFunctionsActionPerformed(ActionEvent evt) {
        this.popupFunctions.show(this.buttonFunctions, 0, this.buttonFunctions.getHeight());
    }

    private void cmExportActionPerformed(ActionEvent evt) {
        try {
            File file;
            if (this.tableSchemas.getQuery().isActive() && this.tableSchemas.getSelectedRow() >= 0 && (file = FileUtil.selectFileToSave((Component)this, (String)stringManager.getString("SchemaListDialog-save-schema"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("SchemaListDialog-schema-file"), new String[]{".xml.oconnschema"})})) != null) {
                this.tableSchemas.getQuery().getRecord(this.tableSchemas.getSelectedRow());
                Schema schema = new Schema(InternalDatabase.get(), this.tableSchemas.getQuery().fieldByName("sch_id").getString());
                schema.storeToXML((OutputStream)new FileOutputStream(file), null, "utf-8");
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmImportActionPerformed(ActionEvent evt) {
        try {
            File file;
            if (this.tableSchemas.getQuery().isActive() && (file = FileUtil.selectFileToOpen((Component)this, (String)stringManager.getString("SchemaListDialog-open-schema"), (File)null, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("SchemaListDialog-schema-file"), new String[]{".xml.oconnschema"})})) != null) {
                Schema schema = new Schema(InternalDatabase.get());
                schema.loadFromXML((InputStream)new FileInputStream(file));
                String sch_id = SchemaEditDialog.showDialog(schema);
                if (sch_id != null) {
                    Application.get().postPluginMessage(new PluginMessage(null, "schema-inserted", (Object)sch_id));
                    this.refreshFilters();
                    this.refreshQuery(sch_id);
                    this.focusPassword();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

