/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.schemas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SelectUrlTemplateDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private String driverName;
    private String driverClass;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JScrollPane jScrollPane1;
    private JList listViews;

    public SelectUrlTemplateDialog(String driverName, String driverClass) {
        super(SwingUtil.getRootFrame());
        this.driverName = driverName;
        this.driverClass = driverClass;
        this.initComponents();
        this.init();
    }

    public static String show(String driverName, String driverClass) {
        SelectUrlTemplateDialog dialog = new SelectUrlTemplateDialog(driverName, driverClass);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            return ((UrlTemplate)dialog.listViews.getSelectedValue()).url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.listViews.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof UrlTemplate) {
                    UrlTemplate ut = (UrlTemplate)value;
                    String url = ut.url;
                    url = StringUtil.replaceString((String)url, (String)"<", (String)"&lt;");
                    url = StringUtil.replaceString((String)url, (String)">", (String)"&gt;");
                    label.setText("<html><b>" + ut.name + "</b> - " + url);
                    label.setVerticalAlignment(1);
                }
                return label;
            }
        });
        this.listViews.setModel(new DefaultListModel());
        Query query = InternalDatabase.get().createQuery();
        try {
            query.setSqlText("select dts_name, dts_url_template\n  from driver_types, driver_type_specs\n where dts_dtp_id = dtp_id\n   and dtp_name = :DTP_NAME\n   and dts_class = :DTS_CLASS");
            query.paramByName("DTP_NAME").setString(this.driverName);
            query.paramByName("DTS_CLASS").setString(this.driverClass);
            query.open();
            while (!query.eof()) {
                ((DefaultListModel)this.listViews.getModel()).addElement(new UrlTemplate(query.fieldByName("DTS_NAME").getString(), query.fieldByName("DTS_URL_TEMPLATE").getString()));
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.cmOk.setEnabled(false);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectUrlTemplateDialog.this.listViews.requestFocus();
            }
        });
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmOk = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.listViews = new JList();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectUrlTemplateDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setText(stringManager.getString("SelectUrlTemplateDialog-cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectUrlTemplateDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("SelectUrlTemplateDialog-title"));
        this.setModal(true);
        this.listViews.setFixedCellHeight(20);
        this.listViews.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SelectUrlTemplateDialog.this.listViewsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listViews);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 394, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 173, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void listViewsValueChanged(ListSelectionEvent evt) {
        this.cmOk.setEnabled(this.listViews.getSelectedIndex() != -1);
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    class UrlTemplate {
        public String name;
        public String url;

        UrlTemplate(String name, String url) {
            this.name = name;
            this.url = url;
        }
    }
}

