/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.templates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.IntrospectionException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.gui.editor.EditorPopupMenu;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class TemplateEditDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private String tpl_id;
    private int modalResult = 0;
    private Template template;
    private RecordLink templateLink;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkAllUsers;
    private Action cmCancel;
    private Action cmOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textDescription;
    private TextField textName;
    private SyntaxTextArea textTemplate;

    public TemplateEditDialog(String tpl_id) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.tpl_id = tpl_id;
        this.initComponents();
        this.init();
    }

    public static int showDialog(String tpl_id) throws IntrospectionException, UseDBException {
        TemplateEditDialog dialog = new TemplateEditDialog(tpl_id);
        dialog.setVisible(true);
        return dialog.getModalResult();
    }

    private void init() throws IntrospectionException, UseDBException {
        SwingUtil.centerWithinScreen((Window)this);
        this.textTemplate.getEditorArea().setComponentPopupMenu((JPopupMenu)((Object)new EditorPopupMenu(this.textTemplate)));
        this.templateLink = new RecordLink();
        this.templateLink.add("TPL_NAME", (Component)this.textName);
        this.templateLink.add("TPL_DESCRIPTION", (Component)this.textDescription);
        this.templateLink.add("TPL_BODY", (Component)this.textTemplate);
        if (this.tpl_id != null) {
            this.template = new Template(InternalDatabase.get(), this.tpl_id);
        } else {
            this.template = new Template(InternalDatabase.get());
            this.template.setUsrId(Application.get().getUserId());
        }
        this.templateLink.updateComponents((BufferedRecord)this.template);
        this.checkAllUsers.setSelected(StringUtil.isEmpty((String)this.template.getUsrId()));
        this.checkAllUsers.setEnabled(Application.get().isUserAdmin());
        if (!Application.get().isUserAdmin() && StringUtil.isEmpty((String)this.template.getUsrId())) {
            this.textName.setEditable(false);
            this.textDescription.setEditable(false);
            this.textTemplate.setEditable(false);
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
    }

    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jLabel1 = new JLabel();
        this.textName = new TextField();
        this.jLabel2 = new JLabel();
        this.textDescription = new TextField();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel3 = new JLabel();
        this.checkAllUsers = new JCheckBox();
        this.textTemplate = new SyntaxTextArea();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("TemplateEditDialog-title"));
        this.setModal(true);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor((Component)this.textName);
        this.jLabel1.setText(stringManager.getString("TemplateEditDialog-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setLabelFor((Component)this.textName);
        this.jLabel2.setText(stringManager.getString("TemplateEditDialog-description-dd"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel3.setLabelFor((Component)this.textName);
        this.jLabel3.setText(stringManager.getString("TemplateEditDialog-template-dd"));
        this.checkAllUsers.setText(stringManager.getString("TemplateEditDialog-for-all-users"));
        this.checkAllUsers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TemplateEditDialog.this.checkAllUsersItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textTemplate, -1, 633, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -2, 138, -2)).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkAllUsers).addComponent((Component)this.textDescription, -1, 491, Short.MAX_VALUE).addComponent((Component)this.textName, -2, 225, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkAllUsers).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTemplate, -1, 302, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.templateLink.updateRecord((BufferedRecord)this.template);
            if (this.template.isChanged()) {
                if (this.tpl_id == null) {
                    this.template.applyInsert();
                } else {
                    this.template.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void checkAllUsersItemStateChanged(ItemEvent evt) {
        if (this.checkAllUsers.isSelected()) {
            this.template.setUsrId("");
        } else {
            this.template.setUsrId(Application.get().getUserId());
        }
    }
}

