/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.templates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.FocusManager;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.templates.TemplateEditDialog;
import pl.mpak.orbada.gui.templates.TemplateUseDialog;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TemplateListDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ISettings settings;
    private int modalResult = 0;
    private String tpl_id;
    private SyntaxEditor editor;
    private JButton buttonClose;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonNew;
    private JButton buttonUse;
    private Action cmClose;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmNew;
    private Action cmUse;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable tableTemplates;
    private TextField textFiltr;

    public TemplateListDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateListDialog dialog = new TemplateListDialog();
                dialog.setVisible(true);
                if (dialog.modalResult == 1) {
                    TemplateUseDialog.showDialog(dialog.tpl_id, dialog.editor);
                }
            }
        });
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-template-list-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.tableTemplates.getQuery().setDatabase(InternalDatabase.get());
        this.tableTemplates.getQuery().addQueryListener(new QueryListener(){

            public void beforeScroll(EventObject e) {
            }

            public void afterScroll(EventObject e) {
            }

            public void beforeOpen(EventObject e) {
            }

            public void afterOpen(EventObject e) {
                TemplateListDialog.this.cmNew.setEnabled(true);
            }

            public void beforeClose(EventObject e) {
            }

            public void afterClose(EventObject e) {
                TemplateListDialog.this.cmNew.setEnabled(false);
                TemplateListDialog.this.cmEdit.setEnabled(false);
                TemplateListDialog.this.cmDelete.setEnabled(false);
            }

            public void flushedPerformed(EventObject e) {
            }

            public void errorPerformed(EventObject e) {
            }
        });
        this.tableTemplates.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TemplateListDialog.this.tableTemplates.getSelectedRow() >= 0) {
                    try {
                        TemplateListDialog.this.tableTemplates.getQuery().getRecord(TemplateListDialog.this.tableTemplates.getSelectedRow());
                        TemplateListDialog.this.cmEdit.setEnabled(true);
                        TemplateListDialog.this.cmDelete.setEnabled(!TemplateListDialog.this.tableTemplates.getQuery().fieldByName("TPL_USR_ID").isNull() || Application.get().isUserAdmin());
                        TemplateListDialog.this.cmUse.setEnabled(TemplateListDialog.this.buttonUse.isVisible());
                    }
                    catch (Exception ex) {
                        MessageBox.show((Component)TemplateListDialog.this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                    }
                } else {
                    TemplateListDialog.this.cmEdit.setEnabled(false);
                    TemplateListDialog.this.cmDelete.setEnabled(false);
                    TemplateListDialog.this.cmUse.setEnabled(false);
                }
            }
        });
        try {
            this.tableTemplates.addColumn((TableColumn)new QueryTableColumn("tpl_name", stringManager.getString("TemplateListDialog-command"), 180, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTemplates.addColumn((TableColumn)new QueryTableColumn("range", stringManager.getString("TemplateListDialog-definition"), 80));
            this.tableTemplates.addColumn((TableColumn)new QueryTableColumn("tpl_description", stringManager.getString("TemplateListDialog-description"), 350));
            this.tableTemplates.getQuery().setSqlText("select tpl_id, tpl_usr_id, tpl_name, case when tpl_usr_id is null then 'Globalna' else 'U\u017cytkownika' end range, tpl_description\n  from templates\n where (tpl_usr_id = :usr_id or tpl_usr_id is null)\n order by tpl_name");
            this.tableTemplates.getQuery().paramByName("usr_id").setString(Application.get().getUserId());
            this.tableTemplates.getQuery().open();
            if (!this.tableTemplates.getQuery().isEmpty()) {
                this.tableTemplates.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        this.textFiltr.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)((Object)this.tableTemplates)));
        this.textFiltr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TemplateListDialog.this.findTemplate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TemplateListDialog.this.findTemplate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        if (FocusManager.getCurrentManager().getFocusOwner() instanceof SyntaxEditor) {
            this.editor = (SyntaxEditor)FocusManager.getCurrentManager().getFocusOwner();
            this.buttonUse.setVisible(true);
            this.cmUse.setEnabled(true);
            this.getRootPane().setDefaultButton(this.buttonUse);
        } else {
            this.buttonUse.setVisible(false);
            this.cmUse.setEnabled(false);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateListDialog.this.textFiltr.requestFocusInWindow();
            }
        });
    }

    @Override
    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        this.tableTemplates.getQuery().close();
        super.dispose();
    }

    private void findTemplate() {
        if (this.tableTemplates.getQuery().isActive() && !"".equals(this.textFiltr.getText())) {
            try {
                if (this.tableTemplates.getQuery().locate("tpl_name", new Variant(this.textFiltr.getText()), true, true)) {
                    this.tableTemplates.changeSelection(this.tableTemplates.getQuery().getCurrentRecord().getIndex(), 0);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public void refreshQuery() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lastRow = TemplateListDialog.this.tableTemplates.getSelectedRow();
                try {
                    TemplateListDialog.this.tableTemplates.getQuery().refresh();
                    if (TemplateListDialog.this.tableTemplates.getRowCount() > lastRow && lastRow >= 0) {
                        TemplateListDialog.this.tableTemplates.setRowSelectionInterval(lastRow, lastRow);
                    } else if (TemplateListDialog.this.tableTemplates.getRowCount() > 0) {
                        TemplateListDialog.this.tableTemplates.setRowSelectionInterval(0, 0);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.cmUse = new Action();
        this.buttonClose = new JButton();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableTemplates = new ViewTable();
        this.jLabel1 = new JLabel();
        this.textFiltr = new TextField();
        this.buttonUse = new JButton();
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateListDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmNew.setEnabled(false);
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateListDialog.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setEnabled(false);
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateListDialog.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setEnabled(false);
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateListDialog.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmUse.setActionCommandKey("cmUse");
        this.cmUse.setText(stringManager.getString("TemplateListDialog-cmUse-text"));
        this.cmUse.setTooltip(stringManager.getString("TemplateListDialog-cmUse-hint"));
        this.cmUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateListDialog.this.cmUseActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("TemplateListDialog-title"));
        this.setModal(true);
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(85, 25));
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.jScrollPane1.setViewportView((Component)((Object)this.tableTemplates));
        this.jLabel1.setText(stringManager.getString("TemplateListDialog-search-dd"));
        this.buttonUse.setAction((javax.swing.Action)this.cmUse);
        this.buttonUse.setMargin(new Insets(2, 2, 2, 2));
        this.buttonUse.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 569, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 126, Short.MAX_VALUE).addComponent(this.buttonUse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textFiltr, -1, 530, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textFiltr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 252, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2).addComponent(this.buttonClose, -2, -1, -2).addComponent(this.buttonUse, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        if (this.tableTemplates.getQuery().isActive() && this.tableTemplates.getSelectedRow() >= 0) {
            try {
                this.tableTemplates.getQuery().getRecord(this.tableTemplates.getSelectedRow());
                String name = this.tableTemplates.getQuery().fieldByName("TPL_NAME").getString();
                String id = this.tableTemplates.getQuery().fieldByName("TPL_ID").getString();
                if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)String.format(stringManager.getString("TemplateListDialog-delete-q"), name), (int[])ModalResult.YESNO, (int)3) == 5) {
                    Template template = new Template(InternalDatabase.get());
                    template.getPrimaryKeyField().setValue(new Variant(id));
                    template.applyDelete();
                    this.refreshQuery();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableTemplates.getQuery().isActive() && this.tableTemplates.getSelectedRow() >= 0) {
                this.tableTemplates.getQuery().getRecord(this.tableTemplates.getSelectedRow());
                if (TemplateEditDialog.showDialog(this.tableTemplates.getQuery().fieldByName("tpl_id").getString()) == 1) {
                    this.refreshQuery();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            if (this.tableTemplates.getQuery().isActive() && TemplateEditDialog.showDialog(null) == 1) {
                this.refreshQuery();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmUseActionPerformed(ActionEvent evt) {
        if (this.tableTemplates.getQuery().isActive() && this.tableTemplates.getSelectedRow() >= 0) {
            try {
                this.tableTemplates.getQuery().getRecord(this.tableTemplates.getSelectedRow());
                this.tpl_id = this.tableTemplates.getQuery().fieldByName("tpl_id").getString();
                this.modalResult = 1;
                this.dispose();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

