/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.templates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.UseDBException;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.patt.Resolvers;

public class TemplateUseDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private String tpl_id;
    private SyntaxEditor editor;
    private Template template;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JPanel panelParameters;
    private JScrollPane scrollParameters;

    public TemplateUseDialog(String tpl_id, SyntaxEditor editor) throws UseDBException {
        super(SwingUtil.getRootFrame());
        this.tpl_id = tpl_id;
        this.editor = editor;
        this.initComponents();
        this.init();
    }

    public static void showDialog(final String tpl_id, final SyntaxEditor editor) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TemplateUseDialog dialog = new TemplateUseDialog(tpl_id, editor);
                    dialog.setVisible(true);
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                    MessageBox.show(null, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                }
            }
        });
    }

    private void init() throws UseDBException {
        this.template = new Template(Application.get().getOrbadaDatabase(), this.tpl_id);
        this.setTitle(this.getTitle() + " - " + this.template.getName());
        this.prepareParameters();
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void prepareParameters() {
        List valueNames = Resolvers.createValueNames((String)this.template.getBody(), (boolean)true);
        for (int i = 0; i < valueNames.size(); ++i) {
            JLabel label = new JLabel();
            String name = SwingUtil.setButtonText((JLabel)label, (String)((String)valueNames.get(i)));
            label.setText(name);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = i * 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.panelParameters.add((Component)label, gridBagConstraints);
            TextField field = new TextField();
            field.setName((String)valueNames.get(i));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1 + i * 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.panelParameters.add((Component)field, gridBagConstraints);
            label.setLabelFor((Component)field);
        }
    }

    private void appendToEditor() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (int i = 0; i < this.panelParameters.getComponentCount(); ++i) {
            Component c = this.panelParameters.getComponent(i);
            if (!(c instanceof TextField)) continue;
            valueMap.put(((TextField)c).getName(), ((TextField)c).getText());
        }
        if (this.editor.getSelectionStart() != this.editor.getSelectionEnd()) {
            this.editor.replaceSelection(this.template.expand(valueMap));
        } else {
            this.editor.insert(this.template.expand(valueMap), this.editor.getCaretPosition());
        }
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.scrollParameters = new JScrollPane();
        this.panelParameters = new JPanel();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateUseDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateUseDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("TemplateUseDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.scrollParameters.setBorder(null);
        this.panelParameters.setLayout(new GridBagLayout());
        this.scrollParameters.setViewportView(this.panelParameters);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.scrollParameters, -1, 429, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollParameters, -1, 386, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.modalResult = 1;
            this.appendToEditor();
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

