/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Tool;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxTextArea;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.gui.FieldLinkType;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StreamUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class ToolEditDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private String to_id;
    private int modalResult = 0;
    private Tool tool;
    private RecordLink toolLink;
    private JButton buttonCancel;
    private JButton buttonIcon;
    private JButton buttonOk;
    private JCheckBox checkMenu;
    private JCheckBox checkToolButton;
    private Action cmCancel;
    private Action cmOk;
    private Action cmSelectFile;
    private Action cmSelectIcon;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTabbedPane jTabbedPane1;
    private TextField textArguments;
    private OrbadaJavaSyntaxTextArea textBshAfterExec;
    private OrbadaJavaSyntaxTextArea textBshBeforeExec;
    private OrbadaJavaSyntaxTextArea textBshGetArguments;
    private TextField textCommand;
    private TextField textSource;
    private TextField textTitle;
    private ToolButton toolButton1;

    public ToolEditDialog(String to_id) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.to_id = to_id;
        this.initComponents();
        this.init();
    }

    public static int showDialog(String to_id) throws IntrospectionException, UseDBException {
        ToolEditDialog dialog = new ToolEditDialog(to_id);
        dialog.setVisible(true);
        return dialog.getModalResult();
    }

    private void init() throws IntrospectionException, UseDBException {
        SwingUtil.centerWithinScreen((Window)this);
        this.toolLink = new RecordLink();
        this.toolLink.add("TO_TITLE", (Component)this.textTitle);
        this.toolLink.add("TO_COMMAND", (Component)this.textCommand);
        this.toolLink.add("TO_SOURCE", (Component)this.textSource);
        this.toolLink.add("TO_ARGUMENTS", (Component)this.textArguments);
        this.toolLink.add("TO_MENU", (Component)this.checkMenu, "selected", FieldLinkType.Boolean_YN);
        this.toolLink.add("TO_TOOLBUTTON", (Component)this.checkToolButton, "selected", FieldLinkType.Boolean_YN);
        this.toolLink.add("TO_BSH_GET_ARGUMENTS", (Component)((Object)this.textBshGetArguments));
        this.toolLink.add("TO_BSH_BEFORE_EXEC", (Component)((Object)this.textBshBeforeExec));
        this.toolLink.add("TO_BSH_AFTER_EXEC", (Component)((Object)this.textBshAfterExec));
        if (this.to_id != null) {
            this.tool = new Tool(InternalDatabase.get(), this.to_id);
        } else {
            this.tool = new Tool(InternalDatabase.get());
            this.tool.setUsrId(Application.get().getUserId());
        }
        this.toolLink.updateComponents((BufferedRecord)this.tool);
        this.updateIcon();
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
    }

    public int getModalResult() {
        return this.modalResult;
    }

    private void updateIcon() {
        if (this.tool.fieldByName("to_icon").getValue().isNullValue()) {
            this.cmSelectIcon.setSmallIcon(null);
        } else {
            try {
                this.cmSelectIcon.setSmallIcon((Icon)new ImageIcon(this.tool.fieldByName("to_icon").getValue().getBinary()));
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmSelectFile = new Action();
        this.cmSelectIcon = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.textTitle = new TextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.textCommand = new TextField();
        this.jLabel3 = new JLabel();
        this.textSource = new TextField();
        this.textArguments = new TextField();
        this.jLabel4 = new JLabel();
        this.checkMenu = new JCheckBox();
        this.toolButton1 = new ToolButton();
        this.checkToolButton = new JCheckBox();
        this.buttonIcon = new JButton();
        this.jPanel2 = new JPanel();
        this.textBshGetArguments = new OrbadaJavaSyntaxTextArea();
        this.jPanel3 = new JPanel();
        this.textBshBeforeExec = new OrbadaJavaSyntaxTextArea();
        this.jPanel4 = new JPanel();
        this.textBshAfterExec = new OrbadaJavaSyntaxTextArea();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmSelectFile.setActionCommandKey("cmSelectFile");
        this.cmSelectFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/open_document16.gif"));
        this.cmSelectFile.setText(stringManager.getString("ToolEditDialog-cmSelectFile-text"));
        this.cmSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolEditDialog.this.cmSelectFileActionPerformed(evt);
            }
        });
        this.cmSelectIcon.setActionCommandKey("cmSelectIcon");
        this.cmSelectIcon.setText(stringManager.getString("ToolEditDialog-cmSelectIcon-text"));
        this.cmSelectIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolEditDialog.this.cmSelectIconActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("ToolEditDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jTabbedPane1.setFocusable(false);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor((Component)this.textTitle);
        this.jLabel1.setText(stringManager.getString("ToolEditDialog-title-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setLabelFor((Component)this.textTitle);
        this.jLabel2.setText(stringManager.getString("ToolEditDialog-inner-command-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setLabelFor((Component)this.textTitle);
        this.jLabel3.setText(stringManager.getString("ToolEditDialog-os-command-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setLabelFor((Component)this.textTitle);
        this.jLabel4.setText(stringManager.getString("ToolEditDialog-exec-params-dd"));
        this.checkMenu.setText(stringManager.getString("ToolEditDialog-show-in-menu"));
        this.toolButton1.setAction((javax.swing.Action)this.cmSelectFile);
        this.toolButton1.setPreferredSize(new Dimension(24, 24));
        this.checkToolButton.setText(stringManager.getString("ToolEditDialog-show-as-button"));
        this.buttonIcon.setAction((javax.swing.Action)this.cmSelectIcon);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 138, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkToolButton).addComponent(this.checkMenu).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.textSource, -1, 263, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toolButton1, -2, -1, -2)).addComponent((Component)this.textTitle, -1, 293, Short.MAX_VALUE).addComponent((Component)this.textCommand, -1, 293, Short.MAX_VALUE).addComponent((Component)this.textArguments, -1, 293, Short.MAX_VALUE).addComponent(this.buttonIcon, -2, 123, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textCommand, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textArguments, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.textSource, -2, -1, -2).addComponent(this.jLabel3)).addGap(6, 6, 6).addComponent(this.checkMenu).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkToolButton)).addComponent((Component)this.toolButton1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonIcon).addContainerGap(26, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(stringManager.getString("ToolEditDialog-definition"), this.jPanel1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.textBshGetArguments), -1, 435, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.textBshGetArguments), -1, 190, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("ToolEditDialog-bsh-get-params"), this.jPanel2);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.textBshBeforeExec), -1, 435, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.textBshBeforeExec), -1, 190, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("ToolEditDialog-bsh-before-exec"), this.jPanel3);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.textBshAfterExec), -1, 435, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.textBshAfterExec), -1, 190, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("ToolEditDialog-bsh-after-exec"), this.jPanel4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.LEADING, -1, 460, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.toolLink.updateRecord((BufferedRecord)this.tool);
            if (this.tool.isChanged()) {
                if (this.to_id == null) {
                    this.tool.applyInsert();
                } else {
                    this.tool.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmSelectFileActionPerformed(ActionEvent evt) {
        File file = FileUtil.selectFileToOpen((Component)this, (File)new File(this.textSource.getText()), null);
        if (file != null) {
            this.textSource.setText(file.toString());
        }
    }

    private void cmSelectIconActionPerformed(ActionEvent evt) {
        File file;
        if (!this.tool.fieldByName("to_icon").getValue().isNullValue()) {
            switch (MessageBox.show((Component)this, (String)stringManager.getString("ToolEditDialog-icon"), (String)stringManager.getString("ToolEditDialog-icon-seleted-delete-q"), (int[])ModalResult.YESNOCANCEL, (int)3)) {
                case 2: {
                    return;
                }
                case 5: {
                    this.tool.fieldByName("to_icon").setValue(null);
                    this.updateIcon();
                    return;
                }
            }
        }
        if ((file = FileUtil.selectFileToOpen((Component)this, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("ToolEditDialog-pic-files"), new String[]{".jpg", ".jpeg", ".gif", ".png"})})) != null) {
            try {
                this.tool.fieldByName("to_icon").setValue(new Variant(StreamUtil.stream2Array((InputStream)new FileInputStream(file))));
                this.updateIcon();
            }
            catch (IOException ex) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
            }
        }
    }
}

