/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Tool;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.tools.ToolEditDialog;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ToolListDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ISettings settings;
    private JButton buttonClose;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonNew;
    private Action cmClose;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmNew;
    private JScrollPane jScrollPane1;
    private ViewTable tableTools;

    public ToolListDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolListDialog dialog = new ToolListDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-tool-list-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.tableTools.getQuery().setDatabase(InternalDatabase.get());
        this.tableTools.getQuery().addQueryListener(new QueryListener(){

            public void beforeScroll(EventObject e) {
            }

            public void afterScroll(EventObject e) {
            }

            public void beforeOpen(EventObject e) {
            }

            public void afterOpen(EventObject e) {
                ToolListDialog.this.cmNew.setEnabled(true);
            }

            public void beforeClose(EventObject e) {
            }

            public void afterClose(EventObject e) {
                ToolListDialog.this.cmNew.setEnabled(false);
                ToolListDialog.this.cmEdit.setEnabled(false);
                ToolListDialog.this.cmDelete.setEnabled(false);
            }

            public void flushedPerformed(EventObject e) {
            }

            public void errorPerformed(EventObject e) {
            }
        });
        this.tableTools.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ToolListDialog.this.cmEdit.setEnabled(e.getFirstIndex() >= 0);
                ToolListDialog.this.cmDelete.setEnabled(e.getFirstIndex() >= 0);
            }
        });
        try {
            this.tableTools.addColumn((TableColumn)new QueryTableColumn("to_command", stringManager.getString("ToolListDialog-command"), 100, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTools.addColumn((TableColumn)new QueryTableColumn("to_title", stringManager.getString("ToolListDialog-title-column"), 120));
            this.tableTools.addColumn((TableColumn)new QueryTableColumn("to_source", stringManager.getString("ToolListDialog-call-source"), 220));
            this.tableTools.addColumn((TableColumn)new QueryTableColumn("to_arguments", stringManager.getString("ToolListDialog-parameters"), 170));
            this.tableTools.getQuery().setSqlText("select *\n  from tools\n where to_usr_id = :to_usr_id\n order by to_command");
            this.tableTools.getQuery().paramByName("to_usr_id").setString(Application.get().getUserId());
            this.tableTools.getQuery().open();
            if (!this.tableTools.getQuery().isEmpty()) {
                this.tableTools.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    @Override
    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        this.tableTools.getQuery().close();
        super.dispose();
    }

    public void refreshQuery() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lastRow = ToolListDialog.this.tableTools.getSelectedRow();
                try {
                    ToolListDialog.this.tableTools.getQuery().refresh();
                    if (ToolListDialog.this.tableTools.getRowCount() > lastRow && lastRow >= 0) {
                        ToolListDialog.this.tableTools.setRowSelectionInterval(lastRow, lastRow);
                    } else if (ToolListDialog.this.tableTools.getRowCount() > 0) {
                        ToolListDialog.this.tableTools.setRowSelectionInterval(0, 0);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.buttonClose = new JButton();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableTools = new ViewTable();
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolListDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmNew.setEnabled(false);
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolListDialog.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setEnabled(false);
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolListDialog.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setEnabled(false);
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolListDialog.this.cmDeleteActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("ToolListDialog-title"));
        this.setModal(true);
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(85, 25));
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.jScrollPane1.setViewportView((Component)((Object)this.tableTools));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 561, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 209, Short.MAX_VALUE).addComponent(this.buttonClose, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 271, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2).addComponent(this.buttonClose, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        if (this.tableTools.getQuery().isActive() && this.tableTools.getSelectedRow() >= 0) {
            try {
                this.tableTools.getQuery().getRecord(this.tableTools.getSelectedRow());
                if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)stringManager.getString("ToolListDialog-delete-tool-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                    Tool tool = new Tool(InternalDatabase.get());
                    tool.getPrimaryKeyField().setValue(new Variant(this.tableTools.getQuery().fieldByName("TO_ID").getString()));
                    tool.applyDelete();
                    this.refreshQuery();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableTools.getQuery().isActive() && this.tableTools.getSelectedRow() >= 0) {
                this.tableTools.getQuery().getRecord(this.tableTools.getSelectedRow());
                if (ToolEditDialog.showDialog(this.tableTools.getQuery().fieldByName("to_id").getString()) == 1) {
                    this.refreshQuery();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            if (this.tableTools.getQuery().isActive() && ToolEditDialog.showDialog(null) == 1) {
                this.refreshQuery();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

