/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FontChooser
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private String[] fontFamilies;
    private boolean updatingGroup;
    public static final String[] styleNames = new String[]{"Plain", "Italic", "Bold", "Bold + Italic"};
    public static final Integer[] styleValues = new Integer[]{new Integer(0), new Integer(2), new Integer(1), new Integer(3)};
    public static final String[] sizeNames = new String[]{"8", "10", "11", "12", "14", "18", "20", "24", "28", "32", "40", "48", "56", "64", "72"};
    private Font font;
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel labelPreview;
    private JList listFontFamilies;
    private JList listSizes;
    private JList listStyles;
    private TextField textFontFamily;
    private TextField textSize;
    private TextField textStyle;

    public FontChooser(String title, Font font) {
        super(SwingUtil.getRootFrame());
        this.font = font;
        this.initComponents();
        this.setTitle(title);
        this.init();
    }

    public static Font showDialog(String title, Font font) {
        FontChooser dialog = new FontChooser(title, font);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            return dialog.font;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.updatingGroup = true;
        try {
            this.fontFamilies = env.getAvailableFontFamilyNames();
            this.listFontFamilies.setListData(this.fontFamilies);
            this.listFontFamilies.setSelectedValue(this.font.getFamily(), true);
            this.listStyles.setListData(styleNames);
            this.listStyles.setSelectedValue(styleNames[this.font.getStyle()], true);
            this.listSizes.setListData(sizeNames);
            this.listSizes.setSelectedValue(String.valueOf(this.font.getSize()), true);
            this.textSize.setText(String.valueOf(this.font.getSize()));
        }
        finally {
            this.updatingGroup = false;
        }
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        this.updatePreview();
        this.pack();
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void updatePreview() {
        if (!this.updatingGroup) {
            try {
                Font font_l = new Font(this.textFontFamily.getText(), (int)styleValues[this.listStyles.getSelectedIndex()], Integer.parseInt(this.textSize.getText()));
                this.labelPreview.setFont(font_l);
            }
            catch (Throwable ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listFontFamilies = new JList();
        this.textFontFamily = new TextField();
        this.jLabel2 = new JLabel();
        this.textStyle = new TextField();
        this.jScrollPane2 = new JScrollPane();
        this.listStyles = new JList();
        this.jLabel3 = new JLabel();
        this.textSize = new TextField();
        this.jScrollPane3 = new JScrollPane();
        this.listSizes = new JList();
        this.jPanel1 = new JPanel();
        this.labelPreview = new JLabel();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("FontChooser-title"));
        this.setModal(true);
        this.setResizable(false);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setText(stringManager.getString("FontChooser-font-dd"));
        this.listFontFamilies.setSelectionMode(0);
        this.listFontFamilies.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooser.this.listFontFamiliesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listFontFamilies);
        this.textFontFamily.setEnabled(false);
        this.jLabel2.setText(stringManager.getString("FontChooser-style-dd"));
        this.textStyle.setEnabled(false);
        this.listStyles.setSelectionMode(0);
        this.listStyles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooser.this.listStylesValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.listStyles);
        this.jLabel3.setText(stringManager.getString("FontChooser-size-dd"));
        this.listSizes.setSelectionMode(0);
        this.listSizes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooser.this.listSizesValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listSizes);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(stringManager.getString("FontChooser-preview")));
        this.labelPreview.setHorizontalAlignment(0);
        this.labelPreview.setText(stringManager.getString("FontChooser-sample-preview"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.labelPreview, -1, 361, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.labelPreview, -1, 35, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent((Component)this.textFontFamily, -1, 173, Short.MAX_VALUE).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addComponent((Component)this.textStyle, GroupLayout.Alignment.TRAILING, -2, 103, -2)).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -2, 103, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent((Component)this.textSize, -2, 105, -2).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -2, 105, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textFontFamily, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 161, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent((Component)this.textSize, -2, -1, -2)).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 161, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textStyle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 161, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void listSizesValueChanged(ListSelectionEvent evt) {
        if (this.listSizes.getSelectedValue() != null) {
            this.textSize.setText(this.listSizes.getSelectedValue().toString());
            this.updatePreview();
        } else {
            this.textSize.setText("");
        }
    }

    private void listStylesValueChanged(ListSelectionEvent evt) {
        if (this.listStyles.getSelectedValue() != null) {
            this.textStyle.setText(this.listStyles.getSelectedValue().toString());
            this.updatePreview();
        } else {
            this.textStyle.setText("");
        }
    }

    private void listFontFamiliesValueChanged(ListSelectionEvent evt) {
        if (this.listFontFamilies.getSelectedValue() != null) {
            this.textFontFamily.setText(this.listFontFamilies.getSelectedValue().toString());
            this.updatePreview();
        } else {
            this.textFontFamily.setText("");
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.font = new Font(this.textFontFamily.getText(), (int)styleValues[this.listStyles.getSelectedIndex()], Integer.parseInt(this.textSize.getText()));
            this.modalResult = 1;
            this.dispose();
        }
        catch (Throwable ex) {
            MessageBox.show((String)stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }
}

