/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.util;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.sky.gui.swing.ListRowChangeKeyListener;
import pl.mpak.util.StringUtil;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPool;

public class SimpleSelectDialog
extends JDialog {
    private String formatData = null;
    private ArrayList<?> listData = null;
    private ArrayList<?> showListData = null;
    private ListModel listModel;
    private KeyListener keyListener;
    private int modalResult = 0;
    private JScrollPane jScrollPane1;
    private JList listSearchResult;
    private JPanel panelContent;
    private JTextField textFieldSearch;

    public static Object select(Window owner, int x, int y, Vector<?> listData, int selected, CallBack callBack) {
        return SimpleSelectDialog.select(owner, x, y, null, listData, selected, callBack);
    }

    public static Object select(Window owner, int x, int y, String formatData, Vector<?> listData, int selected, CallBack callBack) {
        return SimpleSelectDialog.select(new SimpleSelectDialog(owner, formatData, listData, selected), x, y, callBack);
    }

    public static Object select(Window owner, int x, int y, ArrayList<?> listData, int selected, CallBack callBack) {
        return SimpleSelectDialog.select(owner, x, y, null, listData, selected, callBack);
    }

    public static Object select(Window owner, int x, int y, String formatData, ArrayList<?> listData, int selected, CallBack callBack) {
        return SimpleSelectDialog.select(new SimpleSelectDialog(owner, formatData, listData, selected), x, y, callBack);
    }

    private static Object select(final SimpleSelectDialog dialog, int x, int y, final CallBack callBack) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)(x + dialog.getWidth()) > screenSize.getWidth()) {
            x = (int)((double)x - ((double)(x + dialog.getWidth()) - screenSize.getWidth()));
        }
        if ((double)(y + dialog.getHeight()) > screenSize.getHeight()) {
            y = (int)((double)y - ((double)(y + dialog.getHeight()) - screenSize.getHeight()));
        }
        dialog.setBounds(x, y, dialog.getWidth(), dialog.getHeight());
        dialog.setVisible(true);
        if (!dialog.isModal() && callBack != null) {
            if (dialog.getModalResult() == 1) {
                callBack.selected(dialog.getSelectedValue());
            }
            TaskPool.getTaskPool().addTask(new Task(){

                public void run() {
                    while (dialog.isVisible()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (dialog.getModalResult() == 1) {
                        callBack.selected(dialog.getSelectedValue());
                    }
                }
            });
        } else if (dialog.getModalResult() == 1) {
            return dialog.getSelectedValue();
        }
        return null;
    }

    public SimpleSelectDialog(Window window, String formatData, Vector<?> listData, int selected) {
        this(window, formatData, new ArrayList(listData), selected);
    }

    public SimpleSelectDialog(Window window, String formatData, ArrayList<?> listData, int selected) {
        super(window);
        this.listData = listData;
        this.showListData = listData;
        this.formatData = formatData;
        this.initComponents();
        this.init(selected);
        this.setModal(window == null);
    }

    private void init(int selected) {
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SimpleSelectDialog.this.showListData.size() > 0) {
                        SimpleSelectDialog.this.modalResult = 1;
                        SimpleSelectDialog.this.dispose();
                    }
                    evt.consume();
                } else if (evt.getKeyCode() == 27) {
                    SimpleSelectDialog.this.modalResult = 2;
                    SimpleSelectDialog.this.dispose();
                    evt.consume();
                }
            }
        };
        this.listModel = new AbstractListModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSize() {
                return SimpleSelectDialog.this.showListData == null ? 0 : SimpleSelectDialog.this.showListData.size();
            }

            @Override
            public Object getElementAt(int index) {
                if (SimpleSelectDialog.this.formatData != null) {
                    return SimpleSelectDialog.this.showListData == null ? "No data found" : String.format(SimpleSelectDialog.this.formatData, ((Vector)SimpleSelectDialog.this.showListData.get(index)).toArray());
                }
                return SimpleSelectDialog.this.showListData == null ? "No data found" : SimpleSelectDialog.this.showListData.get(index);
            }
        };
        this.listSearchResult.setModel(this.listModel);
        this.listSearchResult.addKeyListener(this.keyListener);
        this.listSearchResult.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SimpleSelectDialog.this.listSearchResult.ensureIndexIsVisible(SimpleSelectDialog.this.listSearchResult.getSelectedIndex());
            }
        });
        this.textFieldSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SimpleSelectDialog.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SimpleSelectDialog.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.textFieldSearch.addKeyListener(this.keyListener);
        this.textFieldSearch.addKeyListener((KeyListener)new ListRowChangeKeyListener(this.listSearchResult));
        this.updateList();
        this.setPreferredSize(this.listSearchResult.getPreferredSize());
        this.pack();
        Dimension d = this.getSize();
        d.width = d.width > 400 ? 400 : (d.width < 100 ? 130 : (d.width += 30));
        d.height = d.height > 300 ? 300 : (d.height < 100 ? 130 : (d.height += 30));
        this.setSize(d);
        this.setSelectedIndex(selected);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleSelectDialog.this.listSearchResult.ensureIndexIsVisible(SimpleSelectDialog.this.listSearchResult.getSelectedIndex());
            }
        });
    }

    private void updateList() {
        if (StringUtil.equals((String)this.textFieldSearch.getText(), (String)"")) {
            this.showListData = this.listData;
        } else {
            this.showListData = (ArrayList)this.listData.clone();
            int i = 0;
            while (i < this.showListData.size()) {
                if (this.showListData.get(i).toString().toUpperCase().indexOf(this.textFieldSearch.getText().toUpperCase()) == -1) {
                    this.showListData.remove(i);
                    continue;
                }
                ++i;
            }
            if (this.showListData != null && this.showListData.size() > 0) {
                this.setSelectedIndex(0);
            }
        }
        this.listSearchResult.revalidate();
        this.listSearchResult.repaint();
    }

    public void setSelectedIndex(int index) {
        this.listSearchResult.setSelectedIndex(index);
        this.listSearchResult.ensureIndexIsVisible(index);
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public Object getSelectedValue() {
        if (this.listSearchResult.getSelectedIndex() >= 0) {
            return this.showListData.get(this.listSearchResult.getSelectedIndex());
        }
        return null;
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.textFieldSearch = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.listSearchResult = new JList();
        this.setDefaultCloseOperation(2);
        this.setBounds(new Rectangle(4, 4, 4, 4));
        this.setUndecorated(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent evt) {
                SimpleSelectDialog.this.formWindowDeactivated(evt);
            }
        });
        this.panelContent.setBorder(BorderFactory.createBevelBorder(0));
        this.listSearchResult.setSelectionMode(0);
        this.listSearchResult.setFixedCellHeight(18);
        this.listSearchResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleSelectDialog.this.listSearchResultMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listSearchResult);
        GroupLayout panelContentLayout = new GroupLayout(this.panelContent);
        this.panelContent.setLayout(panelContentLayout);
        panelContentLayout.setHorizontalGroup(panelContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldSearch, -1, 187, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 187, Short.MAX_VALUE));
        panelContentLayout.setVerticalGroup(panelContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelContentLayout.createSequentialGroup().addComponent(this.textFieldSearch, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 191, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelContent, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelContent, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void listSearchResultMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.modalResult = 1;
            this.dispose();
        }
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (this.isVisible()) {
            this.dispose();
        }
    }

    public static interface CallBack {
        public void selected(Object var1);
    }
}

