/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.webapp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPool;
import pl.mpak.waitdlg.WaitDialog;

public class RequestErrorDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private Throwable exception;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JLabel labelContent;
    private JLabel labelTitle;
    private TextArea textCallStack;
    private TextArea textContent;
    private TextField textDatabase;
    private TextField textJava;
    private TextField textJdbc;
    private TextField textOs;
    private TextField textTitle;
    private TextArea textWorkaround;

    public RequestErrorDialog(Throwable exception) {
        super(SwingUtil.getRootFrame(), true);
        this.exception = exception;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.textContent.setFont(this.textTitle.getFont());
        this.textCallStack.setFont(this.textCallStack.getFont().deriveFont((float)this.getFont().getSize()));
        this.textWorkaround.setFont(this.textTitle.getFont());
        this.textOs.setText(System.getProperty("os.name") + ", " + System.getProperty("os.version"));
        this.textJava.setText(System.getProperty("java.vendor") + ", " + System.getProperty("java.version"));
        if (Application.get().getMainFrame().getActiveDatabase() != null) {
            Database db = Application.get().getMainFrame().getActiveDatabase();
            try {
                this.textDatabase.setText(db.getMetaData().getDatabaseProductName() + ", " + db.getMetaData().getDatabaseProductVersion());
            }
            catch (SQLException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            this.textJdbc.setText(db.getDriver().getClass().getName() + ", " + db.getDriver().getMajorVersion() + "." + db.getDriver().getMinorVersion());
        }
        if (this.exception != null) {
            if (this.exception.getCause() != null) {
                this.textTitle.setText(this.exception.getCause().getClass().getName());
            } else {
                this.textTitle.setText(this.exception.getClass().getName());
            }
            this.textCallStack.setText(ExceptionUtil.getStackTrace((Throwable)this.exception));
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RequestErrorDialog.this.textContent.requestFocusInWindow();
            }
        });
    }

    public static void showDialog(final Throwable exception) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RequestErrorDialog dialog = new RequestErrorDialog(exception);
                dialog.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.labelTitle = new JLabel();
        this.textTitle = new TextField();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textWorkaround = new TextArea();
        this.jLabel5 = new JLabel();
        this.textOs = new TextField();
        this.jLabel6 = new JLabel();
        this.textJava = new TextField();
        this.jLabel7 = new JLabel();
        this.textDatabase = new TextField();
        this.jScrollPane3 = new JScrollPane();
        this.textContent = new TextArea();
        this.labelContent = new JLabel();
        this.jLabel9 = new JLabel();
        this.textJdbc = new TextField();
        this.jPanel2 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.textCallStack = new TextArea();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequestErrorDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequestErrorDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("RequestErrorDialog-title"));
        this.labelTitle.setHorizontalAlignment(4);
        this.labelTitle.setText(stringManager.getString("RequestErrorDialog-short-description-dd"));
        this.labelTitle.setEnabled(false);
        this.textTitle.setEnabled(false);
        this.jLabel4.setText(stringManager.getString("RequestErrorDialog-problem-workaround-dd"));
        this.textWorkaround.setLineWrap(true);
        this.textWorkaround.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView((Component)this.textWorkaround);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(stringManager.getString("RequestErrorDialog-os-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(stringManager.getString("RequestErrorDialog-java-version-dd"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(stringManager.getString("RequestErrorDialog-database-dd"));
        this.textContent.setLineWrap(true);
        this.textContent.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView((Component)this.textContent);
        this.labelContent.setText(stringManager.getString("RequestErrorDialog-problem-frequency-dd"));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText(stringManager.getString("RequestErrorDialog-jdbc-driver-dd"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.labelTitle, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTitle, -1, 465, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textOs, -1, 465, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textJava, -1, 465, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textDatabase, -1, 465, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textJdbc, -1, 465, Short.MAX_VALUE)).addComponent(this.labelContent, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTitle).addComponent((Component)this.textTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textOs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textJava, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.textDatabase, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent((Component)this.textJdbc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelContent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 79, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 72, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("RequestErrorDialog-general"), this.jPanel1);
        this.textCallStack.setColumns(20);
        this.textCallStack.setRows(5);
        this.textCallStack.setFont(new Font("Courier New", 0, 9));
        this.jScrollPane4.setViewportView((Component)this.textCallStack);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -1, 608, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -1, 327, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("RequestErrorDialog-error-call-stack"), this.jPanel2);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setText(stringManager.getString("RequestErrorDialog-required-fields"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, 633, Short.MAX_VALUE).addComponent(this.jTabbedPane1, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 374, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (StringUtil.isEmpty((String)this.textOs.getText())) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)stringManager.getString("RequestErrorDialog-os-version-expected"), (int)1, (int)0);
            return;
        }
        if (StringUtil.isEmpty((String)this.textJava.getText())) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)stringManager.getString("RequestErrorDialog-java-expected"), (int)1, (int)0);
            return;
        }
        if (StringUtil.isEmpty((String)this.textContent.getText())) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)stringManager.getString("RequestErrorDialog-problem-description-expected"), (int)1, (int)0);
            return;
        }
        TaskPool.getTaskPool().addTask(new Task(stringManager.getString("RequestErrorDialog-request-register")){
            String title;
            String content;
            String os;
            String db;
            String java;
            String jdbc;
            String callStack;
            {
                this.title = RequestErrorDialog.this.textTitle.getText();
                this.content = "(DESCRIPTION)\n" + RequestErrorDialog.this.textContent.getText();
                this.os = RequestErrorDialog.this.textOs.getText();
                this.db = RequestErrorDialog.this.textDatabase.getText();
                this.java = RequestErrorDialog.this.textJava.getText();
                this.jdbc = RequestErrorDialog.this.textJdbc.getText();
                this.callStack = RequestErrorDialog.this.textCallStack.getText();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WaitDialog.showWaitDialog((String)stringManager.getString("RequestErrorDialog-request-sending"));
                try {
                    Application.get().getWebAppAccessibilities().requestPost("problem", this.title, this.os, this.db, this.jdbc, this.java, null, this.callStack, this.content, RequestErrorDialog.this.textWorkaround.getText());
                }
                finally {
                    WaitDialog.hideWaitDialog();
                }
                RequestErrorDialog.this.dispose();
            }
        });
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

