/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.services;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.providers.PleaseWaitRendererProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DefaultPleaseWaitRenderer
extends PleaseWaitRendererProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private static final int WAIT_X_SHIFT = 10;
    private static final int WAIT_Y_SHIFT = 10;
    public static final String uniqueId = "orbada-default-please-wait-renderer";
    private int waitAniPic;
    private ArrayList<Image> waitImageList = new ArrayList();
    private Image waitBackground;
    private Rectangle renderRectangle;

    public DefaultPleaseWaitRenderer() {
        for (int i = 0; i < 12; ++i) {
            this.waitImageList.add(ImageManager.getImage((String)String.format("/res/wait/wait%02d.png", i)).getImage());
        }
        this.waitBackground = ImageManager.getImage((String)"/res/wait/waitbg.png").getImage();
    }

    public void control() {
        if (++this.waitAniPic >= 12) {
            this.waitAniPic = 0;
        }
        if (this.renderRectangle == null) {
            int left = this.component.getWidth() - 10 - 30 - this.waitBackground.getWidth(null);
            int top = this.component.getHeight() - 10 - 30 - this.waitBackground.getHeight(null);
            this.renderRectangle = new Rectangle(left, top, this.component.getWidth() - left, this.component.getHeight() - top);
        }
    }

    public void render(Graphics2D g2, PleaseWait[] waitArr) {
        FontMetrics fm = g2.getFontMetrics();
        int left = this.component.getWidth() - 10;
        int top = this.component.getHeight() - 10;
        g2.drawImage(this.waitBackground, left - this.waitBackground.getWidth(null), top - this.waitBackground.getHeight(null), null);
        int picWidth = 0;
        for (PleaseWait wait : waitArr) {
            if (wait.getImage() == null) continue;
            picWidth += wait.getImage().getWidth(null);
        }
        int picPos = 0;
        for (PleaseWait wait : waitArr) {
            if (wait.getImage() == null) continue;
            g2.drawImage(wait.getImage(), left - (this.waitBackground.getWidth(null) + picWidth) / 2 + picPos, top - (this.waitBackground.getHeight(null) + wait.getImage().getHeight(null)) / 2, null);
            picPos += wait.getImage().getWidth(null);
        }
        Image image = this.waitImageList.get(this.waitAniPic);
        g2.drawImage(image, left - (this.waitBackground.getWidth(null) + image.getWidth(null)) / 2, top - (this.waitBackground.getHeight(null) + image.getHeight(null)) / 2, null);
        int textPos = 0;
        for (PleaseWait wait : waitArr) {
            if (wait.getMessage() == null) continue;
            g2.drawString(wait.getMessage(), left - (this.waitBackground.getWidth(null) + fm.stringWidth(wait.getMessage())) / 2, top - (this.waitBackground.getHeight(null) + textPos) / 2 + 20);
            textPos += fm.getHeight() + 4;
        }
    }

    public String getDescription() {
        return stringManager.getString("DefaultPleaseWaitRenderer-default-display");
    }

    public String getGroupName() {
        return "OrbadaDefaultPleaseWait";
    }

    public String getRendererId() {
        return uniqueId;
    }

    public Rectangle getRenderBounds() {
        return this.renderRectangle;
    }
}

