/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.services;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.providers.PleaseWaitRendererProvider;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class TimeOrbadaFontPleaseWaitRenderer
extends PleaseWaitRendererProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private static final int WAIT_X_SHIFT = 10;
    private static final int WAIT_Y_SHIFT = 5;
    public static final String uniqueId = "time-orbada-font-please-wait-renderer";
    private Rectangle renderRectangle;
    private long startTime;
    private long diffTime;
    private int left;
    private int top;

    public void beginProcess() {
        this.startTime = System.nanoTime();
    }

    public void control() {
        this.diffTime = System.nanoTime() - this.startTime;
        this.calcRectangle();
    }

    private void calcRectangle() {
        int width = Application.get().getOrbadaFont().getWidth(StringUtil.formatTime((long)this.diffTime).toUpperCase());
        int height = Application.get().getOrbadaFont().getHeight(StringUtil.formatTime((long)this.diffTime).toUpperCase());
        this.left = this.component.getWidth() - 10 - width;
        this.top = this.component.getHeight() - 5 - height;
        this.renderRectangle = new Rectangle(this.left - 50, this.top - 5, width + 50, height + 10);
    }

    public void render(Graphics2D g2, PleaseWait[] waitArr) {
        if (this.renderRectangle == null) {
            this.calcRectangle();
        }
        Application.get().getOrbadaFont().draw(this.left, this.top, (Graphics)g2, StringUtil.formatTime((long)this.diffTime).toUpperCase());
    }

    public String getDescription() {
        return stringManager.getString("TimeOrbadaFontPleaseWaitRenderer-description");
    }

    public String getGroupName() {
        return "TimeOrbadaFontPleaseWait";
    }

    public String getRendererId() {
        return uniqueId;
    }

    public Rectangle getRenderBounds() {
        if (this.renderRectangle == null) {
            this.calcRectangle();
        }
        return this.renderRectangle;
    }
}

