/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.util;

import java.math.BigInteger;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.plugins.GeneratorException;
import pl.mpak.orbada.plugins.IGenerator;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.TaskUtil;

public class Generator
implements IGenerator {
    private String name;
    private BigInteger currValue;
    private BigInteger startValue;
    private BigInteger minValue;
    private BigInteger maxValue;
    private BigInteger increment;
    private Boolean cycle;

    public Generator(String name, BigInteger startValue, BigInteger minValue, BigInteger maxValue, BigInteger increment, Boolean cycle) throws GeneratorException {
        this.name = name;
        this.startValue = startValue == null ? new BigInteger("1") : startValue;
        this.minValue = minValue == null ? new BigInteger("1") : minValue;
        this.maxValue = maxValue == null ? new BigInteger("99999999999999999999") : maxValue;
        this.increment = increment == null ? new BigInteger("1") : increment;
        this.cycle = cycle == null ? false : cycle;
        this.init();
    }

    private void init() throws GeneratorException {
        try {
            pl.mpak.orbada.db.Generator generator = new pl.mpak.orbada.db.Generator(InternalDatabase.get(), this.name);
            if (generator.isExists()) {
                this.minValue = new BigInteger(generator.getMinValue());
                this.maxValue = new BigInteger(generator.getMaxValue());
                this.increment = new BigInteger(generator.getIncrement());
                this.cycle = generator.isCycle();
            } else {
                generator.setName(this.name);
                if (this.startValue != null) {
                    generator.setValue(this.startValue.toString());
                }
                if (this.minValue != null) {
                    generator.setMinValue(this.minValue.toString());
                }
                if (this.maxValue != null) {
                    generator.setMaxValue(this.maxValue.toString());
                }
                if (this.increment != null) {
                    generator.setIncrement(this.increment.toString());
                }
                if (this.cycle != null) {
                    generator.setCycle(this.cycle.booleanValue());
                }
                generator.applyInsert();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            throw new GeneratorException(1001, new Object[]{this.name});
        }
    }

    public String getName() {
        return this.name;
    }

    private void lock() throws GeneratorException {
        int counter = 100;
        boolean getted = false;
        try {
            Command locked = InternalDatabase.get().createCommand();
            locked.setSqlText("update generators set gen_locked = 'T' where gen_name = :gen_name and case when gen_locked is null then 'N' else gen_locked end = 'N'");
            locked.paramByName("gen_name").setString(this.name);
            while (!getted && --counter != 0) {
                locked.execute();
                getted = locked.getUpdateCount() >= 1;
                if (getted) continue;
                TaskUtil.sleep((long)10L);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            throw new GeneratorException(1002, new Object[]{this.name});
        }
        if (counter == 0) {
            throw new GeneratorException(1002, new Object[]{this.name});
        }
    }

    private void unlock() {
        try {
            Command unlock = InternalDatabase.get().createCommand();
            unlock.setSqlText("update generators set gen_locked = null where gen_name = :gen_name");
            unlock.paramByName("gen_name").setString(this.name);
            unlock.execute();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private BigInteger getValue() throws GeneratorException {
        Query query = InternalDatabase.get().createQuery();
        try {
            query.setSqlText("select gen_value from generators where gen_name = :gen_name");
            query.paramByName("gen_name").setString(this.name);
            query.open();
            BigInteger bigInteger = query.fieldByName("gen_value").getBigDecimal().toBigInteger();
            return bigInteger;
        }
        catch (Exception ex) {
            throw new GeneratorException(1002, new Object[]{this.name});
        }
        finally {
            query.close();
        }
    }

    private BigInteger getNextValue(BigInteger currValue) throws GeneratorException {
        BigInteger next = new BigInteger(currValue.toString());
        next = next.add(this.increment);
        if (this.cycle.booleanValue()) {
            if (next.compareTo(this.maxValue) > 0) {
                next = new BigInteger(this.minValue.toString());
            } else if (next.compareTo(this.minValue) < 0) {
                next = new BigInteger(this.maxValue.toString());
            }
        } else if (next.compareTo(this.maxValue) > 0 || next.compareTo(this.minValue) < 0) {
            throw new GeneratorException(1004, new Object[]{this.name});
        }
        return next;
    }

    private void updateValue(BigInteger value) throws GeneratorException {
        try {
            Command update = InternalDatabase.get().createCommand();
            update.setSqlText("update generators set gen_value = :gen_value where gen_name = :gen_name");
            update.paramByName("gen_name").setString(this.name);
            update.paramByName("gen_value").setString(value.toString());
            update.execute();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            throw new GeneratorException(1002, new Object[]{this.name});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getNextValue() throws GeneratorException {
        this.lock();
        try {
            this.currValue = this.getValue();
            BigInteger next = this.getNextValue(this.currValue);
            this.updateValue(next);
        }
        finally {
            this.unlock();
        }
        return this.getCurrValue();
    }

    public BigInteger getCurrValue() throws GeneratorException {
        if (this.currValue == null) {
            throw new GeneratorException(1003, new Object[]{this.name});
        }
        return new BigInteger(this.currValue.toString());
    }

    public BigInteger getMinValue() {
        return new BigInteger(this.minValue.toString());
    }

    public BigInteger getMaxValue() {
        return new BigInteger(this.maxValue.toString());
    }

    public BigInteger getIncrement() {
        return new BigInteger(this.increment.toString());
    }

    public boolean getCycle() {
        return this.cycle;
    }
}

