/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.util.settings;

import java.util.HashMap;
import java.util.Iterator;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.OrbadaDatabase;
import pl.mpak.orbada.util.settings.OrbadaSettings;
import pl.mpak.orbada.util.settings.SettingElement;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class DatabaseSettingsOne
extends OrbadaSettings {
    private static SchemaMap map = new SchemaMap();
    private static boolean loaded = false;

    private NameMap getMap() {
        GroupMap gmap = (GroupMap)map.get(StringUtil.nvl((String)this.getSchemaId(), (String)""));
        NameMap nmap = null;
        if (gmap != null) {
            nmap = (NameMap)gmap.get(this.getGroupName().toLowerCase());
        } else {
            gmap = new GroupMap();
            map.put(StringUtil.nvl((String)this.getSchemaId(), (String)""), gmap);
        }
        if (nmap == null) {
            nmap = new NameMap();
            gmap.put(this.getGroupName().toLowerCase(), nmap);
        }
        return nmap;
    }

    public void setValue(String name, Variant value) {
        NameMap nmap;
        SettingElement se;
        if (!loaded) {
            this.loadInternal();
        }
        if ((se = (SettingElement)(nmap = this.getMap()).get(name.toLowerCase())) == null) {
            se = new SettingElement(name, value);
            se.setNewest(true);
            nmap.put(name.toLowerCase(), se);
        } else {
            se.setValue(value);
        }
    }

    public Variant getValue(String name) {
        return this.getValue(name, new Variant());
    }

    public Variant getValue(String name, Variant defaultValue) {
        NameMap nmap;
        SettingElement se;
        if (!loaded) {
            this.loadInternal();
        }
        if ((se = (SettingElement)(nmap = this.getMap()).get(name.toLowerCase())) == null || se.getValue().isNullValue() || se.getValue().isNull()) {
            return defaultValue;
        }
        return se.getValue();
    }

    public void store() {
        if (InternalDatabase.get() == null) {
            return;
        }
        if (!loaded) {
            this.loadInternal();
        }
        NameMap nmap = this.getMap();
        Iterator i = nmap.values().iterator();
        Command command = InternalDatabase.get().createCommand();
        while (i.hasNext()) {
            SettingElement se = (SettingElement)i.next();
            try {
                if (se.isNewest()) {
                    command.setSqlText("insert into settings (set_usr_id, set_sch_id, set_group, set_name, set_value) values (:set_usr_id, :set_sch_id, :set_group, :set_name, :set_value)");
                    if (this.getSchemaId() != null) {
                        command.paramByName("set_sch_id").setString(this.getSchemaId());
                    } else {
                        command.paramByName("set_sch_id").setString(null);
                    }
                } else if (se.isChanged()) {
                    if (this.getSchemaId() != null) {
                        command.setSqlText("update settings set set_value = :set_value where set_usr_id = :set_usr_id and set_sch_id = :set_sch_id and set_group = :set_group and set_name = :set_name");
                        command.paramByName("set_sch_id").setString(this.getSchemaId());
                    } else {
                        command.setSqlText("update settings set set_value = :set_value where set_usr_id = :set_usr_id and set_sch_id is null and set_group = :set_group and set_name = :set_name");
                    }
                }
                if (se.isNewest() || se.isChanged()) {
                    command.paramByName("set_usr_id").setString(Application.get().getUserId());
                    command.paramByName("set_group").setString(this.getGroupName().toLowerCase());
                    command.paramByName("set_name").setString(se.getName());
                    command.paramByName("set_value").setString(se.getValue().toString());
                    command.execute();
                }
                se.setChanged(false);
                se.setNewest(false);
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    @Override
    public void load() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInternal() {
        loaded = true;
        if (InternalDatabase.get() == null) {
            return;
        }
        try {
            Query query = InternalDatabase.get().createQuery();
            try {
                query.setSqlText("select set_sch_id, set_group, set_name, set_value from settings where set_usr_id = :set_usr_id order by set_sch_id, set_group");
                query.paramByName("set_usr_id").setString(Application.get().getUserId());
                try {
                    query.open();
                }
                catch (Exception ex) {
                    ((OrbadaDatabase)InternalDatabase.get()).executeCommand("CREATE TABLE SETTINGS(SET_USR_ID VARCHAR(40) NOT NULL, SET_SCH_ID VARCHAR(40), SET_GROUP VARCHAR(100) NOT NULL,SET_NAME VARCHAR(200) NOT NULL, SET_VALUE VARCHAR(4000))");
                    ((OrbadaDatabase)InternalDatabase.get()).executeCommandNoException("ALTER TABLE SETTINGS ADD CONSTRAINT SETTINGS_SCHEMA_FK FOREIGN KEY (SET_SCH_ID) REFERENCES SCHEMAS(SCH_ID) ON DELETE CASCADE");
                    ((OrbadaDatabase)InternalDatabase.get()).executeCommandNoException("alter table settings add constraint setting_user_fk foreign key (set_usr_id) references users (usr_id) on delete cascade");
                    ((OrbadaDatabase)InternalDatabase.get()).executeCommand("CREATE INDEX SETTINGS_UI ON SETTINGS (SET_USR_ID, SET_GROUP, SET_NAME)");
                    ((OrbadaDatabase)InternalDatabase.get()).executeCommand("CREATE UNIQUE INDEX SETTINGS_SCHEMA_GROUP_I ON SETTINGS (SET_USR_ID, SET_SCH_ID, SET_GROUP, SET_NAME)");
                    ((OrbadaDatabase)InternalDatabase.get()).executeCommand("CREATE INDEX SETTINGS_SCHEMA_I ON SETTINGS (SET_SCH_ID)");
                    query.open();
                }
                GroupMap gmap = null;
                NameMap nmap = null;
                String set_sch_id = null;
                String set_group = null;
                while (!query.eof()) {
                    if (!StringUtil.equals(set_sch_id, (String)query.fieldByName("set_sch_id").getString())) {
                        set_sch_id = query.fieldByName("set_sch_id").getString();
                        gmap = new GroupMap();
                        map.put(set_sch_id, gmap);
                    }
                    if (!StringUtil.equals(set_group, (String)query.fieldByName("set_group").getString().toLowerCase())) {
                        set_group = query.fieldByName("set_group").getString().toLowerCase();
                        nmap = new NameMap();
                        gmap.put(set_group, nmap);
                    }
                    nmap.put(query.fieldByName("set_name").getString().toLowerCase(), new SettingElement(query.fieldByName("set_name").getString(), new Variant((Object)query.fieldByName("set_value").getValue())));
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private static class SchemaMap
    extends HashMap<String, GroupMap> {
        private SchemaMap() {
        }
    }

    private static class GroupMap
    extends HashMap<String, NameMap> {
        private GroupMap() {
        }
    }

    private static class NameMap
    extends HashMap<String, SettingElement> {
        private NameMap() {
        }
    }
}

