/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.util.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.util.settings.OrbadaSettings;
import pl.mpak.util.variant.Variant;

public class FileSettings
extends OrbadaSettings {
    private Properties properties = new Properties();

    private String getPath() {
        String pathName = Application.get().getConfigPath();
        pathName = pathName + "/fs";
        pathName = this.getSchemaId() != null ? pathName + "/schemas/" + this.getSchemaId() : pathName + "/global";
        return pathName;
    }

    private String getFileName() {
        return this.getPath() + "/" + this.getGroupName() + ".properties";
    }

    @Override
    public void load() {
        try {
            this.properties.load(new FileInputStream(this.getFileName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(String name, Variant value) {
        this.properties.setProperty(name, value.toString());
    }

    public Variant getValue(String name) {
        return new Variant(this.properties.getProperty(name));
    }

    public Variant getValue(String name, Variant defaultValue) {
        return new Variant(this.properties.getProperty(name, defaultValue.toString()));
    }

    public void store() {
        try {
            File file = new File(this.getPath());
            file.mkdirs();
            this.properties.store(new FileOutputStream(this.getFileName()), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

