/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.util.settings;

import java.awt.Color;
import java.awt.Font;
import java.util.Date;
import java.util.StringTokenizer;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public abstract class OrbadaSettings
implements ISettings {
    private String groupName;
    private String schemaId;

    public abstract void load();

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public void setValue(String name, String value) {
        this.setValue(name, new Variant(value));
    }

    public void setValue(String name, Long value) {
        this.setValue(name, new Variant((Object)value));
    }

    public void setValue(String name, Boolean value) {
        this.setValue(name, new Variant((Object)value));
    }

    public void setValue(String name, Color value) {
        this.setValue(name, new Variant(value == null ? null : Integer.valueOf(value.getRGB())));
    }

    public void setValue(String name, Date value) {
        this.setValue(name, new Variant(value == null ? null : Long.valueOf(value.getTime())));
    }

    private String getFontText(Font value) {
        String fontText = null;
        if (value != null) {
            fontText = value.getFontName() + "," + value.getSize() + "," + value.getStyle();
        }
        return fontText;
    }

    private Font getFontFromText(String fontText) {
        if (fontText == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(fontText, ",");
        String name = null;
        int size = 0;
        int style = 0;
        if (!st.hasMoreTokens()) {
            return null;
        }
        name = st.nextToken();
        try {
            if (st.hasMoreTokens()) {
                size = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                style = Integer.parseInt(st.nextToken());
            }
        }
        catch (NumberFormatException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
        return new Font(name, style, size);
    }

    public void setValue(String name, Font value) {
        this.setValue(name, new Variant(this.getFontText(value)));
    }

    public String getValue(String name, String defaultValue) {
        return this.getValue(name, new Variant(defaultValue)).toString();
    }

    public Long getValue(String name, Long defaultValue) {
        Variant v = this.getValue(name, new Variant((Object)defaultValue));
        if (v.isNullValue()) {
            return null;
        }
        try {
            return v.getLong();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Boolean getValue(String name, Boolean defaultValue) {
        Variant v = this.getValue(name, new Variant((Object)defaultValue));
        if (v.isNullValue()) {
            return null;
        }
        try {
            return v.getBoolean();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Color getValue(String name, Color defaultValue) {
        Variant v = this.getValue(name, new Variant(defaultValue == null ? null : Integer.valueOf(defaultValue.getRGB())));
        if (v.isNullValue()) {
            return null;
        }
        try {
            return new Color(v.getInteger());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Date getValue(String name, Date defaultValue) {
        Variant v = this.getValue(name, new Variant(defaultValue == null ? null : Long.valueOf(defaultValue.getTime())));
        if (v.isNullValue()) {
            return null;
        }
        try {
            return new Date(v.getLong());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Font getValue(String name, Font defaultValue) {
        Variant v = this.getValue(name, new Variant(defaultValue == null ? null : this.getFontText(defaultValue)));
        if (v.isNullValue()) {
            return null;
        }
        try {
            return this.getFontFromText(v.getString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

