/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.util.settings;

import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.util.settings.DatabaseSettings;
import pl.mpak.orbada.util.settings.OrbadaSettings;
import pl.mpak.util.ExceptionUtil;

public class SettingsFactory {
    public static final String defaultSettingsClass = DatabaseSettings.class.getCanonicalName();

    public static ISettings createInstance(String groupName) {
        return SettingsFactory.createInstance(null, groupName);
    }

    public static ISettings createInstance(String schemaId, String groupName) {
        String className = Application.get().getProperty("settings.class");
        if (className == null || "".equals(className)) {
            className = defaultSettingsClass;
        }
        try {
            OrbadaSettings os = (OrbadaSettings)Application.get().getClass().getClassLoader().loadClass(className).newInstance();
            os.setGroupName(groupName);
            os.setSchemaId(schemaId);
            os.load();
            return os;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            System.exit(-1);
            return null;
        }
    }
}

