/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.util.tools;

import java.awt.Component;
import java.util.HashMap;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Tool;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ToolList {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private HashMap<String, Tool> toolMap = new HashMap();

    public ToolList() {
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.toolMap.clear();
        if (InternalDatabase.get() != null) {
            Query query = InternalDatabase.get().createQuery();
            try {
                query.setSqlText("select * from tools where to_usr_id = :to_usr_id");
                query.paramByName("to_usr_id").setString(Application.get().getUserId());
                query.open();
                while (!query.eof()) {
                    Tool tool = new Tool(InternalDatabase.get());
                    tool.updateFrom(query);
                    this.toolMap.put(tool.getCommand().toUpperCase(), tool);
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
        }
    }

    public Tool get(String command) {
        return this.toolMap.get(command.toUpperCase());
    }

    public Tool[] toArray() {
        return this.toolMap.values().toArray(new Tool[this.toolMap.size()]);
    }

    public void exec(String command, Object[] args) {
        Tool tool = this.get(command);
        if (tool != null) {
            tool.exec(Application.get().getMainFrame().getActiveDatabase(), args);
        } else {
            MessageBox.show((Component)Application.get().getMainFrame(), (String)stringManager.getString("ToolList-program"), (String)String.format(stringManager.getString("ToolList-no-program-to-call"), command), (int)1, (int)0);
        }
    }
}

