/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.laf.jgoodies.gui;

import com.jgoodies.looks.plastic.theme.BrownSugar;
import com.jgoodies.looks.plastic.theme.DarkStar;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import com.jgoodies.looks.plastic.theme.DesertGreen;
import com.jgoodies.looks.plastic.theme.DesertRed;
import com.jgoodies.looks.plastic.theme.DesertYellow;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.jgoodies.looks.plastic.theme.ExperienceGreen;
import com.jgoodies.looks.plastic.theme.ExperienceRoyale;
import com.jgoodies.looks.plastic.theme.LightGray;
import com.jgoodies.looks.plastic.theme.Silver;
import com.jgoodies.looks.plastic.theme.SkyBlue;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import com.jgoodies.looks.plastic.theme.SkyGreen;
import com.jgoodies.looks.plastic.theme.SkyKrupp;
import com.jgoodies.looks.plastic.theme.SkyPink;
import com.jgoodies.looks.plastic.theme.SkyRed;
import com.jgoodies.looks.plastic.theme.SkyYellow;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.plaf.metal.MetalTheme;
import pl.mpak.orbada.laf.jgoodies.OrbadaLafJGoodiesPlugin;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class GlobalOptionsSettingsPanel
extends JPanel
implements ISettingsComponent {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLafJGoodiesPlugin.class);
    private IApplication application;
    private File propFile;
    private Properties props;
    private String[] themeNames;
    private Class[] themeClasses = new Class[]{BrownSugar.class, DarkStar.class, DesertBlue.class, DesertGreen.class, DesertRed.class, DesertYellow.class, ExperienceBlue.class, ExperienceGreen.class, ExperienceRoyale.class, LightGray.class, Silver.class, SkyBlue.class, SkyBluer.class, SkyGreen.class, SkyKrupp.class, SkyPink.class, SkyRed.class, SkyYellow.class};
    private int selectedTheme = -1;
    private JCheckBox checkPopupDropShadowEnabled;
    private JCheckBox checkTabIconsEnabled;
    private JCheckBox checkUseNarrowButtons;
    private JCheckBox checkUseSystemFonts;
    private ComboBox comboTabStyle;
    private ComboBox comboTheme;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;

    public GlobalOptionsSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.themeNames = new String[this.themeClasses.length];
        for (int i = 0; i < this.themeClasses.length; ++i) {
            try {
                this.themeNames[i] = ((MetalTheme)this.themeClasses[i].newInstance()).getName();
                continue;
            }
            catch (Exception ex) {
                this.themeNames[i] = "???";
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.comboTheme.setModel(new DefaultComboBoxModel<String>(this.themeNames));
        this.propFile = new File(this.application.getConfigPath() + "/" + "laf-jgoodies.properties");
        this.props = new Properties();
        if (this.propFile.exists()) {
            try {
                this.props.load(new FileInputStream(this.propFile));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkPopupDropShadowEnabled.setSelected(StringUtil.toBoolean((String)this.props.getProperty("popup-drop-shadow-enabled", "true")));
        this.checkTabIconsEnabled.setSelected(StringUtil.toBoolean((String)this.props.getProperty("tab-icons-enabled", "true")));
        this.checkUseNarrowButtons.setSelected(StringUtil.toBoolean((String)this.props.getProperty("use-narrow-buttons", "true")));
        this.checkUseSystemFonts.setSelected(StringUtil.toBoolean((String)this.props.getProperty("use-system-fonts", "true")));
        String currentTheme = this.props.getProperty("current-theme", this.themeClasses[0].getName());
        for (int i = 0; i < this.themeClasses.length; ++i) {
            if (!this.themeClasses[i].getName().equals(currentTheme)) continue;
            this.comboTheme.setSelectedIndex(i);
            break;
        }
        if (this.comboTheme.getSelectedIndex() == -1) {
            this.comboTheme.setSelectedIndex(0);
        }
        this.comboTabStyle.setSelectedItem((Object)this.props.getProperty("tab-style", "Metal"));
    }

    public void applySettings() {
        this.props.setProperty("popup-drop-shadow-enabled", this.checkPopupDropShadowEnabled.isSelected() ? "true" : "false");
        this.props.setProperty("tab-icons-enabled", this.checkTabIconsEnabled.isSelected() ? "true" : "false");
        this.props.setProperty("use-narrow-buttons", this.checkUseNarrowButtons.isSelected() ? "true" : "false");
        this.props.setProperty("use-system-fonts", this.checkUseSystemFonts.isSelected() ? "true" : "false");
        this.props.setProperty("current-theme", this.themeClasses[this.comboTheme.getSelectedIndex()].getName());
        this.props.setProperty("tab-style", this.comboTabStyle.getText());
        try {
            this.props.store(new FileOutputStream(this.propFile), "");
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        if (this.selectedTheme != this.comboTheme.getSelectedIndex() && StringUtil.equalAnyOfString((String)this.application.getSettings("orbada-settings").getValue("look-and-feel", ""), (String[])new String[]{"jgoodies-windows-look-and-feel-service", "jgoodies-plastic-look-and-feel-service", "jgoodies-plastic-3d-look-and-feel-service", "jgoodies-plastic-xp-look-and-feel-service"})) {
            this.application.updateLAF();
        }
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.checkPopupDropShadowEnabled = new JCheckBox();
        this.checkTabIconsEnabled = new JCheckBox();
        this.checkUseNarrowButtons = new JCheckBox();
        this.checkUseSystemFonts = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.comboTheme = new ComboBox();
        this.jLabel1 = new JLabel();
        this.comboTabStyle = new ComboBox();
        this.checkPopupDropShadowEnabled.setText(this.stringManager.getString("checkPopupDropShadowEnabled-text"));
        this.checkTabIconsEnabled.setText(this.stringManager.getString("checkTabIconsEnabled-text"));
        this.checkUseNarrowButtons.setText(this.stringManager.getString("checkUseNarrowButtons-text"));
        this.checkUseSystemFonts.setText(this.stringManager.getString("checkUseSystemFonts-text"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("settings-for-plastic-laf")));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("theme-dd"));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("tab-style-dd"));
        this.comboTabStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "Metal"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 126, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboTheme, -2, 164, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 126, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboTabStyle, -2, 164, -2))).addContainerGap(219, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.comboTheme, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.comboTabStyle, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.checkPopupDropShadowEnabled).addComponent(this.checkTabIconsEnabled).addComponent(this.checkUseNarrowButtons).addComponent(this.checkUseSystemFonts)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkPopupDropShadowEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkTabIconsEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUseNarrowButtons).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUseSystemFonts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(154, Short.MAX_VALUE)));
    }
}

