/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.StringTokenizer;
import pl.mpak.startup.StartupClassLoader;

public class Main {
    private static File startupJar;
    private static StartupClassLoader classLoader;
    private static String[] fileToDelete;

    private static void searchLibPath(StartupClassLoader startupClassLoader, String string) {
        File[] fileArray = new File(string).listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toUpperCase().endsWith(".JAR");
            }
        });
        if (fileArray != null) {
            try {
                for (File file : fileArray) {
                    boolean bl = false;
                    for (String string2 : fileToDelete) {
                        if (!string2.equalsIgnoreCase(file.getName())) continue;
                        file.delete();
                        System.out.println("Deleted " + file);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    startupClassLoader.addURL(file.toURI().toURL());
                    System.out.println("Added " + file);
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                System.exit(-1);
            }
        }
        if ((fileArray = new File(string).listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return new File(file.getAbsolutePath() + "/" + string).isDirectory();
            }
        })) != null) {
            for (File file : fileArray) {
                Main.searchLibPath(startupClassLoader, file.getAbsolutePath());
            }
        }
    }

    public static void main(String[] stringArray) {
        if (ClassLoader.getSystemClassLoader() instanceof StartupClassLoader) {
            classLoader = (StartupClassLoader)ClassLoader.getSystemClassLoader();
        } else {
            System.out.println("Can not start application, invalid class loader!");
            System.exit(-1);
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("startup.ini"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
        if (properties.getProperty("Startup-Jar") == null) {
            File[] fileArray = new File(".").listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toUpperCase().endsWith(".JAR");
                }
            });
            for (File file : fileArray) {
                if (file.getName().equalsIgnoreCase("startup.jar")) continue;
                startupJar = file;
                break;
            }
        } else {
            startupJar = new File(properties.getProperty("Startup-Jar"));
        }
        if (startupJar == null) {
            System.out.println("Can not start application, startup jar not found!");
            System.exit(-1);
        }
        try {
            System.out.println("Startup with " + startupJar);
            classLoader.addURL(startupJar.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(-1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("Lib-Path", "lib;plugins"), ";");
        while (stringTokenizer.hasMoreTokens()) {
            Main.searchLibPath(classLoader, stringTokenizer.nextToken());
        }
        System.out.println("Start Main invocation");
        try {
            Class<?> clazz = classLoader.loadClass(properties.getProperty("Startup-Main"));
            Method method = clazz.getDeclaredMethod("main", String[].class);
            method.invoke(clazz, new Object[]{stringArray});
            System.out.println("End Main invocation");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    static {
        fileToDelete = new String[]{"hsqldb.jar", "pl.mpak.parser-1.0.0.jar", "pl.mpak.plugins-1.0.0.jar", "pl.mpak.g2-1.0.0.jar", "pl.mpak.id-1.0.0.jar", "pl.mpak.task-1.0.1.jar", "pl.mpak.util-1.0.0.jar", "pl.mpak.sky-2.0.0.jar", "pl.mpak.usedb-1.2.0.jar", "pl.mpak.datatext-1.0.0.jar", "pl.mpak.doscharset-1.0.0.jar", "pl.mpak.waitdlg-1.0.0.jar", "pl.mpak-1.0.0.jar", "swing-layout-1.0.3.jar"};
    }
}

