/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.reports.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.reports.Sql;
import pl.mpak.orbada.reports.db.ReportRecord;
import pl.mpak.orbada.reports.gui.ReportUserListPanel;
import pl.mpak.orbada.reports.util.Applyable;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.util.ExceptionUtil;

public class ReportEditDialog
extends JDialog {
    private Database database;
    private Database forDatabase;
    private String orep_id;
    private String orepg_id;
    private boolean shared;
    private boolean rootReport;
    private String orep_owner_id;
    private int modalResult = 0;
    private ReportRecord report;
    private RecordLink dataLink;
    private ArrayList<ReportRecord> detailList;
    private ArrayList<ReportRecord> deletedList;
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonDeleteDetail;
    private JButton buttonEditDetail;
    private JButton buttonNewDetail;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmDeleteDetail;
    private Action cmEditDetail;
    private Action cmNewDetail;
    private Action cmOk;
    private ComboBox comboType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel panelDetailReports;
    private JTabbedPane tabbedReport;
    private Table tableDetails;
    private TextArea textDescription;
    private TextField textId;
    private TextField textName;
    private OrbadaSyntaxTextArea textSql;
    private TextField textTooltip;

    public ReportEditDialog(Database forDatabase, Database database, String orep_id, String orepg_id, boolean shared) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.database = database;
        this.forDatabase = forDatabase;
        this.orep_id = orep_id;
        this.orepg_id = orepg_id;
        this.shared = shared;
        this.rootReport = true;
        this.initComponents();
        this.init();
    }

    public ReportEditDialog(Database forDatabase, Database database, String orep_id, ReportRecord report) throws IntrospectionException, UseDBException {
        this.database = database;
        this.forDatabase = forDatabase;
        this.orep_owner_id = orep_id;
        this.report = report;
        this.initComponents();
        this.init();
    }

    public static String showDialog(Database forDatabase, Database database, String orep_id, String orepg_id, boolean shared) throws IntrospectionException, UseDBException {
        ReportEditDialog dialog = new ReportEditDialog(forDatabase, database, orep_id, orepg_id, shared);
        dialog.setVisible(true);
        return dialog.getModalResult() == 1 ? dialog.orep_id : null;
    }

    public static ReportRecord showDialog(Database forDatabase, Database database, String orep_id, ReportRecord report) throws IntrospectionException, UseDBException {
        ReportEditDialog dialog = new ReportEditDialog(forDatabase, database, orep_id, report);
        dialog.setVisible(true);
        return dialog.getModalResult() == 1 ? dialog.report : null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    private void init() throws IntrospectionException, UseDBException {
        this.comboType.setModel(new DefaultComboBoxModel<String>(new String[]{ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("tabelarical")}));
        if (!this.rootReport) {
            this.tabbedReport.remove(this.panelDetailReports);
        } else {
            this.detailList = new ArrayList();
            this.deletedList = new ArrayList();
        }
        this.textSql.setDatabase(this.forDatabase);
        this.dataLink = new RecordLink();
        this.dataLink.add("OREP_ID", (Component)this.textId);
        this.dataLink.add("OREP_NAME", (Component)this.textName, (IFieldRequires)new FieldRequeiredNotNull(ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("report_name")));
        this.dataLink.add("OREP_TOOLTIP", (Component)this.textTooltip);
        this.dataLink.add("OREP_DESCRIPTION", (Component)this.textDescription);
        this.dataLink.add("OREP_SQL", (Component)this.textSql);
        if (this.report == null) {
            if (this.orep_id != null) {
                this.report = new ReportRecord(this.database, this.orep_id);
                if (this.rootReport) {
                    this.loadDetails();
                }
            } else {
                this.report = new ReportRecord(this.database);
                this.report.setOrepgId(this.orepg_id);
                this.report.setOrepId(this.orep_owner_id);
            }
        }
        this.dataLink.updateComponents((BufferedRecord)this.report);
        if ("T".equals(this.report.getType())) {
            this.comboType.setSelectedIndex(0);
        }
        if (this.shared) {
            this.tabbedReport.addTab(ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("users"), new ReportUserListPanel(this.database, this.report.getId()));
        }
        if (this.rootReport) {
            this.cmEditDetail.setEnabled(false);
            this.cmDeleteDetail.setEnabled(false);
            this.tableDetails.setModel(this.getDetailsTableModel());
            this.tableDetails.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(0, 300, ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("name")));
            this.tableDetails.setSelectionMode(0);
            this.tableDetails.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ReportEditDialog.this.cmEditDetail.setEnabled(ReportEditDialog.this.tableDetails.getSelectedRow() >= 0);
                    ReportEditDialog.this.cmDeleteDetail.setEnabled(ReportEditDialog.this.tableDetails.getSelectedRow() >= 0);
                }
            });
            if (this.tableDetails.getRowCount() > 0) {
                this.tableDetails.changeSelection(0, 0, false, false);
            }
        }
        this.settings = Application.get().getSettings("orbada-reports-edit-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", Long.valueOf(this.getWidth())).intValue(), this.settings.getValue("height", Long.valueOf(this.getHeight())).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
        if (!this.rootReport) {
            this.setLocation(this.getX() + 30, this.getY() + 30);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDetails() {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getDetailReportList(null));
            query.paramByName("OREP_ID").setString(this.report.getId());
            query.open();
            while (!query.eof()) {
                ReportRecord r = new ReportRecord(this.database);
                r.updateFrom(query);
                r.setExists(true);
                this.detailList.add(r);
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private TableModel getDetailsTableModel() {
        AbstractTableModel model = new AbstractTableModel(){

            public int getRowCount() {
                return ReportEditDialog.this.detailList.size();
            }

            public int getColumnCount() {
                return 0;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((ReportRecord)ReportEditDialog.this.detailList.get(rowIndex)).getName();
                    }
                }
                return null;
            }
        };
        return model;
    }

    private void updateProject() throws Exception {
        this.dataLink.updateRecord((BufferedRecord)this.report);
        if (this.comboType.getSelectedIndex() <= 0) {
            this.report.setType("T");
        }
        if (this.report.isChanged()) {
            if (this.orep_id == null) {
                if (this.rootReport) {
                    this.report.applyInsert();
                }
                this.orep_id = this.report.getId();
            } else if (this.rootReport) {
                this.report.applyUpdate();
            }
        }
        if (this.rootReport && this.shared) {
            for (int i = 0; i < this.tabbedReport.getComponentCount(); ++i) {
                Component c = this.tabbedReport.getComponentAt(i);
                if (!(c instanceof Applyable)) continue;
                ((Applyable)((Object)c)).apply();
            }
        }
        if (this.rootReport) {
            for (ReportRecord r : this.deletedList) {
                r.applyDelete();
            }
            for (ReportRecord r : this.detailList) {
                if (!r.isChanged()) continue;
                if (r.isExists()) {
                    r.applyUpdate();
                    continue;
                }
                r.applyInsert();
            }
        }
    }

    public void dispose() {
        this.settings.setValue("width", Long.valueOf(this.getWidth()));
        this.settings.setValue("height", Long.valueOf(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmNewDetail = new Action();
        this.cmEditDetail = new Action();
        this.cmDeleteDetail = new Action();
        this.tabbedReport = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textId = new TextField();
        this.jLabel2 = new JLabel();
        this.textName = new TextField();
        this.jLabel3 = new JLabel();
        this.comboType = new ComboBox();
        this.jLabel7 = new JLabel();
        this.textTooltip = new TextField();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textDescription = new TextArea();
        this.jPanel3 = new JPanel();
        this.textSql = new OrbadaSyntaxTextArea();
        this.panelDetailReports = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tableDetails = new Table();
        this.buttonNewDetail = new JButton();
        this.buttonEditDetail = new JButton();
        this.buttonDeleteDetail = new JButton();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports");
        this.cmOk.setText(bundle.getString("ok"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(bundle.getString("cancel"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmNewDetail.setActionCommandKey("cmNewDetail");
        this.cmNewDetail.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_report.gif"));
        this.cmNewDetail.setText(bundle.getString("add"));
        this.cmNewDetail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportEditDialog.this.cmNewDetailActionPerformed(evt);
            }
        });
        this.cmEditDetail.setActionCommandKey("cmEditDetail");
        this.cmEditDetail.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEditDetail.setText(bundle.getString("edit"));
        this.cmEditDetail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportEditDialog.this.cmEditDetailActionPerformed(evt);
            }
        });
        this.cmDeleteDetail.setActionCommandKey("cmDeleteDetail");
        this.cmDeleteDetail.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDeleteDetail.setText(bundle.getString("delete"));
        this.cmDeleteDetail.setTooltip(bundle.getString("deleting_detail_report"));
        this.cmDeleteDetail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportEditDialog.this.cmDeleteDetailActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(bundle.getString("report"));
        this.setModal(true);
        this.tabbedReport.setFocusable(false);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(bundle.getString("unique_id"));
        this.textId.setEditable(false);
        this.textId.setFocusable(false);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(bundle.getString("report_name_collon"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(bundle.getString("type"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(bundle.getString("tooltip_collon"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(bundle.getString("details_colon"));
        this.textDescription.setColumns(20);
        this.textDescription.setRows(5);
        this.textDescription.setFont(new Font("Monospaced", 0, 14));
        this.jScrollPane1.setViewportView((Component)this.textDescription);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textId, -1, 439, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 439, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboType, -2, 237, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, -2, 119, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 439, Short.MAX_VALUE).addComponent((Component)this.textTooltip, GroupLayout.Alignment.LEADING, -1, 439, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.comboType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.textTooltip, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jScrollPane1, -1, 198, Short.MAX_VALUE)).addContainerGap()));
        this.tabbedReport.addTab(bundle.getString("report"), this.jPanel1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.textSql, -1, 562, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.textSql, -1, 304, Short.MAX_VALUE).addContainerGap()));
        this.tabbedReport.addTab(bundle.getString("sql_command"), this.jPanel3);
        this.tableDetails.setAutoCreateRowSorter(true);
        this.tableDetails.setRowHeight(18);
        this.jScrollPane2.setViewportView((Component)this.tableDetails);
        this.buttonNewDetail.setAction((javax.swing.Action)this.cmNewDetail);
        this.buttonNewDetail.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNewDetail.setPreferredSize(new Dimension(85, 25));
        this.buttonEditDetail.setAction((javax.swing.Action)this.cmEditDetail);
        this.buttonEditDetail.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEditDetail.setPreferredSize(new Dimension(85, 25));
        this.buttonDeleteDetail.setAction((javax.swing.Action)this.cmDeleteDetail);
        this.buttonDeleteDetail.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDeleteDetail.setPreferredSize(new Dimension(85, 25));
        GroupLayout panelDetailReportsLayout = new GroupLayout(this.panelDetailReports);
        this.panelDetailReports.setLayout(panelDetailReportsLayout);
        panelDetailReportsLayout.setHorizontalGroup(panelDetailReportsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDetailReportsLayout.createSequentialGroup().addContainerGap().addGroup(panelDetailReportsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 562, Short.MAX_VALUE).addGroup(panelDetailReportsLayout.createSequentialGroup().addComponent(this.buttonNewDetail, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEditDetail, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDeleteDetail, -2, -1, -2))).addContainerGap()));
        panelDetailReportsLayout.setVerticalGroup(panelDetailReportsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelDetailReportsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 273, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelDetailReportsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNewDetail, -2, -1, -2).addComponent(this.buttonEditDetail, -2, -1, -2).addComponent(this.buttonDeleteDetail, -2, -1, -2)).addContainerGap()));
        this.tabbedReport.addTab(bundle.getString("detail_reports"), this.panelDetailReports);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbedReport, GroupLayout.Alignment.LEADING, -1, 587, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedReport, -1, 351, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.updateProject();
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmNewDetailActionPerformed(ActionEvent evt) {
        try {
            ReportRecord r = ReportEditDialog.showDialog(this.forDatabase, this.database, this.report.getId(), null);
            if (r != null) {
                this.detailList.add(r);
                this.tableDetails.revalidate();
                this.tableDetails.changeSelection(this.tableDetails.getRowCount() - 1, 0, false, false);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmEditDetailActionPerformed(ActionEvent evt) {
        try {
            ReportRecord r;
            if (this.tableDetails.getSelectedRow() >= 0 && (r = ReportEditDialog.showDialog(this.forDatabase, this.database, this.report.fieldByName("orep_id").getString(), this.detailList.get(this.tableDetails.getSelectedRow()))) != null) {
                this.tableDetails.revalidate();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmDeleteDetailActionPerformed(ActionEvent evt) {
        if (this.tableDetails.getSelectedRow() >= 0) {
            int index = this.tableDetails.getSelectedRow();
            ReportRecord r = this.detailList.get(this.tableDetails.getSelectedRow());
            if (MessageBox.show((Component)this, (String)ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("deleting"), (String)(ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("delete_selected_report") + r.getName()), (int[])ModalResult.YESNO, (int)3) == 5) {
                if (r.isExists()) {
                    this.deletedList.add(r);
                }
                this.detailList.remove(this.tableDetails.getSelectedRow());
                this.tableDetails.revalidate();
                if (this.tableDetails.getRowCount() >= 0) {
                    if (this.tableDetails.getRowCount() == index) {
                        this.tableDetails.changeSelection(index - 1, 0, false, false);
                    } else {
                        this.tableDetails.changeSelection(index, 0, false, false);
                    }
                }
            }
        }
    }
}

