/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.reports.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.reports.db.ReportUsersUpdater;
import pl.mpak.orbada.reports.util.Applyable;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class ReportUserListPanel
extends JPanel
implements Applyable {
    private Database database;
    private String orep_id;
    private ArrayList<ReportUsersUpdater> list;
    private JScrollPane jScrollPane1;
    private Table tableUsers;

    public ReportUserListPanel(Database database, String orep_id) {
        this.database = database;
        this.orep_id = orep_id;
        this.list = new ArrayList();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableUsers.setModel((TableModel)new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ReportUserListPanel.this.list.size();
            }

            @Override
            public int getColumnCount() {
                return 0;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return (new Class[]{Boolean.class, String.class})[columnIndex];
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return ((ReportUsersUpdater)((Object)ReportUserListPanel.this.list.get(rowIndex))).isChecked();
                }
                if (columnIndex == 1) {
                    return ((ReportUsersUpdater)((Object)ReportUserListPanel.this.list.get(rowIndex))).getUsrName();
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    ReportUsersUpdater i = (ReportUsersUpdater)((Object)ReportUserListPanel.this.list.get(rowIndex));
                    if (((Boolean)aValue).booleanValue()) {
                        i.setChecked(true);
                    } else {
                        i.setChecked(false);
                    }
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                }
            }
        });
        this.tableUsers.setSelectionMode(0);
        this.tableUsers.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(0, 30, ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("zn")));
        this.tableUsers.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(1, 350, ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("users")));
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        this.list.clear();
        Query query = this.database.createQuery();
        try {
            query.setSqlText(ReportUsersUpdater.getSql());
            query.paramByName("orep_id").setString(this.orep_id);
            query.open();
            while (!query.eof()) {
                ReportUsersUpdater i = new ReportUsersUpdater(this.database);
                i.updateFrom(query);
                i.setUsrName(query.fieldByName("usr_name").getString());
                i.setExists(!"".equals(i.getId()));
                this.list.add(i);
                query.next();
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            query.close();
        }
        this.tableUsers.revalidate();
    }

    public void apply() throws Exception {
        for (ReportUsersUpdater u : this.list) {
            if (!u.isExists() && u.isChecked()) {
                u.setPrimaryKeyValue(new Variant(new UniqueID().toString()));
                u.applyInsert();
                continue;
            }
            if (u.isExists() && !u.isChecked()) {
                u.applyDelete();
                continue;
            }
            if (!u.isChanged()) continue;
            u.applyUpdate();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableUsers = new Table();
        this.tableUsers.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.tableUsers);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 463, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 282, Short.MAX_VALUE).addContainerGap()));
    }
}

