/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.reports.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.reports.db.ReportRecord;
import pl.mpak.orbada.reports.gui.ReportsTreePanel;
import pl.mpak.orbada.reports.gui.TableReportPanel;
import pl.mpak.orbada.reports.gui.nodes.ReportTreeNodeInfo;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;

public class ReportsPanelView
extends JPanel
implements Closeable {
    private IViewAccesibilities accesibilities;
    private boolean viewClosing = false;
    private ReportsTreePanel reportsTreePanel;
    private Action cmRun;
    private JSplitPane split;
    private JTabbedPane tabbedReports;

    public ReportsPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.reportsTreePanel = new ReportsTreePanel(this.accesibilities.getPerspectiveAccesibilities(), this.cmRun);
        this.split.setLeftComponent(this.reportsTreePanel);
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void close() throws IOException {
        this.viewClosing = true;
        while (this.tabbedReports.getTabCount() > 0) {
            Component c = this.tabbedReports.getComponentAt(0);
            if (c instanceof Closeable) {
                try {
                    ((Closeable)((Object)c)).close();
                }
                catch (IOException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
            this.tabbedReports.remove(c);
        }
        this.reportsTreePanel.close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRun = new Action();
        this.split = new JSplitPane();
        this.tabbedReports = new JTabbedPane();
        this.cmRun.setActionCommandKey("cmRun");
        this.cmRun.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        ResourceBundle bundle = ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports");
        this.cmRun.setText(bundle.getString("run_report"));
        this.cmRun.setTooltip(bundle.getString("run_report_tooltip"));
        this.cmRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsPanelView.this.cmRunActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(300);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.tabbedReports.setFocusable(false);
        this.split.setRightComponent(this.tabbedReports);
        this.add((Component)this.split, "Center");
    }

    private void cmRunActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.reportsTreePanel.getTree().getLastSelectedPathComponent();
        if (node != null) {
            ReportRecord report = ((ReportTreeNodeInfo)node.getUserObject()).getReport();
            final TableReportPanel panel = new TableReportPanel(this.accesibilities, report);
            TabCloseComponent tabClose = new TabCloseComponent(panel.getTitle(), new Action(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        panel.close();
                    }
                    catch (IOException ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                    ReportsPanelView.this.tabbedReports.remove(panel);
                }
            });
            this.tabbedReports.addTab(panel.getTitle(), panel);
            this.tabbedReports.setTabComponentAt(this.tabbedReports.indexOfComponent(panel), (Component)tabClose);
            this.tabbedReports.setSelectedComponent(panel);
        }
    }
}

