/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.reports.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.reports.Sql;
import pl.mpak.orbada.reports.db.ReportGroupList;
import pl.mpak.orbada.reports.db.ReportRecord;
import pl.mpak.orbada.reports.db.ReportsGroupRecord;
import pl.mpak.orbada.reports.gui.ReportEditDialog;
import pl.mpak.orbada.reports.gui.ReportGroupEditDialog;
import pl.mpak.orbada.reports.gui.ReportViewService;
import pl.mpak.orbada.reports.gui.ReportsTreeCellRenderer;
import pl.mpak.orbada.reports.gui.nodes.ReportGroupTreeNodeInfo;
import pl.mpak.orbada.reports.gui.nodes.ReportTreeNodeInfo;
import pl.mpak.orbada.reports.gui.nodes.RootGroupTreeNodeInfo;
import pl.mpak.orbada.reports.gui.nodes.TreeNodeWillExpand;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public class ReportsTreePanel
extends JPanel
implements Closeable {
    private IPerspectiveAccesibilities accesibilities;
    private boolean viewClosing = false;
    private Action runAction;
    private ToolButton buttonDelete;
    private ToolButton buttonEdit;
    private ToolButton buttonFreezeReport;
    private ToolButton buttonNewGroup;
    private ToolButton buttonNewReport;
    private ToolButton buttonRefresh;
    private ToolButton buttonRun;
    private Action cmCopy;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmFreezeReport;
    private Action cmNewGroup;
    private Action cmNewReport;
    private Action cmRefresh;
    private JPanel jPanel10;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JSeparator jSeparator5;
    private JMenuItem menuCopy;
    private JMenuItem menuDelete;
    private JMenuItem menuEdit;
    private JMenuItem menuNewGroup;
    private JMenuItem menuNewReport;
    private JPopupMenu menuSelectedNode;
    private JToolBar toolBar;
    private JTree treeReports;

    public ReportsTreePanel(IPerspectiveAccesibilities accesibilities, Action runAction) {
        this.accesibilities = accesibilities;
        this.runAction = runAction;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.runAction != null) {
            this.buttonRun.setAction((javax.swing.Action)this.runAction);
        } else {
            this.buttonRun.setVisible(false);
        }
        this.treeReports.setCellRenderer(new ReportsTreeCellRenderer());
        SwingUtil.addAction((JComponent)this.treeReports, (javax.swing.Action)this.cmCopy);
        this.reloadTree();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.open("select * from orep_groups where orepg_usr_id is null order by orepg_id");
            ReportGroupList groupList = new ReportGroupList();
            groupList.createFromQuery(query);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public JTree getTree() {
        return this.treeReports;
    }

    private void reloadTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        root.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new RootGroupTreeNodeInfo("<html>" + ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("html_report_for_driver") + " " + this.getDatabase().getDriverType(), this.getDatabase().getUserProperties().getProperty("dtp_id"), null, null, false))));
        root.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new RootGroupTreeNodeInfo("<html>" + ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("html_shared_reports"), null, null, null, true))));
        root.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new RootGroupTreeNodeInfo("<html>" + ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("html_user_reports") + " " + this.accesibilities.getApplication().getUserName(), null, null, this.accesibilities.getApplication().getUserId(), false))));
        this.treeReports.setModel(new DefaultTreeModel(root));
        if (root.getChildCount() > 0) {
            this.treeReports.setSelectionInterval(0, 0);
        }
    }

    private DefaultMutableTreeNode addNodeWillExpand(DefaultMutableTreeNode node) {
        node.add(new TreeNodeWillExpand());
        return node;
    }

    private boolean nodeWillExpand(DefaultMutableTreeNode node) {
        if (!node.isLeaf() && node.getChildCount() == 1) {
            return node.getChildAt(0) instanceof TreeNodeWillExpand;
        }
        return false;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.accesibilities = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalGroups(DefaultMutableTreeNode parent, String dtp_id, String orepg_id) {
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.setSqlText(Sql.getGlobalGroupList(null));
            query.paramByName("DTP_ID").setString(dtp_id);
            query.paramByName("OREPG_ID").setString(orepg_id);
            query.open();
            while (!query.eof()) {
                ReportsGroupRecord group = new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                group.updateFrom(query);
                parent.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new ReportGroupTreeNodeInfo(group))));
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSharedGroups(DefaultMutableTreeNode parent, String dtp_id, String sch_id, String usr_id) {
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.setSqlText(Sql.getSharedGroupList(null));
            query.paramByName("DTP_ID").setString(dtp_id);
            query.paramByName("SCH_ID").setString(sch_id);
            query.paramByName("USR_ID").setString(usr_id);
            query.open();
            while (!query.eof()) {
                ReportsGroupRecord group = new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                group.updateFrom(query);
                parent.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new ReportGroupTreeNodeInfo(group))));
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUserGroups(DefaultMutableTreeNode parent, String dtp_id, String sch_id, String usr_id) {
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.setSqlText(Sql.getUserGroupList(null));
            query.paramByName("DTP_ID").setString(dtp_id);
            query.paramByName("SCH_ID").setString(sch_id);
            query.paramByName("USR_ID").setString(usr_id);
            query.open();
            while (!query.eof()) {
                ReportsGroupRecord group = new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                group.updateFrom(query);
                parent.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new ReportGroupTreeNodeInfo(group))));
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroupsByGroup(DefaultMutableTreeNode parent, String dtp_id, String orepg_id) {
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.setSqlText(Sql.getGroupByGroupList(null));
            query.paramByName("DTP_ID").setString(dtp_id);
            query.paramByName("OREPG_ID").setString(orepg_id);
            query.open();
            while (!query.eof()) {
                ReportsGroupRecord group = new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                group.updateFrom(query);
                parent.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new ReportGroupTreeNodeInfo(group))));
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReports(DefaultMutableTreeNode parent, String orepg_id) {
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.setSqlText(Sql.getReportList(null));
            query.paramByName("OREPG_ID").setString(orepg_id);
            query.open();
            while (!query.eof()) {
                ReportRecord report = new ReportRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                report.updateFrom(query);
                parent.add(new DefaultMutableTreeNode(new ReportTreeNodeInfo(report)));
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmDelete = new Action();
        this.cmEdit = new Action();
        this.cmNewGroup = new Action();
        this.cmNewReport = new Action();
        this.menuSelectedNode = new JPopupMenu();
        this.menuNewGroup = new JMenuItem();
        this.menuNewReport = new JMenuItem();
        this.menuEdit = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuCopy = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.menuDelete = new JMenuItem();
        this.cmFreezeReport = new Action();
        this.cmCopy = new Action();
        this.jPanel10 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.buttonNewGroup = new ToolButton();
        this.buttonNewReport = new ToolButton();
        this.buttonEdit = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonRun = new ToolButton();
        this.buttonFreezeReport = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonDelete = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.treeReports = new JTree();
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        ResourceBundle bundle = ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports");
        this.cmRefresh.setText(bundle.getString("refresh"));
        this.cmRefresh.setTooltip(bundle.getString("refresh_tooltip"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsTreePanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmDelete.setActionCommandKey("cmDelete");
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(bundle.getString("delete_report_grup"));
        this.cmDelete.setTooltip(bundle.getString("delete_report_group_tooltip"));
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsTreePanel.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmEdit.setActionCommandKey("cmEdit");
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(bundle.getString("edit_report_group"));
        this.cmEdit.setTooltip(bundle.getString("edit_report_group_tooltip"));
        this.cmEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsTreePanel.this.cmEditActionPerformed(evt);
            }
        });
        this.cmNewGroup.setActionCommandKey("cmNewGroup");
        this.cmNewGroup.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_group.gif"));
        this.cmNewGroup.setText(bundle.getString("add_group"));
        this.cmNewGroup.setTooltip(bundle.getString("add_group_tooltip"));
        this.cmNewGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsTreePanel.this.cmNewGroupActionPerformed(evt);
            }
        });
        this.cmNewReport.setActionCommandKey("cmNewReport");
        this.cmNewReport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_report.gif"));
        this.cmNewReport.setText(bundle.getString("add_report"));
        this.cmNewReport.setTooltip(bundle.getString("add_report_tooltip"));
        this.cmNewReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsTreePanel.this.cmNewReportActionPerformed(evt);
            }
        });
        this.menuNewGroup.setAction((javax.swing.Action)this.cmNewGroup);
        this.menuSelectedNode.add(this.menuNewGroup);
        this.menuNewReport.setAction((javax.swing.Action)this.cmNewReport);
        this.menuSelectedNode.add(this.menuNewReport);
        this.menuEdit.setAction((javax.swing.Action)this.cmEdit);
        this.menuSelectedNode.add(this.menuEdit);
        this.menuSelectedNode.add(this.jSeparator1);
        this.menuCopy.setAction((javax.swing.Action)this.cmCopy);
        this.menuSelectedNode.add(this.menuCopy);
        this.menuSelectedNode.add(this.jSeparator5);
        this.menuDelete.setAction((javax.swing.Action)this.cmDelete);
        this.menuSelectedNode.add(this.menuDelete);
        this.cmFreezeReport.setActionCommandKey("cmFreezeReport");
        this.cmFreezeReport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeReport.setText(bundle.getString("run_and_freeze"));
        this.cmFreezeReport.setTooltip(bundle.getString("run_and_freeze_tooltip"));
        this.cmFreezeReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsTreePanel.this.cmFreezeReportActionPerformed(evt);
            }
        });
        this.cmCopy.setActionCommandKey("cmCopy");
        this.cmCopy.setShortCut(KeyStroke.getKeyStroke(67, 2));
        this.cmCopy.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/copy.gif"));
        this.cmCopy.setText(bundle.getString("copy"));
        this.cmCopy.setTooltip(bundle.getString("copy_sql_command_tooltip"));
        this.cmCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportsTreePanel.this.cmCopyActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new FlowLayout(0, 2, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.toolBar.add(this.jSeparator4);
        this.buttonNewGroup.setAction((javax.swing.Action)this.cmNewGroup);
        this.buttonNewGroup.setHorizontalTextPosition(0);
        this.buttonNewGroup.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonNewGroup);
        this.buttonNewReport.setAction((javax.swing.Action)this.cmNewReport);
        this.buttonNewReport.setHorizontalTextPosition(0);
        this.buttonNewReport.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonNewReport);
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setHorizontalTextPosition(0);
        this.buttonEdit.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonEdit);
        this.toolBar.add(this.jSeparator2);
        this.buttonRun.setHorizontalTextPosition(0);
        this.buttonRun.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRun);
        this.buttonFreezeReport.setAction((javax.swing.Action)this.cmFreezeReport);
        this.buttonFreezeReport.setHorizontalTextPosition(0);
        this.buttonFreezeReport.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFreezeReport);
        this.toolBar.add(this.jSeparator3);
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setHorizontalTextPosition(0);
        this.buttonDelete.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonDelete);
        this.jPanel10.add(this.toolBar);
        this.add((Component)this.jPanel10, "North");
        this.treeReports.setRootVisible(false);
        this.treeReports.setShowsRootHandles(true);
        this.treeReports.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            }

            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                ReportsTreePanel.this.treeReportsTreeWillExpand(evt);
            }
        });
        this.treeReports.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ReportsTreePanel.this.treeReportsMouseClicked(evt);
            }
        });
        this.treeReports.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ReportsTreePanel.this.treeReportsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.treeReports);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.reloadTree();
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeReports.getLastSelectedPathComponent();
        DefaultTreeModel model = (DefaultTreeModel)this.treeReports.getModel();
        try {
            if (node.getUserObject() instanceof ReportGroupTreeNodeInfo) {
                ReportGroupTreeNodeInfo info = (ReportGroupTreeNodeInfo)node.getUserObject();
                if (MessageBox.show((Component)this, (String)ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("deleting"), (String)(ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("delete_selected_group") + info.getName()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    ReportsGroupRecord group = new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                    group.setPrimaryKeyValue(new Variant(info.getReportsGroup().getId()));
                    group.applyDelete();
                    model.removeNodeFromParent(node);
                }
            } else if (node.getUserObject() instanceof ReportTreeNodeInfo) {
                ReportTreeNodeInfo info = (ReportTreeNodeInfo)node.getUserObject();
                if (MessageBox.show((Component)this, (String)ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("deleting"), (String)(ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("delete_report") + info.getName()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    ReportRecord report = new ReportRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                    report.setPrimaryKeyValue(new Variant(info.getReport().getId()));
                    report.applyDelete();
                    model.removeNodeFromParent(node);
                }
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeReports.getLastSelectedPathComponent();
        DefaultTreeModel model = (DefaultTreeModel)this.treeReports.getModel();
        try {
            TreePath selectedPath = this.treeReports.getLeadSelectionPath();
            this.treeReports.expandPath(selectedPath);
            if (node.getUserObject() instanceof ReportGroupTreeNodeInfo) {
                ReportGroupTreeNodeInfo info = (ReportGroupTreeNodeInfo)node.getUserObject();
                String id = ReportGroupEditDialog.showDialog(this.accesibilities.getApplication().getOrbadaDatabase(), info.getReportsGroup().getId());
                if (id != null) {
                    node.setUserObject(new ReportGroupTreeNodeInfo(new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase(), id)));
                    model.nodeStructureChanged(node);
                }
            } else if (node.getUserObject() instanceof ReportTreeNodeInfo) {
                String id;
                ReportTreeNodeInfo info = (ReportTreeNodeInfo)node.getUserObject();
                boolean shared = false;
                if (node.getParent() instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)node.getParent()).getUserObject() instanceof ReportGroupTreeNodeInfo) {
                    shared = ((ReportGroupTreeNodeInfo)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getReportsGroup().isShared();
                }
                if ((id = ReportEditDialog.showDialog(this.getDatabase(), this.accesibilities.getApplication().getOrbadaDatabase(), info.getReport().getId(), null, shared)) != null) {
                    node.setUserObject(new ReportTreeNodeInfo(new ReportRecord(this.accesibilities.getApplication().getOrbadaDatabase(), id)));
                    model.nodeStructureChanged(node);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewGroupActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeReports.getLastSelectedPathComponent();
        DefaultTreeModel model = (DefaultTreeModel)this.treeReports.getModel();
        try {
            TreePath selectedPath = this.treeReports.getLeadSelectionPath();
            this.treeReports.expandPath(selectedPath);
            if (node.getUserObject() instanceof RootGroupTreeNodeInfo) {
                RootGroupTreeNodeInfo info = (RootGroupTreeNodeInfo)node.getUserObject();
                String id = ReportGroupEditDialog.showDialog(this.accesibilities.getApplication().getOrbadaDatabase(), null, info.getDtpId(), info.getSchId(), info.getUsrId(), info.isShared());
                if (id != null) {
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ReportGroupTreeNodeInfo(new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase(), id)));
                    model.insertNodeInto(newNode, node, node.getChildCount());
                    TreePath newPath = new TreePath(newNode.getPath());
                    this.treeReports.scrollPathToVisible(newPath);
                    this.treeReports.setSelectionPath(newPath);
                }
            } else if (node.getUserObject() instanceof ReportGroupTreeNodeInfo) {
                ReportGroupTreeNodeInfo info = (ReportGroupTreeNodeInfo)node.getUserObject();
                String id = ReportGroupEditDialog.showDialog(this.accesibilities.getApplication().getOrbadaDatabase(), info.getReportsGroup().getId(), info.getReportsGroup().getDtpId(), info.getReportsGroup().getSchId(), info.getReportsGroup().getUsrId(), info.getReportsGroup().isShared());
                if (id != null) {
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ReportGroupTreeNodeInfo(new ReportsGroupRecord(this.accesibilities.getApplication().getOrbadaDatabase(), id)));
                    model.insertNodeInto(newNode, node, node.getChildCount());
                    TreePath newPath = new TreePath(newNode.getPath());
                    this.treeReports.scrollPathToVisible(newPath);
                    this.treeReports.setSelectionPath(newPath);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewReportActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeReports.getLastSelectedPathComponent();
        DefaultTreeModel model = (DefaultTreeModel)this.treeReports.getModel();
        try {
            TreePath selectedPath = this.treeReports.getLeadSelectionPath();
            this.treeReports.expandPath(selectedPath);
            if (node.getUserObject() instanceof ReportGroupTreeNodeInfo) {
                ReportGroupTreeNodeInfo info = (ReportGroupTreeNodeInfo)node.getUserObject();
                String id = ReportEditDialog.showDialog(this.getDatabase(), this.accesibilities.getApplication().getOrbadaDatabase(), null, info.getReportsGroup().getId(), info.getReportsGroup().isShared());
                if (id != null) {
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ReportTreeNodeInfo(new ReportRecord(this.accesibilities.getApplication().getOrbadaDatabase(), id)));
                    model.insertNodeInto(newNode, node, node.getChildCount());
                    TreePath newPath = new TreePath(newNode.getPath());
                    this.treeReports.scrollPathToVisible(newPath);
                    this.treeReports.setSelectionPath(newPath);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmFreezeReportActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeReports.getLastSelectedPathComponent();
        if (node != null) {
            ReportRecord report = ((ReportTreeNodeInfo)node.getUserObject()).getReport();
            this.accesibilities.createView((ViewProvider)new ReportViewService(report));
        }
    }

    private void treeReportsTreeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
        if (node != null && this.nodeWillExpand(node)) {
            node.removeAllChildren();
            if (node.getUserObject() instanceof RootGroupTreeNodeInfo) {
                RootGroupTreeNodeInfo info = (RootGroupTreeNodeInfo)node.getUserObject();
                if (info.isShared() && info.getDtpId() == null && info.getSchId() == null && info.getUsrId() == null) {
                    node.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new RootGroupTreeNodeInfo("<html>" + ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("html_report_for_driver") + " " + this.getDatabase().getDriverType(), this.getDatabase().getUserProperties().getProperty("dtp_id"), null, this.accesibilities.getApplication().getUserId(), true))));
                    node.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new RootGroupTreeNodeInfo("<html>" + ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("html_reports_for_schema") + " " + this.getDatabase().getPublicName(), this.getDatabase().getUserProperties().getProperty("dtp_id"), this.getDatabase().getUserProperties().getProperty("schemaId"), this.accesibilities.getApplication().getUserId(), true))));
                } else if (!info.isShared() && info.getDtpId() == null && info.getSchId() == null) {
                    node.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new RootGroupTreeNodeInfo("<html>" + ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("html_report_for_driver") + " " + this.getDatabase().getDriverType(), this.getDatabase().getUserProperties().getProperty("dtp_id"), null, this.accesibilities.getApplication().getUserId(), false))));
                    node.add(this.addNodeWillExpand(new DefaultMutableTreeNode(new RootGroupTreeNodeInfo("<html>" + ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("html_reports_for_schema") + " " + this.getDatabase().getPublicName(), this.getDatabase().getUserProperties().getProperty("dtp_id"), this.getDatabase().getUserProperties().getProperty("schemaId"), this.accesibilities.getApplication().getUserId(), false))));
                } else if (info.getSchId() == null && info.getUsrId() == null) {
                    this.loadGlobalGroups(node, info.getDtpId(), null);
                } else if (info.isShared()) {
                    this.loadSharedGroups(node, info.getDtpId(), info.getSchId(), info.getUsrId());
                } else {
                    this.loadUserGroups(node, info.getDtpId(), info.getSchId(), info.getUsrId());
                }
            } else if (node.getUserObject() instanceof ReportGroupTreeNodeInfo) {
                ReportGroupTreeNodeInfo info = (ReportGroupTreeNodeInfo)node.getUserObject();
                this.loadGroupsByGroup(node, info.getReportsGroup().getDtpId(), info.getReportsGroup().getId());
                this.loadReports(node, info.getReportsGroup().getId());
            }
        }
    }

    private void treeReportsMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            TreePath path = this.treeReports.getPathForLocation(evt.getX(), evt.getY());
            if (path != null) {
                this.treeReports.setSelectionPath(path);
                this.menuSelectedNode.show(this.treeReports, evt.getX(), evt.getY());
            }
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            if (this.runAction != null && this.runAction.isEnabled()) {
                this.runAction.performe();
            } else if (this.cmFreezeReport.isEnabled()) {
                this.cmFreezeReport.performe();
            }
        }
    }

    private void treeReportsValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeReports.getLastSelectedPathComponent();
        if (node != null) {
            if (node.getUserObject() instanceof RootGroupTreeNodeInfo) {
                RootGroupTreeNodeInfo info = (RootGroupTreeNodeInfo)node.getUserObject();
                this.cmNewGroup.setEnabled(info.getDtpId() != null || info.getSchId() != null);
                if (!this.accesibilities.getApplication().isUserAdmin() && info.getUsrId() == null) {
                    this.cmNewGroup.setEnabled(false);
                }
            } else if (node.getUserObject() instanceof ReportGroupTreeNodeInfo) {
                ReportGroupTreeNodeInfo info = (ReportGroupTreeNodeInfo)node.getUserObject();
                this.cmNewGroup.setEnabled(!info.getReportsGroup().isShared());
            } else {
                this.cmNewGroup.setEnabled(false);
            }
            this.cmEdit.setEnabled(!(node.getUserObject() instanceof RootGroupTreeNodeInfo));
            this.cmDelete.setEnabled(!(node.getUserObject() instanceof RootGroupTreeNodeInfo));
            this.cmNewReport.setEnabled(node.getUserObject() instanceof ReportGroupTreeNodeInfo);
            if (this.runAction != null) {
                this.runAction.setEnabled(node.getUserObject() instanceof ReportTreeNodeInfo);
            }
            this.cmFreezeReport.setEnabled(node.getUserObject() instanceof ReportTreeNodeInfo);
            this.cmCopy.setEnabled(node.getUserObject() instanceof ReportTreeNodeInfo);
        } else {
            this.cmNewGroup.setEnabled(false);
            this.cmEdit.setEnabled(false);
            this.cmDelete.setEnabled(false);
            this.cmNewReport.setEnabled(false);
            if (this.runAction != null) {
                this.runAction.setEnabled(false);
            }
            this.cmFreezeReport.setEnabled(false);
            this.cmCopy.setEnabled(false);
        }
    }

    private void cmCopyActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeReports.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() instanceof ReportTreeNodeInfo) {
            ReportTreeNodeInfo info = (ReportTreeNodeInfo)node.getUserObject();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(info.getReport().getSql());
            clipboard.setContents(data, data);
        }
    }
}

