/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.reports.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.reports.Sql;
import pl.mpak.orbada.reports.db.ReportRecord;
import pl.mpak.orbada.universal.gui.CommandParametersDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.RefreshEvent;
import pl.mpak.sky.gui.swing.comp.RefreshListener;
import pl.mpak.sky.gui.swing.comp.RefreshPanel;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Parameter;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumnModel;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.Titleable;
import pl.mpak.util.task.Task;

public class TableReportPanel
extends JPanel
implements Titleable,
Closeable {
    private IViewAccesibilities accessibilities;
    private ReportRecord report;
    private boolean viewClosing = false;
    private boolean refreshing = false;
    private ToolButton buttonCancelReport;
    private ToolButton buttonRefresh;
    private ToolButton buttonRun;
    private Action cmCancelReport;
    private Action cmRefresh;
    private Action cmRun;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private RefreshPanel refreshPanel;
    private JSplitPane split;
    private QueryTableStatusBar statusBar;
    private JTabbedPane tabbedDetails;
    private DataTable tableReport;
    private JToolBar toolBar;

    public TableReportPanel(IViewAccesibilities accessibilities, ReportRecord report) {
        this.accessibilities = accessibilities;
        this.report = report;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableReport.getQuery().setDatabase(this.getDatabase());
        this.statusBar.setTable((QueryTable)this.tableReport);
        this.prepareDetails();
        if (this.report.getOrepId() == null) {
            this.runReportTask(null);
        } else {
            this.buttonRun.setVisible(false);
            this.cmRun.setEnabled(false);
        }
    }

    public String getTitle() {
        return this.report.getName();
    }

    public Database getDatabase() {
        return this.accessibilities.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDetails() {
        Query query = this.report.getDatabase().createQuery();
        try {
            query.setSqlText(Sql.getDetailReportList(null));
            query.paramByName("OREP_ID").setString(this.report.getId());
            query.open();
            if (!query.eof()) {
                this.split.setDividerLocation(0.6f);
                while (!query.eof()) {
                    ReportRecord r = new ReportRecord(this.report.getDatabase());
                    r.updateFrom(query);
                    this.tabbedDetails.addTab(r.getName(), new TableReportPanel(this.accessibilities, r));
                    query.next();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        if (this.tabbedDetails.getTabCount() > 0) {
            this.tableReport.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
                int lastSelected = -1;

                public void valueChanged(ListSelectionEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (TableReportPanel.this.tableReport.getSelectedRow() >= 0 && lastSelected != TableReportPanel.this.tableReport.getSelectedRow()) {
                                lastSelected = TableReportPanel.this.tableReport.getSelectedRow();
                                try {
                                    TableReportPanel.this.tableReport.getQuery().getRecord(TableReportPanel.this.tableReport.getSelectedRow());
                                    for (int i = 0; i < TableReportPanel.this.tabbedDetails.getTabCount(); ++i) {
                                        Component c = TableReportPanel.this.tabbedDetails.getComponentAt(i);
                                        if (!(c instanceof TableReportPanel)) continue;
                                        ((TableReportPanel)c).refreshTableList(TableReportPanel.this.tableReport.getQuery());
                                    }
                                }
                                catch (Exception ex) {
                                    ExceptionUtil.processException((Throwable)ex);
                                }
                            }
                        }
                    });
                }
            });
        } else {
            this.split.setBottomComponent(null);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TableReportPanel.this.split.setDividerLocation(1.0);
                }
            });
        }
    }

    public void refreshTableList(Query query) {
        this.runReport(query);
    }

    private void runReportTask(final Query query) {
        this.getDatabase().getTaskPool().addTask(new Task(){

            public void run() {
                TableReportPanel.this.runReport(query);
            }
        });
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableReportPanel.this.refreshTableList();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTableList() {
        if (!SwingUtil.isVisible((Component)this) || this.viewClosing || !this.tableReport.getQuery().isActive() || this.refreshing) {
            return;
        }
        this.setRefreshing(true);
        try {
            int rowIndex = this.tableReport.getSelectedRow();
            int columnIndex = this.tableReport.getSelectedColumn();
            this.tableReport.getQuery().refresh();
            if (!this.tableReport.getQuery().eof()) {
                this.tableReport.changeSelection(rowIndex, columnIndex);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.setRefreshing(false);
        }
    }

    private void setRefreshing(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableReportPanel.this.cmRefresh.setEnabled(!value);
                TableReportPanel.this.cmRun.setEnabled(!value);
                TableReportPanel.this.cmCancelReport.setEnabled(value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReport(Query query) {
        this.setRefreshing(true);
        try {
            this.tableReport.getQuery().close();
            ((QueryTableColumnModel)this.tableReport.getColumnModel()).setAutoColumns(true);
            this.tableReport.setAutoFitWidth(true);
            this.tableReport.getQuery().setSqlText(this.report.getSql());
            if (this.tableReport.getQuery().getParameterCount() > 0) {
                if (query == null) {
                    if (CommandParametersDialog.showDialog((ParametrizedCommand)this.tableReport.getQuery())) {
                        this.tableReport.getQuery().open();
                    }
                } else {
                    for (int i = 0; i < this.tableReport.getQuery().getParameterCount(); ++i) {
                        Parameter p = this.tableReport.getQuery().getParameter(i);
                        if (p.getParamName().startsWith("&")) {
                            p.setValue((Object)query.fieldByName(p.getParamName().substring(1)).getValue());
                            continue;
                        }
                        p.setValue((Object)query.fieldByName(p.getParamName()).getValue());
                    }
                    this.tableReport.getQuery().open();
                }
            } else {
                this.tableReport.getQuery().open();
            }
            this.tableReport.setAutoFitWidth(false);
            ((QueryTableColumnModel)this.tableReport.getColumnModel()).setAutoColumns(false);
            if (this.tableReport.getQuery().isActive() && !this.tableReport.getQuery().eof()) {
                this.tableReport.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports").getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            this.setRefreshing(false);
        }
    }

    public void close() throws IOException {
        this.viewClosing = true;
        while (this.tabbedDetails.getTabCount() > 0) {
            Component c = this.tabbedDetails.getComponentAt(0);
            if (c instanceof Closeable) {
                try {
                    ((Closeable)((Object)c)).close();
                }
                catch (IOException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
            this.tabbedDetails.remove(c);
        }
        this.tableReport.getQuery().close();
        this.accessibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmRun = new Action();
        this.cmCancelReport = new Action();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonRun = new ToolButton();
        this.buttonCancelReport = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.refreshPanel = new RefreshPanel();
        this.split = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.statusBar = new QueryTableStatusBar();
        this.jScrollPane1 = new JScrollPane();
        this.tableReport = new DataTable();
        this.tabbedDetails = new JTabbedPane();
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        ResourceBundle bundle = ResourceBundle.getBundle("pl/mpak/orbada/orbada-reports");
        this.cmRefresh.setText(bundle.getString("refresh"));
        this.cmRefresh.setTooltip(bundle.getString("refresh_tooltip"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableReportPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmRun.setActionCommandKey("cmRun");
        this.cmRun.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmRun.setText(bundle.getString("run_report"));
        this.cmRun.setTooltip(bundle.getString("run_report_tooltip"));
        this.cmRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableReportPanel.this.cmRunActionPerformed(evt);
            }
        });
        this.cmCancelReport.setActionCommandKey("cmCancelReport");
        this.cmCancelReport.setEnabled(false);
        this.cmCancelReport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/cancel.gif"));
        this.cmCancelReport.setText("Anulowanie wykonania");
        this.cmCancelReport.setTooltip("Pozwala anulowa\u0107 wykonywanie raportu");
        this.cmCancelReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableReportPanel.this.cmCancelReportActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonRun.setAction((javax.swing.Action)this.cmRun);
        this.buttonRun.setHorizontalTextPosition(0);
        this.buttonRun.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRun);
        this.buttonCancelReport.setAction((javax.swing.Action)this.cmCancelReport);
        this.buttonCancelReport.setHorizontalTextPosition(0);
        this.buttonCancelReport.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonCancelReport);
        this.toolBar.add(this.jSeparator1);
        this.refreshPanel.addRefreshListener(new RefreshListener(){

            public void refresh(RefreshEvent evt) {
                TableReportPanel.this.refreshPanelRefresh(evt);
            }
        });
        this.toolBar.add((Component)this.refreshPanel);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
        this.split.setBorder(null);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.statusBar, "South");
        this.jScrollPane1.setViewportView((Component)this.tableReport);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.split.setLeftComponent(this.jPanel1);
        this.tabbedDetails.setFocusable(false);
        this.tabbedDetails.setPreferredSize(new Dimension(0, 300));
        this.split.setRightComponent(this.tabbedDetails);
        this.add((Component)this.split, "Center");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableListTask();
    }

    private void cmRunActionPerformed(ActionEvent evt) {
        this.runReportTask(null);
    }

    private void refreshPanelRefresh(RefreshEvent evt) {
        this.refreshTableList();
    }

    private void cmCancelReportActionPerformed(ActionEvent evt) {
        try {
            this.tableReport.getQuery().cancel();
        }
        catch (SQLException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

