/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.cyberboypw.services;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.ImageIcon;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.providers.PleaseWaitRendererProvider;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StreamUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.array.StringList;

public class CyberboyPleaseWaitRenderer
extends PleaseWaitRendererProvider {
    private static final int WAIT_X_SHIFT = 50;
    private static final int WAIT_Y_SHIFT = 60;
    public static final String uniqueId = "orbada-cyberboy-please-wait-renderer";
    private ArrayList<Image> waitImageList = new ArrayList();
    private int indexAnim;
    private Rectangle renderRectangle;

    public CyberboyPleaseWaitRenderer() {
        StringList sl = new StringList();
        try {
            sl.setText(StreamUtil.stream2String((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/pl/mpak/orbada/cyberboypw/res/anim.list")));
            for (int i = 0; i < sl.size(); ++i) {
                if (StringUtil.isEmpty((String)((String)sl.get(i)))) continue;
                try {
                    this.waitImageList.add(new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/orbada/cyberboypw/res/anim/" + (String)sl.get(i))).getImage());
                    continue;
                }
                catch (Throwable ex) {
                    System.out.println((String)sl.get(i));
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void beginProcess() {
        this.indexAnim = new Random().nextInt(this.waitImageList.size());
        Image image = this.waitImageList.get(this.indexAnim);
        int left = this.component.getWidth() - 50 - 30 - image.getWidth(null);
        int top = this.component.getHeight() - 60 - 30 - image.getHeight(null);
        this.renderRectangle = new Rectangle(left, top, this.component.getWidth() - left, this.component.getHeight() - top);
    }

    public void control() {
    }

    public void render(Graphics2D g2, PleaseWait[] waitArr) {
        FontMetrics fm = g2.getFontMetrics();
        int left = this.component.getWidth() - 50;
        int top = this.component.getHeight() - 60;
        Image image = this.waitImageList.get(this.indexAnim);
        g2.drawImage(image, left - image.getWidth(null), top - image.getHeight(null), null);
        int picWidth = 0;
        for (PleaseWait wait : waitArr) {
            if (wait.getImage() == null) continue;
            picWidth += wait.getImage().getWidth(null);
        }
        int picPos = 0;
        for (PleaseWait wait : waitArr) {
            if (wait.getImage() == null) continue;
            g2.drawImage(wait.getImage(), left - (image.getWidth(null) + picWidth) / 2 + picPos, top + 2, null);
            picPos += wait.getImage().getWidth(null);
        }
        int textPos = 0;
        for (PleaseWait wait : waitArr) {
            if (wait.getMessage() == null) continue;
            g2.drawString(wait.getMessage(), left - (image.getWidth(null) + fm.stringWidth(wait.getMessage())) / 2, top + textPos + 20);
            textPos += fm.getHeight() + 4;
        }
    }

    public String getDescription() {
        return "Wy\u015bwietlanie Cyberboys";
    }

    public String getGroupName() {
        return "OrbadaCyberboyPleaseWait";
    }

    public String getRendererId() {
        return uniqueId;
    }

    public Rectangle getRenderBounds() {
        return this.renderRectangle;
    }
}

