/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.firebird.cm.FindObjectFromEditorAction;
import pl.mpak.orbada.firebird.services.FirebirdDatabaseProvider;
import pl.mpak.orbada.firebird.services.FirebirdDbInfoProvider;
import pl.mpak.orbada.firebird.services.FirebirdDomainsView;
import pl.mpak.orbada.firebird.services.FirebirdExceptionsView;
import pl.mpak.orbada.firebird.services.FirebirdFocusProvider;
import pl.mpak.orbada.firebird.services.FirebirdFunctionsView;
import pl.mpak.orbada.firebird.services.FirebirdGeneralSettingsProvider;
import pl.mpak.orbada.firebird.services.FirebirdPerspectiveProvider;
import pl.mpak.orbada.firebird.services.FirebirdProceduresView;
import pl.mpak.orbada.firebird.services.FirebirdSequencesView;
import pl.mpak.orbada.firebird.services.FirebirdTablesView;
import pl.mpak.orbada.firebird.services.FirebirdTemplatesSettingsProvider;
import pl.mpak.orbada.firebird.services.FirebirdTriggersView;
import pl.mpak.orbada.firebird.services.FirebirdViewsView;
import pl.mpak.orbada.firebird.services.UniversalColumnProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.patt.Resolvers;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaFirebirdPlugin
extends OrbadaPlugin {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    public static final String firebirdDriverType = "Firebird";
    private static TimerQueue refreshQueue;
    public static final ArrayList<Class<? extends IPluginProvider>> classList;
    public static FindObjectFromEditorAction findObjectAction;

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-firebird-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaFirebirdPlugin";
    }

    public String getDescriptiveName() {
        return String.format(this.stringManager.getString("OrbadaFirebirdPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,Firebird";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 2, 22).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-firebird-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        System.setProperty("org.firebirdsql.jdbc.processName", "Orbada Firebird Plugin");
        System.setProperty("org.firebirdsql.jdbc.pid", Resolvers.expand((String)"$(orbada.jvm.pid)"));
        findObjectAction = new FindObjectFromEditorAction();
        this.application.registerDriverType(firebirdDriverType);
        classList.add(FirebirdTablesView.class);
        classList.add(FirebirdTriggersView.class);
        classList.add(FirebirdViewsView.class);
        classList.add(FirebirdProceduresView.class);
        classList.add(FirebirdFunctionsView.class);
        classList.add(FirebirdSequencesView.class);
        classList.add(FirebirdExceptionsView.class);
        classList.add(FirebirdDomainsView.class);
        classList.add(FirebirdTemplatesSettingsProvider.class);
        classList.add(FirebirdPerspectiveProvider.class);
        classList.add(FirebirdFocusProvider.class);
        classList.add(FirebirdDbInfoProvider.class);
        classList.add(FirebirdDatabaseProvider.class);
        classList.add(FirebirdGeneralSettingsProvider.class);
        this.initTemplates();
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            classList.add(UniversalColumnProvider.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTemplates() {
        if (InternalDatabase.get() == null) {
            return;
        }
        Database database = InternalDatabase.get();
        Query query = database.createQuery();
        try {
            ISettings settings;
            query.open("select count( 0 ) cnt from templates where tpl_name like 'firebird-%'");
            if (query.fieldByName("cnt").getInteger() == 0) {
                Template template = new Template(this.application.getOrbadaDatabase());
                template.setName("firebird-procedure");
                template.setDescription("Firebird Procedure Template");
                template.setUsrId("");
                template.setBody("CREATE PROCEDURE $(&name) $(&parameters) $(&returns) AS\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\nBEGIN\n  /* TODO procedure implementation */\n$(&body)\nEND");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("firebird-trigger");
                template.setDescription("Firebird Trigger Template");
                template.setUsrId("");
                template.setBody("CREATE TRIGGER $(&name) FOR $(&tablename)\n$(&type) AS\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\nBEGIN\n  /* TODO trigger implementation */\n$(&body)\nEND");
                template.applyInsert();
            }
            if ((settings = this.application.getSettings(FirebirdTemplatesSettingsProvider.settingsName)).getValue(FirebirdTemplatesSettingsProvider.setProcedure).isNull()) {
                settings.setValue(FirebirdTemplatesSettingsProvider.setProcedure, "firebird-procedure");
            }
            if (settings.getValue(FirebirdTemplatesSettingsProvider.setTrigger).isNull()) {
                settings.setValue(FirebirdTemplatesSettingsProvider.setTrigger, "firebird-trigger");
            }
            settings.store();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    static {
        classList = new ArrayList();
    }
}

