/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird;

public class Sql {
    private static String getFieldTypeCase() {
        return "CASE\n  WHEN F.RDB$FIELD_TYPE = 261 THEN TRIM('BLOB'||COALESCE((SELECT ' SUB_TYPE '||TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$FIELD_SUB_TYPE' AND T.RDB$TYPE = F.RDB$FIELD_SUB_TYPE), ''))\n  WHEN F.RDB$FIELD_TYPE = 12 THEN 'DATE'\n  WHEN F.RDB$FIELD_TYPE = 13 THEN 'TIME'\n  WHEN F.RDB$FIELD_TYPE = 14 THEN TRIM('CHAR('||F.RDB$FIELD_LENGTH||')'||CASE F.RDB$CHARACTER_SET_ID WHEN 0 THEN '' ELSE COALESCE((SELECT ' CHARACTER SET '||C.RDB$CHARACTER_SET_NAME FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID), '') END)\n  WHEN F.RDB$FIELD_TYPE = 15 THEN TRIM('CHAR2('||F.RDB$FIELD_LENGTH||')'||CASE F.RDB$CHARACTER_SET_ID WHEN 0 THEN '' ELSE COALESCE((SELECT ' CHARACTER SET '||C.RDB$CHARACTER_SET_NAME FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID), '') END)\n  WHEN F.RDB$FIELD_TYPE = 35 THEN 'TIMESTAMP'\n  WHEN F.RDB$FIELD_TYPE = 37 THEN TRIM('VARCHAR('||COALESCE(RDB$CHARACTER_LENGTH,RDB$FIELD_LENGTH)||')'||CASE F.RDB$CHARACTER_SET_ID WHEN 0 THEN '' ELSE COALESCE((SELECT ' CHARACTER SET '||C.RDB$CHARACTER_SET_NAME FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID), '') END)\n  WHEN F.RDB$FIELD_TYPE = 38 THEN TRIM('VARCHAR2('||F.RDB$FIELD_LENGTH||')'||CASE F.RDB$CHARACTER_SET_ID WHEN 0 THEN '' ELSE COALESCE((SELECT ' CHARACTER SET '||C.RDB$CHARACTER_SET_NAME FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID), '') END)\n  WHEN F.RDB$FIELD_TYPE IN (7, 8, 16) THEN \n    CASE COALESCE(F.RDB$FIELD_SUB_TYPE, 0)\n      WHEN 0 THEN TRIM(CASE F.RDB$FIELD_TYPE WHEN 7 THEN 'SMALLINT' WHEN 8 THEN 'INTEGER' WHEN 16 THEN CASE F.RDB$FIELD_PRECISION WHEN 0 THEN 'BIGINT' ELSE 'INT64' END END)\n      WHEN 1 THEN 'NUMERIC('||CASE COALESCE(F.RDB$FIELD_PRECISION, 0) WHEN 0 THEN TRIM(CASE F.RDB$FIELD_LENGTH WHEN 8 THEN '18' WHEN 4 THEN '9' WHEN 2 THEN '4' END) ELSE F.RDB$FIELD_PRECISION END||CASE WHEN F.RDB$FIELD_SCALE <> 0 THEN ','||(-F.RDB$FIELD_SCALE) ELSE '' END||')'\n      WHEN 2 THEN 'DECIMAL('||F.RDB$FIELD_PRECISION||CASE WHEN F.RDB$FIELD_SCALE <> 0 THEN ','||(-F.RDB$FIELD_SCALE) ELSE '' END||')'\n    END\n  WHEN F.RDB$FIELD_TYPE = 9 THEN 'QUAD'\n  WHEN F.RDB$FIELD_TYPE = 10 THEN 'FLOAT'\n  WHEN F.RDB$FIELD_TYPE = 11 THEN 'D_FLOAT'\n  WHEN F.RDB$FIELD_TYPE = 27 THEN 'DOUBLE PRECISION'\n  WHEN F.RDB$FIELD_TYPE = 40 THEN TRIM('CSTRING'||CASE F.RDB$CHARACTER_SET_ID WHEN 0 THEN '' ELSE COALESCE((SELECT ' CHARACTER SET '||C.RDB$CHARACTER_SET_NAME FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID), '') END)\n  WHEN F.RDB$FIELD_TYPE = 41 THEN 'CSTRING2'\n  ELSE (SELECT TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$FIELD_TYPE' AND T.RDB$TYPE = F.RDB$FIELD_TYPE)\nEND";
    }

    public static String getTableList(String filter) {
        return String.format("SELECT OWNER_NAME, TABLE_NAME, DESCRIPTION, SYSTEM_FLAG\n  FROM (SELECT TRIM(R.RDB$OWNER_NAME) OWNER_NAME, TRIM(R.RDB$RELATION_NAME) TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION,\n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$RELATIONS R\n         WHERE R.RDB$VIEW_SOURCE IS NULL)\n WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%1$s ORDER BY TABLE_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getColumnList(String filter) {
        return String.format("SELECT TABLE_NAME, FIELD_POSITION, FIELD_NAME, FIELD_TYPE, DISPLAY_TYPE, FIELD_SUB_TYPE, FIELD_LENGTH, FIELD_SCALE, DEFAULT_SOURCE, \n       NULL_FLAG, UPDATE_FLAG, DOMAIN_NAME, DESCRIPTION, CHARACTER_SET_ID, CHARACTER_SET_NAME, VALIDATION_SOURCE, COMPUTED_SOURCE\n  FROM (SELECT TRIM(A.RDB$RELATION_NAME) TABLE_NAME,\n               A.RDB$FIELD_POSITION FIELD_POSITION, F.RDB$FIELD_PRECISION FIELD_PRECISION,\n               TRIM(A.RDB$FIELD_NAME) FIELD_NAME, F.RDB$FIELD_TYPE FIELD_TYPE,\n" + Sql.getFieldTypeCase() + "||\n" + "               COALESCE((SELECT ' ['||D.RDB$LOWER_BOUND||':'||D.RDB$UPPER_BOUND||']' FROM RDB$FIELD_DIMENSIONS D WHERE D.RDB$FIELD_NAME = A.RDB$FIELD_SOURCE), '')\n" + "               DISPLAY_TYPE,\n" + "               F.RDB$FIELD_SUB_TYPE FIELD_SUB_TYPE,\n" + "               F.RDB$FIELD_LENGTH FIELD_LENGTH, F.RDB$FIELD_SCALE FIELD_SCALE, A.RDB$DEFAULT_SOURCE DEFAULT_SOURCE,\n" + "               CASE WHEN A.RDB$NULL_FLAG = 1 THEN 'N' ELSE NULL END NULL_FLAG,\n" + "               CASE WHEN A.RDB$UPDATE_FLAG = 1 THEN 'Y' ELSE NULL END UPDATE_FLAG,\n" + "               TRIM(A.RDB$FIELD_SOURCE) DOMAIN_NAME, A.RDB$DESCRIPTION DESCRIPTION, \n" + "               F.RDB$CHARACTER_SET_ID CHARACTER_SET_ID, \n" + "               (SELECT TRIM(C.RDB$CHARACTER_SET_NAME) FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID) CHARACTER_SET_NAME,\n" + "               F.RDB$VALIDATION_SOURCE VALIDATION_SOURCE,\n" + "               F.RDB$COMPUTED_SOURCE COMPUTED_SOURCE\n" + "          FROM RDB$RELATION_FIELDS A, RDB$FIELDS F\n" + "         WHERE A.RDB$RELATION_NAME = :TABLE_NAME\n" + "           AND A.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME)\n" + "%s" + " ORDER BY FIELD_POSITION", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getIndexList(String filter) {
        return String.format("SELECT TABLE_NAME, INDEX_NAME, INDEX_ID, DESCRIPTION, INDEX_ACTIVE, ORDERING, UNIQUINES, COLUMNS, EXPRESSION_SOURCE\n  FROM (SELECT TRIM(I.RDB$RELATION_NAME) TABLE_NAME, TRIM(I.RDB$INDEX_NAME) INDEX_NAME, \n               I.RDB$INDEX_ID INDEX_ID, I.RDB$DESCRIPTION DESCRIPTION,\n               CASE WHEN COALESCE(I.RDB$INDEX_INACTIVE, 0) = 0 THEN 'Y' ELSE NULL END INDEX_ACTIVE,\n               CASE WHEN I.RDB$INDEX_TYPE <> 0 THEN 'DESC' ELSE 'ASC' END ORDERING,\n               CASE WHEN I.RDB$UNIQUE_FLAG = 1 THEN 'Y' ELSE NULL END UNIQUINES,\n               (SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '') COLUMNS,\n               I.RDB$EXPRESSION_SOURCE EXPRESSION_SOURCE\n          FROM RDB$INDICES I\n         WHERE I.RDB$RELATION_NAME = :TABLE_NAME)\n%s ORDER BY INDEX_ID", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getAllIndexList(String filter) {
        return String.format("SELECT TABLE_NAME, INDEX_NAME, INDEX_ID, DESCRIPTION, INDEX_ACTIVE, ORDERING, UNIQUINES, COLUMNS, SYSTEM_FLAG, EXPRESSION_SOURCE\n  FROM (SELECT TRIM(I.RDB$RELATION_NAME) TABLE_NAME, TRIM(I.RDB$INDEX_NAME) INDEX_NAME, \n               I.RDB$INDEX_ID INDEX_ID, I.RDB$DESCRIPTION DESCRIPTION,\n               CASE WHEN COALESCE(I.RDB$INDEX_INACTIVE, 0) = 0 THEN 'Y' ELSE NULL END INDEX_ACTIVE,\n               CASE WHEN I.RDB$INDEX_TYPE <> 0 THEN 'DESC' ELSE 'ASC' END ORDERING,\n               CASE WHEN I.RDB$UNIQUE_FLAG = 1 THEN 'Y' ELSE NULL END UNIQUINES,\n               (SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = I.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '') COLUMNS,\n               TRIM(CASE I.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG,\n               I.RDB$EXPRESSION_SOURCE EXPRESSION_SOURCE\n          FROM RDB$INDICES I)\n WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%s ORDER BY TABLE_NAME, INDEX_ID", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getConstraintList(String filter) {
        return String.format("SELECT TABLE_NAME, CONSTRAINT_NAME, CONSTRAINT_TYPE, DEFERRABLE, INITIALLY_DEFERRED, INDEX_NAME, COLUMNS, FK_RULE, CHECK_CLAUSE\n  FROM (SELECT TRIM(C.RDB$RELATION_NAME) TABLE_NAME, TRIM(C.RDB$CONSTRAINT_NAME) CONSTRAINT_NAME, C.RDB$CONSTRAINT_TYPE CONSTRAINT_TYPE, \n               C.RDB$DEFERRABLE DEFERRABLE, C.RDB$INITIALLY_DEFERRED INITIALLY_DEFERRED, \n               TRIM(C.RDB$INDEX_NAME) INDEX_NAME,\n               (SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n               COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '') COLUMNS,\n               (select CASE WHEN TRIM(A.RDB$UPDATE_RULE) <> 'RESTRICT' OR TRIM(A.RDB$DELETE_RULE) <> 'RESTRICT' THEN 'ON '||TRIM(B.RDB$RELATION_NAME) ELSE NULL END||\n                       ' ('||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '')||')'||\n                       CASE WHEN TRIM(A.RDB$UPDATE_RULE) = 'RESTRICT' THEN '' ELSE ' UPDATE '||TRIM(A.RDB$UPDATE_RULE) END||\n                       CASE WHEN TRIM(A.RDB$DELETE_RULE) = 'RESTRICT' THEN '' ELSE ' DELETE '||TRIM(A.RDB$DELETE_RULE) END\n                  from RDB$REF_CONSTRAINTS A, RDB$RELATION_CONSTRAINTS B\n                 where A.RDB$CONST_NAME_UQ = B.RDB$CONSTRAINT_NAME\n                   and A.RDB$CONSTRAINT_NAME = C.RDB$CONSTRAINT_NAME) FK_RULE,\n               (select T.RDB$TRIGGER_SOURCE from RDB$TRIGGERS T, RDB$CHECK_CONSTRAINTS CC where T.RDB$TRIGGER_NAME = CC.RDB$TRIGGER_NAME and T.RDB$TRIGGER_TYPE = 1 and CC.RDB$CONSTRAINT_NAME = C.RDB$CONSTRAINT_NAME) CHECK_CLAUSE\n          FROM RDB$RELATION_CONSTRAINTS C\n         WHERE C.RDB$RELATION_NAME = :TABLE_NAME)\n%s ORDER BY CONSTRAINT_NAME", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getPrivilegeList(String filter) {
        return String.format("SELECT TABLE_NAME, USER_NAME, GRANTOR, PRIVILEGE, GRANT_OPTION, TYPE_NAME\n  FROM (SELECT TRIM(P.RDB$RELATION_NAME) TABLE_NAME, TRIM(P.RDB$USER) USER_NAME, TRIM(P.RDB$GRANTOR) GRANTOR,\n               CASE \n                 WHEN RDB$PRIVILEGE = 'S' THEN 'SELECT'\n                 WHEN RDB$PRIVILEGE = 'I' THEN 'INSERT'\n                 WHEN RDB$PRIVILEGE = 'U' THEN 'UPDATE'\n                 WHEN RDB$PRIVILEGE = 'D' THEN 'DELETE'\n                 WHEN RDB$PRIVILEGE = 'R' THEN 'REFERENCE'\n                 WHEN RDB$PRIVILEGE = 'X' THEN 'EXECUTE'\n                 ELSE TRIM(RDB$PRIVILEGE)\n               END PRIVILEGE,\n               CASE WHEN RDB$GRANT_OPTION = 1 THEN 'Y' ELSE NULL END GRANT_OPTION,\n               (SELECT TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$OBJECT_TYPE' AND T.RDB$TYPE = P.RDB$USER_TYPE) TYPE_NAME\n          FROM RDB$USER_PRIVILEGES P\n         WHERE P.RDB$RELATION_NAME = :TABLE_NAME OR P.RDB$USER = :TABLE_NAME)\n%s ORDER BY USER_NAME, PRIVILEGE", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getTableTriggerList(String filter) {
        return String.format("SELECT TABLE_NAME, TRIGGER_NAME, TRIGGER_SEQUENCE, TRIGGER_ACTIVE, FLAGS, RDB$TRIGGER_TYPE\n  FROM (SELECT TRIM(T.RDB$TRIGGER_NAME) TRIGGER_NAME, TRIM(T.RDB$RELATION_NAME) TABLE_NAME,\n               T.RDB$TRIGGER_TYPE,\n               T.RDB$TRIGGER_SEQUENCE TRIGGER_SEQUENCE, \n               CASE WHEN T.RDB$TRIGGER_INACTIVE = 0 THEN 'Y' ELSE NULL END TRIGGER_ACTIVE, \n               T.RDB$FLAGS FLAGS\n          FROM RDB$TRIGGERS T\n         WHERE T.RDB$RELATION_NAME = :TABLE_NAME\n           AND T.RDB$SYSTEM_FLAG <> 3)\n%s ORDER BY TABLE_NAME, TRIGGER_NAME", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getAllTriggerList(String filter) {
        return String.format("SELECT TABLE_NAME, TRIGGER_NAME, TRIGGER_SEQUENCE, TRIGGER_ACTIVE, FLAGS, SYSTEM_FLAG, RDB$TRIGGER_TYPE\n  FROM (SELECT TRIM(T.RDB$TRIGGER_NAME) TRIGGER_NAME, TRIM(T.RDB$RELATION_NAME) TABLE_NAME,\n               T.RDB$TRIGGER_TYPE,\n               T.RDB$TRIGGER_SEQUENCE TRIGGER_SEQUENCE, \n               CASE WHEN T.RDB$TRIGGER_INACTIVE = 0 THEN 'Y' ELSE NULL END TRIGGER_ACTIVE, \n               T.RDB$FLAGS FLAGS,\n               TRIM(CASE T.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$TRIGGERS T\n         WHERE T.RDB$SYSTEM_FLAG <> 3)\n WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%s ORDER BY TRIGGER_SEQUENCE, TRIGGER_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getTriggerSource() {
        return "SELECT TABLE_NAME, TRIGGER_NAME, TRIGGER_SEQUENCE, TRIGGER_SOURCE, TRIGGER_ACTIVE, FLAGS, RDB$TRIGGER_TYPE\n  FROM (SELECT TRIM(T.RDB$TRIGGER_NAME) TRIGGER_NAME, TRIM(T.RDB$RELATION_NAME) TABLE_NAME,\n               T.RDB$TRIGGER_TYPE,\n               T.RDB$TRIGGER_SEQUENCE TRIGGER_SEQUENCE, \n               T.RDB$TRIGGER_SOURCE TRIGGER_SOURCE,\n               CASE WHEN T.RDB$TRIGGER_INACTIVE = 0 THEN 'Y' ELSE NULL END TRIGGER_ACTIVE, \n               T.RDB$FLAGS FLAGS\n          FROM RDB$TRIGGERS T\n         WHERE T.RDB$TRIGGER_NAME = :TRIGGER_NAME\n           AND T.RDB$SYSTEM_FLAG <> 3)";
    }

    public static String getTableReferencesWithList(String filter) {
        return String.format("SELECT CONSTRAINT_NAME, TABLE_NAME, INDEX_NAME, COLUMNS, REF_CONSTRAINT_NAME, REF_TABLE_NAME, REF_INDEX_NAME, REF_COLUMNS\n  FROM (select TRIM(C.RDB$CONSTRAINT_NAME) CONSTRAINT_NAME, TRIM(C.RDB$RELATION_NAME) TABLE_NAME, TRIM(C.RDB$INDEX_NAME) INDEX_NAME,\n               (SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '') COLUMNS,\n               TRIM(R.RDB$CONSTRAINT_NAME) REF_CONSTRAINT_NAME, TRIM(R.RDB$RELATION_NAME) REF_TABLE_NAME, TRIM(R.RDB$INDEX_NAME) REF_INDEX_NAME,\n               (SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '') REF_COLUMNS\n          from RDB$RELATION_CONSTRAINTS C, RDB$REF_CONSTRAINTS I, RDB$RELATION_CONSTRAINTS R\n         WHERE C.RDB$RELATION_NAME = :TABLE_NAME\n           AND C.RDB$CONSTRAINT_TYPE = 'FOREIGN KEY'\n           AND C.RDB$CONSTRAINT_NAME = I.RDB$CONSTRAINT_NAME\n           AND I.RDB$CONST_NAME_UQ = R.RDB$CONSTRAINT_NAME)\n%s ORDER BY CONSTRAINT_NAME", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getTableReferencedFromList(String filter) {
        return String.format("SELECT CONSTRAINT_NAME, TABLE_NAME, INDEX_NAME, COLUMNS, REF_CONSTRAINT_NAME, REF_TABLE_NAME, REF_INDEX_NAME, REF_COLUMNS\n  FROM (select TRIM(C.RDB$CONSTRAINT_NAME) CONSTRAINT_NAME, TRIM(C.RDB$RELATION_NAME) TABLE_NAME, TRIM(C.RDB$INDEX_NAME) INDEX_NAME,\n               (SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = C.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '') COLUMNS,\n               TRIM(R.RDB$CONSTRAINT_NAME) REF_CONSTRAINT_NAME, TRIM(R.RDB$RELATION_NAME) REF_TABLE_NAME, TRIM(R.RDB$INDEX_NAME) REF_INDEX_NAME,\n               (SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 0)||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 1), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 2), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 3), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 4), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 5), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 6), '')||\n                       COALESCE(', '||(SELECT TRIM(S.RDB$FIELD_NAME) FROM RDB$INDEX_SEGMENTS S WHERE S.RDB$INDEX_NAME = R.RDB$INDEX_NAME AND S.RDB$FIELD_POSITION = 7), '') REF_COLUMNS\n          from RDB$RELATION_CONSTRAINTS C, RDB$REF_CONSTRAINTS I, RDB$RELATION_CONSTRAINTS R\n         WHERE C.RDB$RELATION_NAME = :TABLE_NAME\n           AND C.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY'\n           AND C.RDB$CONSTRAINT_NAME = I.RDB$CONST_NAME_UQ\n           AND I.RDB$CONSTRAINT_NAME = R.RDB$CONSTRAINT_NAME)\n%s ORDER BY CONSTRAINT_NAME", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getViewList(String filter) {
        return String.format("SELECT OWNER_NAME, VIEW_NAME, DESCRIPTION, SYSTEM_FLAG\n  FROM (SELECT TRIM(R.RDB$OWNER_NAME) OWNER_NAME, TRIM(R.RDB$RELATION_NAME) VIEW_NAME, R.RDB$DESCRIPTION DESCRIPTION,\n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$RELATIONS R\n         WHERE R.RDB$VIEW_SOURCE IS NOT NULL)\n WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%s ORDER BY VIEW_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getViewUsingList(String filter) {
        return String.format("SELECT VIEW_NAME, OBJECT_NAME, OBJECT_TYPE, SYSTEM_FLAG\n  FROM (SELECT TRIM(V.RDB$VIEW_NAME) VIEW_NAME, TRIM(V.RDB$RELATION_NAME) OBJECT_NAME,\n               CASE WHEN RDB$VIEW_SOURCE IS NULL THEN 'TABLE' ELSE 'VIEW' END OBJECT_TYPE,\n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$VIEW_RELATIONS V, RDB$RELATIONS R\n         WHERE V.RDB$VIEW_NAME = :VIEW_NAME\n           AND V.RDB$RELATION_NAME = R.RDB$RELATION_NAME)\n%s ORDER BY OBJECT_NAME", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getViewSource() {
        return "SELECT RDB$VIEW_SOURCE VIEW_SOURCE\n  FROM RDB$RELATIONS\n WHERE RDB$RELATION_NAME = :VIEW_NAME";
    }

    public static String getViewOnlyColumnList() {
        return "SELECT A.RDB$FIELD_POSITION FIELD_POSITION, TRIM(A.RDB$FIELD_NAME) FIELD_NAME\n  FROM RDB$RELATION_FIELDS A, RDB$FIELDS B\n WHERE A.RDB$RELATION_NAME = :VIEW_NAME\n   AND A.RDB$FIELD_SOURCE = B.RDB$FIELD_NAME\n ORDER BY FIELD_POSITION\n";
    }

    public static String getRelationDescription() {
        return "SELECT RDB$DESCRIPTION DESCRIPTION FROM RDB$RELATIONS WHERE RDB$RELATION_NAME = :RELATION_NAME AND RDB$DESCRIPTION IS NOT NULL";
    }

    public static String getRelationColumnDescriptionList() {
        return "SELECT RDB$DESCRIPTION DESCRIPTION, TRIM(RDB$FIELD_NAME) FIELD_NAME FROM RDB$RELATION_FIELDS WHERE RDB$RELATION_NAME = :RELATION_NAME AND RDB$DESCRIPTION IS NOT NULL";
    }

    public static String getSequenceList(String filter, boolean description) {
        return String.format("SELECT GENERATOR_NAME, GENERATOR_ID" + (description ? ", DESCRIPTION" : "") + ", SYSTEM_FLAG\n" + "  FROM (SELECT TRIM(G.RDB$GENERATOR_NAME) GENERATOR_NAME, G.RDB$GENERATOR_ID GENERATOR_ID" + (description ? ", G.RDB$DESCRIPTION DESCRIPTION" : "") + ",\n" + "               TRIM(CASE G.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n" + "          FROM RDB$GENERATORS G)\n" + " WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n" + "%s" + " ORDER BY GENERATOR_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getExceptionList(String filter) {
        return String.format("SELECT EXCEPTION_NUMBER, EXCEPTION_NAME, EXCEPTION_MESSAGE, DESCRIPTION, SYSTEM_FLAG\n  FROM (SELECT E.RDB$EXCEPTION_NUMBER EXCEPTION_NUMBER, TRIM(E.RDB$EXCEPTION_NAME) EXCEPTION_NAME, \n               E.RDB$MESSAGE EXCEPTION_MESSAGE, E.RDB$DESCRIPTION DESCRIPTION,\n               TRIM(CASE E.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$EXCEPTIONS E)\n WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%s ORDER BY EXCEPTION_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getDomainList(String filter) {
        return String.format("SELECT TRIM(F.RDB$FIELD_NAME) DOMAIN_NAME, F.RDB$FIELD_TYPE FIELD_TYPE, F.RDB$FIELD_SUB_TYPE FIELD_SUB_TYPE, F.RDB$FIELD_LENGTH FIELD_LENGTH, F.RDB$FIELD_SCALE FIELD_SCALE, \n" + Sql.getFieldTypeCase() + "||\n" + "       COALESCE((SELECT ' ['||D.RDB$LOWER_BOUND||':'||D.RDB$UPPER_BOUND||']' FROM RDB$FIELD_DIMENSIONS D WHERE D.RDB$FIELD_NAME = F.RDB$FIELD_NAME), '')\n" + "       DISPLAY_TYPE,\n" + "       F.RDB$VALIDATION_SOURCE VALIDATION_SOURCE, F.RDB$COMPUTED_SOURCE COMPUTED_SOURCE, \n" + "       F.RDB$DEFAULT_SOURCE DEFAULT_SOURCE, F.RDB$DIMENSIONS DIMENSIONS, \n" + "       CASE WHEN F.RDB$NULL_FLAG = 1 THEN 'N' ELSE NULL END NULL_FLAG, \n" + "       F.RDB$CHARACTER_SET_ID CHARACTER_SET_ID, \n" + "       (SELECT TRIM(C.RDB$CHARACTER_SET_NAME) FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID) CHARACTER_SET_NAME,\n" + "       F.RDB$DESCRIPTION DESCRIPTION\n" + "  FROM RDB$FIELDS F\n" + " WHERE (TRIM(CASE F.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n" + "%s" + " ORDER BY DOMAIN_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getFunctionList(String filter) {
        return String.format("SELECT FUNCTION_NAME, LIB_NAME, ENTRYPOINT, DESCRIPTION, SYSTEM_FLAG\n  FROM (SELECT TRIM(F.RDB$FUNCTION_NAME) FUNCTION_NAME, F.RDB$MODULE_NAME LIB_NAME, RDB$ENTRYPOINT ENTRYPOINT, F.RDB$DESCRIPTION DESCRIPTION,\n               TRIM(CASE F.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$FUNCTIONS F)\n WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%1$s ORDER BY FUNCTION_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getFunctionArgumentList(String filter) {
        return String.format("SELECT FUNCTION_NAME, ARGUMENT_POSITION, MECHANISM, FIELD_TYPE, FIELD_SUB_TYPE, FIELD_LENGTH, FIELD_SCALE, DISPLAY_TYPE, CHARACTER_SET_ID, CHARACTER_SET_NAME\n  FROM (SELECT TRIM(F.RDB$FUNCTION_NAME) FUNCTION_NAME, F.RDB$ARGUMENT_POSITION ARGUMENT_POSITION,\n               (SELECT TRIM(T.RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$MECHANISM' AND T.RDB$TYPE = F.RDB$MECHANISM) MECHANISM,\n               F.RDB$FIELD_TYPE FIELD_TYPE, F.RDB$FIELD_SUB_TYPE FIELD_SUB_TYPE, F.RDB$FIELD_LENGTH FIELD_LENGTH, F.RDB$FIELD_SCALE FIELD_SCALE, \n" + Sql.getFieldTypeCase() + "\n" + "               DISPLAY_TYPE,\n" + "               F.RDB$CHARACTER_SET_ID CHARACTER_SET_ID, \n" + "               (SELECT TRIM(C.RDB$CHARACTER_SET_NAME) FROM RDB$CHARACTER_SETS C WHERE C.RDB$CHARACTER_SET_ID = F.RDB$CHARACTER_SET_ID) CHARACTER_SET_NAME\n" + "          FROM RDB$FUNCTION_ARGUMENTS F\n" + "         WHERE F.RDB$FUNCTION_NAME = :FUNCTION_NAME)\n" + "%s" + " ORDER BY ARGUMENT_POSITION", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getFunctionSimpleArgumentList() {
        return "SELECT F.RDB$ARGUMENT_POSITION ARGUMENT_POSITION, F.RDB$FIELD_TYPE FIELD_TYPE, F.RDB$FIELD_SCALE FIELD_SCALE, F.RDB$FIELD_LENGTH FIELD_LENGTH, F.RDB$MECHANISM MECHANISM,\n" + Sql.getFieldTypeCase() + "\n" + "       DISPLAY_TYPE\n" + "  FROM RDB$FUNCTION_ARGUMENTS F\n" + " WHERE F.RDB$FUNCTION_NAME = :FUNCTION_NAME\n" + " ORDER BY RDB$ARGUMENT_POSITION";
    }

    public static String getFunctionSource() {
        return "SELECT TRIM(F.RDB$FUNCTION_NAME) FUNCTION_NAME, F.RDB$MODULE_NAME LIB_NAME, TRIM(RDB$ENTRYPOINT) ENTRYPOINT\n  FROM RDB$FUNCTIONS F\n WHERE RDB$FUNCTION_NAME = :FUNCTION_NAME";
    }

    public static String getProcedureList(String filter) {
        return String.format("SELECT OWNER_NAME, PROCEDURE_ID, PROCEDURE_NAME, DESCRIPTION, SYSTEM_FLAG\n  FROM (SELECT TRIM(P.RDB$OWNER_NAME) OWNER_NAME, P.RDB$PROCEDURE_ID PROCEDURE_ID, TRIM(P.RDB$PROCEDURE_NAME) PROCEDURE_NAME, P.RDB$DESCRIPTION DESCRIPTION,\n               TRIM(CASE P.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$PROCEDURES P)\n WHERE (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%1$s ORDER BY PROCEDURE_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getProcedureArgumentList(String filter) {
        return String.format("SELECT PROCEDURE_NAME, PARAMETER_NUMBER, PARAMETER_NAME, PARAMETER_TYPE, FIELD_TYPE, FIELD_SUB_TYPE, FIELD_LENGTH, FIELD_SCALE, DISPLAY_TYPE, DESCRIPTION, DEFAULT_SOURCE\n  FROM (SELECT TRIM(P.RDB$PROCEDURE_NAME) PROCEDURE_NAME, P.RDB$PARAMETER_NUMBER PARAMETER_NUMBER, TRIM(P.RDB$PARAMETER_NAME) PARAMETER_NAME,\n               CASE WHEN P.RDB$PARAMETER_TYPE = 0 THEN 'IN' WHEN P.RDB$PARAMETER_TYPE = 1 THEN 'OUT' ELSE P.RDB$PARAMETER_TYPE END PARAMETER_TYPE,\n               P.RDB$DESCRIPTION DESCRIPTION,\n               F.RDB$FIELD_TYPE FIELD_TYPE, F.RDB$FIELD_SUB_TYPE FIELD_SUB_TYPE, F.RDB$FIELD_LENGTH FIELD_LENGTH, F.RDB$FIELD_SCALE FIELD_SCALE, \n" + Sql.getFieldTypeCase() + "||\n" + "               COALESCE((SELECT ' ['||D.RDB$LOWER_BOUND||':'||D.RDB$UPPER_BOUND||']' FROM RDB$FIELD_DIMENSIONS D WHERE D.RDB$FIELD_NAME = F.RDB$FIELD_NAME), '')\n" + "               DISPLAY_TYPE, F.RDB$DEFAULT_SOURCE DEFAULT_SOURCE\n" + "          FROM RDB$PROCEDURE_PARAMETERS P, RDB$FIELDS F\n" + "         WHERE P.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME\n" + "           AND P.RDB$PROCEDURE_NAME = :PROCEDURE_NAME)\n" + "%s" + " ORDER BY PARAMETER_TYPE, PARAMETER_NUMBER", filter != null ? " where " + filter + "\n" : "");
    }

    public static String getProcedureSimpleArgumentList() {
        return "SELECT P.RDB$PARAMETER_NUMBER PARAMETER_NUMBER, TRIM(P.RDB$PARAMETER_NAME) PARAMETER_NAME, F.RDB$FIELD_LENGTH FIELD_LENGTH, F.RDB$DEFAULT_SOURCE DEFAULT_SOURCE,\n       F.RDB$FIELD_SCALE FIELD_SCALE, F.RDB$FIELD_TYPE FIELD_TYPE, F.RDB$FIELD_SUB_TYPE FIELD_SUB_TYPE,\n" + Sql.getFieldTypeCase() + "||\n" + "       COALESCE((SELECT ' ['||D.RDB$LOWER_BOUND||':'||D.RDB$UPPER_BOUND||']' FROM RDB$FIELD_DIMENSIONS D WHERE D.RDB$FIELD_NAME = F.RDB$FIELD_NAME), '')\n" + "       DISPLAY_TYPE, P.RDB$DESCRIPTION DESCRIPTION\n" + "  FROM RDB$PROCEDURE_PARAMETERS P, RDB$FIELDS F\n" + " WHERE P.RDB$PROCEDURE_NAME = :PROCEDURE_NAME\n" + "   AND P.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME\n" + "   AND P.RDB$PARAMETER_TYPE = :PARAMETER_TYPE\n" + " ORDER BY PARAMETER_NUMBER";
    }

    public static String getProcedureSource() {
        return "SELECT RDB$PROCEDURE_SOURCE PROCEDURE_SOURCE\n  FROM RDB$PROCEDURES\n WHERE RDB$PROCEDURE_NAME = :PROCEDURE_NAME";
    }

    public static String getAllObjectList() {
        return "SELECT OWNER_NAME, OBJECT_NAME, OBJECT_TYPE, REF_TABLE_NAME, DESCRIPTION, SYSTEM_FLAG\n  FROM (SELECT TRIM(R.RDB$OWNER_NAME) OWNER_NAME, TRIM(R.RDB$RELATION_NAME) OBJECT_NAME, CAST('TABLE' AS VARCHAR(50)) OBJECT_TYPE, CAST(NULL AS VARCHAR(100)) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$RELATIONS R\n         WHERE R.RDB$VIEW_SOURCE IS NULL\n        UNION ALL\n        SELECT TRIM(R.RDB$OWNER_NAME) OWNER_NAME, TRIM(R.RDB$RELATION_NAME) OBJECT_NAME, CAST('VIEW' AS VARCHAR(50)) OBJECT_TYPE, CAST(NULL AS VARCHAR(100)) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$RELATIONS R\n         WHERE R.RDB$VIEW_SOURCE IS NOT NULL\n        UNION ALL\n        SELECT CAST(NULL AS VARCHAR(100)) OWNER_NAME, TRIM(R.RDB$INDEX_NAME) OBJECT_NAME, CAST('INDEX' AS VARCHAR(50)) OBJECT_TYPE, TRIM(R.RDB$RELATION_NAME) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$INDICES R\n        UNION ALL\n        SELECT CAST(NULL AS VARCHAR(100)) OWNER_NAME, TRIM(R.RDB$TRIGGER_NAME) OBJECT_NAME, CAST('TRIGGER' AS VARCHAR(50)) OBJECT_TYPE, TRIM(R.RDB$RELATION_NAME) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$TRIGGERS R\n         WHERE R.RDB$SYSTEM_FLAG <> 3\n        UNION ALL\n        SELECT CAST(NULL AS VARCHAR(100)) OWNER_NAME, TRIM(R.RDB$GENERATOR_NAME) OBJECT_NAME, CAST('GENERATOR' AS VARCHAR(50)) OBJECT_TYPE, CAST(NULL AS VARCHAR(100)) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$GENERATORS R\n        UNION ALL\n        SELECT CAST(NULL AS VARCHAR(100)) OWNER_NAME, TRIM(R.RDB$EXCEPTION_NAME) OBJECT_NAME, CAST('EXCEPTION' AS VARCHAR(50)) OBJECT_TYPE, CAST(NULL AS VARCHAR(100)) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$EXCEPTIONS R\n        UNION ALL\n        SELECT CAST(NULL AS VARCHAR(100)) OWNER_NAME, TRIM(R.RDB$FIELD_NAME) OBJECT_NAME, CAST('DOMAIN' AS VARCHAR(50)) OBJECT_TYPE, CAST(NULL AS VARCHAR(100)) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$FIELDS R\n        UNION ALL\n        SELECT TRIM(R.RDB$OWNER_NAME) OWNER_NAME, TRIM(R.RDB$PROCEDURE_NAME) OBJECT_NAME, CAST('PROCEDURE' AS VARCHAR(50)) OBJECT_TYPE, CAST(NULL AS VARCHAR(100)) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$PROCEDURES R\n        UNION ALL\n        SELECT CAST(NULL AS VARCHAR(100)) OWNER_NAME, TRIM(R.RDB$FUNCTION_NAME) OBJECT_NAME, CAST('FUNCTION' AS VARCHAR(50)) OBJECT_TYPE, CAST(NULL AS VARCHAR(100)) REF_TABLE_NAME, R.RDB$DESCRIPTION DESCRIPTION, \n               TRIM(CASE R.RDB$SYSTEM_FLAG WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' WHEN 2 THEN 'QLI' WHEN 3 THEN 'CHECK_CONSTRAINT' WHEN 4 THEN 'REFERENTIAL_CONSTRAINT' WHEN 5 THEN 'VIEW_CHECK' ELSE 'USER' END) SYSTEM_FLAG\n          FROM RDB$FUNCTIONS R)";
    }

    public static String getObjectTypes() {
        return Sql.getObjectTypes(null);
    }

    public static String getObjectTypes(String filter) {
        return String.format(Sql.getAllObjectList() + " where object_name = :OBJECT_NAME\n" + "   and (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n" + "%s" + " order by SYSTEM_FLAG DESC, OBJECT_TYPE, OBJECT_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getObjectsSearch(String filter) {
        return Sql.getAllObjectList() + String.format(" where (object_name = :OBJECT_NAME or COALESCE(:OBJECT_NAME, CAST('' AS VARCHAR(100))) = '' or object_name like '%%'||upper(COALESCE(:OBJECT_NAME, CAST('' AS VARCHAR(100))))||'%%')\n   and (SYSTEM_FLAG = :SYSTEM_FLAG OR COALESCE(:SYSTEM_FLAG, CAST('' AS VARCHAR(10))) = '')\n%s order by SYSTEM_FLAG DESC, OBJECT_TYPE, OBJECT_NAME", filter != null ? "   and " + filter + "\n" : "");
    }

    public static String getObjectNames() {
        return Sql.getAllObjectList() + " where object_type = :OBJECT_TYPE\n" + " order by SYSTEM_FLAG DESC, OBJECT_TYPE, OBJECT_NAME";
    }

    public static String getTabledNameList() {
        return "SELECT DISTINCT TRIM(RDB$RELATION_NAME) TABLE_NAME\n  FROM RDB$RELATIONS\n WHERE CASE WHEN RDB$SYSTEM_FLAG IS NULL THEN 0 ELSE RDB$SYSTEM_FLAG END = 0\n ORDER BY 1";
    }

    public static String getUserNameList() {
        return "SELECT DISTINCT TRIM(RDB$USER) USER_NAME\n  FROM RDB$USER_PRIVILEGES\n WHERE RDB$USER_TYPE IN (8, 13)\nUNION\nSELECT 'PUBLIC' USER_NAME FROM RDB$DATABASE\nUNION\nSELECT 'SYSDBA' USER_NAME FROM RDB$DATABASE\n ORDER BY 1";
    }

    public static String getViewNameList() {
        return "SELECT DISTINCT TRIM(RDB$RELATION_NAME) NAME\n  FROM RDB$RELATIONS\n WHERE CASE WHEN RDB$SYSTEM_FLAG IS NULL THEN 0 ELSE RDB$SYSTEM_FLAG END = 0\n   AND RDB$VIEW_SOURCE IS NOT NULL\n ORDER BY 1";
    }

    public static String getProcedureNameList() {
        return "SELECT DISTINCT TRIM(RDB$PROCEDURE_NAME) OBJECT_NAME\n  FROM RDB$PROCEDURES\n WHERE CASE WHEN RDB$SYSTEM_FLAG IS NULL THEN 0 ELSE RDB$SYSTEM_FLAG END = 0\n ORDER BY 1";
    }

    public static String getTriggerNameList() {
        return "SELECT DISTINCT TRIM(RDB$TRIGGER_NAME) OBJECT_NAME\n  FROM RDB$TRIGGERS\n WHERE CASE WHEN RDB$SYSTEM_FLAG IS NULL THEN 0 ELSE RDB$SYSTEM_FLAG END = 0\n ORDER BY 1";
    }
}

