/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.cm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.freezing.FreezeFactory;
import pl.mpak.orbada.firebird.gui.freezing.FreezeViewService;
import pl.mpak.orbada.gui.PerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FindObjectFromEditorAction
extends Action {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private Database database;
    private SyntaxEditor syntaxEditor;

    public FindObjectFromEditorAction() {
        this.setText(this.stringManager.getString("FindObjectFromEditorAction-text"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/find_editor.gif"));
        this.setTooltip(this.stringManager.getString("FindObjectFromEditorAction-hint"));
        this.setShortCut(118, 3);
        this.setActionCommandKey("FindObjectFromEditorAction");
        this.addActionListener(this.createActionListener());
    }

    public SyntaxEditor getSyntaxEditor() {
        return this.syntaxEditor;
    }

    public void setSyntaxEditor(SyntaxEditor syntaxEditor) {
        this.syntaxEditor = syntaxEditor;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    private boolean resolveObject(String type, String object) {
        if ("TABLE".equalsIgnoreCase(type) || "VIEW".equalsIgnoreCase(type) || "PROCEDURE".equalsIgnoreCase(type) || "FUNCTION".equalsIgnoreCase(type)) {
            FreezeViewService service = new FreezeFactory().createInstance(type, null, object);
            PerspectiveAccesibilities accessibilities = Application.get().getMainFrame().getActivePerspective().getPerspectiveAccesibilities();
            if (service != null && accessibilities != null) {
                accessibilities.createView((ViewProvider)service);
            }
            return true;
        }
        return false;
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                block9: {
                    try {
                        String[] words = FindObjectFromEditorAction.this.syntaxEditor.getWordsAt(FindObjectFromEditorAction.this.syntaxEditor.getCaretPosition());
                        String object = null;
                        if (words == null || words.length <= 0) break block9;
                        if (words.length >= 1) {
                            object = SQLUtil.normalizeSqlName((String)words[0]);
                        }
                        boolean found = false;
                        Query query = FindObjectFromEditorAction.this.database.createQuery();
                        try {
                            query.setSqlText(Sql.getObjectTypes());
                            query.paramByName("object_name").setString(object);
                            query.open();
                            if (!query.eof()) {
                                found = FindObjectFromEditorAction.this.resolveObject(query.fieldByName("object_type").getString(), object);
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

