/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.firebird.gui.wizards.CreateDomainWizard;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class DomainsPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmComment;
    private Action cmCreateDomain;
    private Action cmDropDomain;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuDropSequence;
    private QueryTableStatusBar statusBar;
    private ViewTable tableDomains;
    private JToolBar toolBar;
    private ToolButton toolButton2;
    private ToolButton toolButton3;

    public DomainsPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = "USER";
        this.tableDomains.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("DOMAIN_NAME", this.stringManager.getString("DomainsPanelView-domain-name"), 190, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("DISPLAY_TYPE", this.stringManager.getString("DomainsPanelView-type"), 150));
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("VALIDATION_SOURCE", this.stringManager.getString("DomainsPanelView-constraint"), 250));
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("COMPUTED_SOURCE", this.stringManager.getString("DomainsPanelView-computed-source"), 250));
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("DEFAULT_SOURCE", this.stringManager.getString("DomainsPanelView-default-value"), 150));
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("NULL_FLAG", this.stringManager.getString("DomainsPanelView-null-short-q"), 50));
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("CHARACTER_SET_NAME", this.stringManager.getString("DomainsPanelView-char-coding"), 100));
            this.tableDomains.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 100));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("F.RDB$FIELD_NAME", this.stringManager.getString("DomainsPanelView-domain-name"), (String[])null));
            def.add(new SqlFilterDefComponent("(SELECT TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$FIELD_TYPE' AND T.RDB$TYPE = F.RDB$FIELD_TYPE)", this.stringManager.getString("DomainsPanelView-type"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-domains-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableDomains, (JButton)this.buttonActions, this.menuActions, "firebird-domains-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase("USER")) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
                this.buttonSelectSchema.setSelected(true);
            } else {
                this.buttonSelectSchema.setSelected(false);
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DomainsPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableDomains.getQuery().isActive() && this.tableDomains.getSelectedRow() >= 0) {
                this.tableDomains.getQuery().getRecord(this.tableDomains.getSelectedRow());
                objectName = this.tableDomains.getQuery().fieldByName("DOMAIN_NAME").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableDomains.getSelectedColumn();
            int index = Math.max(0, this.tableDomains.getSelectedRow());
            this.tableDomains.getQuery().close();
            this.tableDomains.getQuery().setSqlText(Sql.getDomainList(this.filter.getSqlText()));
            this.tableDomains.getQuery().paramByName("SYSTEM_FLAG").setString(this.currentSchemaName);
            this.tableDomains.getQuery().open();
            if (objectName != null && this.tableDomains.getQuery().locate("DOMAIN_NAME", new Variant(objectName))) {
                this.tableDomains.changeSelection(this.tableDomains.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableDomains.getQuery().isEmpty()) {
                this.tableDomains.changeSelection(Math.min(index, this.tableDomains.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableDomains.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropSequence = new JMenuItem();
        this.cmDropDomain = new Action();
        this.cmComment = new Action();
        this.cmCreateDomain = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableDomains = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton2 = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainsPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainsPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainsPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCreateDomain);
        this.menuActions.add(this.jMenuItem1);
        this.menuActions.add(this.jSeparator2);
        this.menuDropSequence.setAction((javax.swing.Action)this.cmDropDomain);
        this.menuActions.add(this.menuDropSequence);
        this.cmDropDomain.setActionCommandKey("cmDropDomain");
        this.cmDropDomain.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropDomain.setText(this.stringManager.getString("DomainsPanelView-cmDropDomain-text"));
        this.cmDropDomain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainsPanelView.this.cmDropDomainActionPerformed(evt);
            }
        });
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainsPanelView.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmCreateDomain.setActionCommandKey("cmCreateDomain");
        this.cmCreateDomain.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/domain.gif"));
        this.cmCreateDomain.setText(this.stringManager.getString("DomainsPanelView-cmCreateDomain-text"));
        this.cmCreateDomain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainsPanelView.this.cmCreateDomainActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                DomainsPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableDomains);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableDomains);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolButton2.setAction((javax.swing.Action)this.cmComment);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton2);
        this.toolButton3.setAction((javax.swing.Action)this.cmCreateDomain);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton3);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableDomains.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        if (StringUtil.equalsIgnoreCase((String)this.currentSchemaName, (String)"USER")) {
            this.setCurrentSchemaName("SYSTEM");
        } else {
            this.setCurrentSchemaName("USER");
        }
        this.refresh();
    }

    private void cmDropDomainActionPerformed(ActionEvent evt) {
        if (this.tableDomains.getSelectedRow() >= 0) {
            try {
                this.tableDomains.getQuery().getRecord(this.tableDomains.getSelectedRow());
                String domainName = this.tableDomains.getQuery().fieldByName("DOMAIN_NAME").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("DomainsPanelView-drop-domain-q"), domainName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop domain " + SQLUtil.createSqlName((String)domainName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableDomains.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableDomains.getQuery().getRecord(this.tableDomains.getSelectionModel().getLeadSelectionIndex());
                String sequenceName = this.tableDomains.getQuery().fieldByName("DOMAIN_NAME").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), sequenceName, "RDB$FIELDS"), (boolean)true) != null) {
                    this.refresh(sequenceName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateDomainActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateDomainWizard(this.getDatabase()), (boolean)true);
        if (result != null) {
            this.refresh((String)result.getResultMap().get("object_name"));
        }
    }
}

