/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.exceptions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.wizards.AlterExceptionWizard;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.firebird.gui.wizards.CreateExceptionWizard;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class ExceptionsPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmAlterException;
    private Action cmComment;
    private Action cmCreateException;
    private Action cmDropException;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuDropSequence;
    private QueryTableStatusBar statusBar;
    private ViewTable tableExceptions;
    private JToolBar toolBar;
    private ToolButton toolButton2;
    private ToolButton toolButton3;

    public ExceptionsPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = "USER";
        this.tableExceptions.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableExceptions.addColumn((TableColumn)new QueryTableColumn("EXCEPTION_NUMBER", this.stringManager.getString("ExceptionsPanelView-no"), 70));
            this.tableExceptions.addColumn((TableColumn)new QueryTableColumn("EXCEPTION_NAME", this.stringManager.getString("ExceptionsPanelView-exception-name"), 190, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableExceptions.addColumn((TableColumn)new QueryTableColumn("EXCEPTION_MESSAGE", this.stringManager.getString("ExceptionsPanelView-message"), 350));
            this.tableExceptions.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 250));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("EXCEPTION_NAME", this.stringManager.getString("ExceptionsPanelView-exception-name"), (String[])null));
            def.add(new SqlFilterDefComponent("EXCEPTION_MESSAGE", this.stringManager.getString("ExceptionsPanelView-message"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-exceptions-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableExceptions, (JButton)this.buttonActions, this.menuActions, "firebird-exceptions-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase("USER")) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
                this.buttonSelectSchema.setSelected(true);
            } else {
                this.buttonSelectSchema.setSelected(false);
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ExceptionsPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableExceptions.getQuery().isActive() && this.tableExceptions.getSelectedRow() >= 0) {
                this.tableExceptions.getQuery().getRecord(this.tableExceptions.getSelectedRow());
                objectName = this.tableExceptions.getQuery().fieldByName("EXCEPTION_NAME").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableExceptions.getSelectedColumn();
            int index = Math.max(0, this.tableExceptions.getSelectedRow());
            this.tableExceptions.getQuery().close();
            this.tableExceptions.getQuery().setSqlText(Sql.getExceptionList(this.filter.getSqlText()));
            this.tableExceptions.getQuery().paramByName("SYSTEM_FLAG").setString(this.currentSchemaName);
            this.tableExceptions.getQuery().open();
            if (objectName != null && this.tableExceptions.getQuery().locate("EXCEPTION_NAME", new Variant(objectName))) {
                this.tableExceptions.changeSelection(this.tableExceptions.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableExceptions.getQuery().isEmpty()) {
                this.tableExceptions.changeSelection(Math.min(index, this.tableExceptions.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableExceptions.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropSequence = new JMenuItem();
        this.cmDropException = new Action();
        this.cmComment = new Action();
        this.cmCreateException = new Action();
        this.cmAlterException = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableExceptions = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton2 = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCreateException);
        this.menuActions.add(this.jMenuItem1);
        this.jMenuItem2.setAction((javax.swing.Action)this.cmAlterException);
        this.menuActions.add(this.jMenuItem2);
        this.menuActions.add(this.jSeparator2);
        this.menuDropSequence.setAction((javax.swing.Action)this.cmDropException);
        this.menuActions.add(this.menuDropSequence);
        this.cmDropException.setActionCommandKey("cmDropException");
        this.cmDropException.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropException.setText(this.stringManager.getString("ExceptionsPanelView-cmDropException-text"));
        this.cmDropException.setTooltip(this.stringManager.getString("ExceptionsPanelView-cmDropException-hint"));
        this.cmDropException.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanelView.this.cmDropExceptionActionPerformed(evt);
            }
        });
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanelView.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmCreateException.setActionCommandKey("cmCreateException");
        this.cmCreateException.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/exception.gif"));
        this.cmCreateException.setText(this.stringManager.getString("ExceptionsPanelView-cmCreateException-text"));
        this.cmCreateException.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanelView.this.cmCreateExceptionActionPerformed(evt);
            }
        });
        this.cmAlterException.setActionCommandKey("cmAlterException");
        this.cmAlterException.setText(this.stringManager.getString("ExceptionsPanelView-cmAlterException-text"));
        this.cmAlterException.setTooltip(this.stringManager.getString("ExceptionsPanelView-cmAlterException-hint"));
        this.cmAlterException.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanelView.this.cmAlterExceptionActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ExceptionsPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableExceptions);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableExceptions);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolButton2.setAction((javax.swing.Action)this.cmComment);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton2);
        this.toolButton3.setAction((javax.swing.Action)this.cmCreateException);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton3);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableExceptions.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        if (StringUtil.equalsIgnoreCase((String)this.currentSchemaName, (String)"USER")) {
            this.setCurrentSchemaName("SYSTEM");
        } else {
            this.setCurrentSchemaName("USER");
        }
        this.refresh();
    }

    private void cmDropExceptionActionPerformed(ActionEvent evt) {
        if (this.tableExceptions.getSelectedRow() >= 0) {
            try {
                this.tableExceptions.getQuery().getRecord(this.tableExceptions.getSelectedRow());
                String sequenceName = this.tableExceptions.getQuery().fieldByName("EXCEPTION_NAME").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("ExceptionsPanelView-dropexception-q"), sequenceName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop exception " + SQLUtil.createSqlName((String)sequenceName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableExceptions.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableExceptions.getQuery().getRecord(this.tableExceptions.getSelectionModel().getLeadSelectionIndex());
                String sequenceName = this.tableExceptions.getQuery().fieldByName("EXCEPTION_NAME").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), sequenceName, "RDB$EXCEPTIONS"), (boolean)true) != null) {
                    this.refresh(sequenceName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateExceptionActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateExceptionWizard(this.getDatabase()), (boolean)true);
        if (result != null) {
            this.refresh((String)result.getResultMap().get("object_name"));
        }
    }

    private void cmAlterExceptionActionPerformed(ActionEvent evt) {
        if (this.tableExceptions.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableExceptions.getQuery().getRecord(this.tableExceptions.getSelectionModel().getLeadSelectionIndex());
                String exceptionName = this.tableExceptions.getQuery().fieldByName("EXCEPTION_NAME").getString();
                String message = this.tableExceptions.getQuery().fieldByName("EXCEPTION_MESSAGE").getString();
                SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterExceptionWizard(this.getDatabase(), exceptionName, message), (boolean)true);
                if (result != null) {
                    this.refresh((String)result.getResultMap().get("object_name"));
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

