/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.freezing;

import java.util.HashMap;
import pl.mpak.orbada.firebird.gui.freezing.FreezeViewService;
import pl.mpak.orbada.firebird.gui.freezing.FunctionFreezeViewService;
import pl.mpak.orbada.firebird.gui.freezing.ProcedureFreezeViewService;
import pl.mpak.orbada.firebird.gui.freezing.TableFreezeViewService;
import pl.mpak.orbada.firebird.gui.freezing.TriggerFreezeViewService;
import pl.mpak.orbada.firebird.gui.freezing.ViewFreezeViewService;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.util.ExceptionUtil;

public class FreezeFactory {
    private HashMap<String, Class<? extends FreezeViewService>> freezeMap = new HashMap();
    private IViewAccesibilities accesibilities;

    public FreezeFactory() {
        this.freezeMap.put("PROCEDURE", ProcedureFreezeViewService.class);
        this.freezeMap.put("TABLE", TableFreezeViewService.class);
        this.freezeMap.put("VIEW", ViewFreezeViewService.class);
        this.freezeMap.put("TRIGGER", TriggerFreezeViewService.class);
        this.freezeMap.put("FUNCTION", FunctionFreezeViewService.class);
    }

    public FreezeFactory(IViewAccesibilities accesibilities) {
        this();
        this.accesibilities = accesibilities;
    }

    public boolean canCreate(String objectType) {
        return this.freezeMap.get(objectType) != null;
    }

    public FreezeViewService createInstance(String objectType, String schemaName, String objectName) {
        Class<? extends FreezeViewService> clazz = this.freezeMap.get(objectType);
        if (clazz != null) {
            try {
                FreezeViewService service = clazz.newInstance();
                service.setSchemaName(schemaName);
                service.setObjectName(objectName);
                return service;
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        return null;
    }
}

