/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.functions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.util.SourceCreator;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FunctionSourcePanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentObjectName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private OrbadaSyntaxTextArea syntaxSource;
    private JToolBar toolBarContent;

    public FunctionSourcePanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void setEditorText(final String objectName, final String text) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FunctionSourcePanel.this.syntaxSource.setDatabaseObject(null, "FUNCTION", objectName, text);
                FunctionSourcePanel.this.syntaxSource.getEditorArea().setCaretPosition(0);
            }
        });
    }

    private void init() {
        this.syntaxSource.getStatusBar().addPanel("ddl-status").setText(" ");
        this.syntaxSource.setDatabase(this.getDatabase());
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.syntaxSource.getEditorArea(), (JButton)this.buttonActions, this.menuActions, "firebird-function-source-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("source");
    }

    public void gotoPoint(int line, int column) {
        int offset = this.syntaxSource.getEditorArea().getLineStartOffset(line - 1) + column - 1;
        this.syntaxSource.getEditorArea().setCaretPosition(offset);
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FunctionSourcePanel.this.refresh();
            }
        });
    }

    public void refresh() {
        this.requestRefresh = false;
        new SourceCreator(this.getDatabase(), (SyntaxTextArea)this.syntaxSource).getSource(null, "FUNCTION", this.currentObjectName);
        this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(" " + this.currentObjectName);
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
                this.setEditorText(null, "");
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.syntaxSource.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.syntaxSource = new OrbadaSyntaxTextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("FunctionSourcePanel-cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionSourcePanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                FunctionSourcePanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.toolBarContent.add(this.jSeparator1);
        this.toolBarContent.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarContent);
        this.add((Component)this.jPanel1, "North");
        this.add((Component)this.syntaxSource, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

