/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.procedures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ProcedureArgumentsPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmComment;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JMenuItem menuComment;
    private QueryTableStatusBar statusBarColumns;
    private ViewTable tableArguments;
    private JToolBar toolBarColumns;

    public ProcedureArgumentsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableArguments.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("PARAMETER_NUMBER", this.stringManager.getString("ProcedureArgumentsPanel-no"), 30));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("PARAMETER_NAME", this.stringManager.getString("ProcedureArgumentsPanel-parameter-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("PARAMETER_TYPE", "IN/OUT", 60));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("DISPLAY_TYPE", this.stringManager.getString("ProcedureArgumentsPanel-column-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("DEFAULT_SOURCE", this.stringManager.getString("ProcedureArgumentsPanel-default-value"), 200));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 300));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("PARAMETER_NAME", this.stringManager.getString("ProcedureArgumentsPanel-parameter-name"), (String[])null));
            def.add(new SqlFilterDefComponent("DISPLAY_TYPE", this.stringManager.getString("ProcedureArgumentsPanel-column-type"), new String[]{"", "'VARYING%'", "'TEXT%'", "'SHORT%'", "'LONG%'", "'TIMESTAMP%'"}));
            def.add(new SqlFilterDefComponent("PARAMETER_TYPE", "IN/OUT", new String[]{"", "'IN'", "'OUT'"}));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-procedures-columns-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableArguments, (JButton)this.buttonActions, this.menuActions, "firebird-procedure-arguments-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("ProcedureArgumentsPanel-arguments");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProcedureArgumentsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String paramName = null;
            this.requestRefresh = false;
            if (this.tableArguments.getQuery().isActive() && this.tableArguments.getSelectedRow() >= 0) {
                this.tableArguments.getQuery().getRecord(this.tableArguments.getSelectedRow());
                paramName = this.tableArguments.getQuery().fieldByName("PARAMETER_NAME").getString();
            }
            this.tableArguments.getQuery().close();
            this.tableArguments.getQuery().setSqlText(Sql.getProcedureArgumentList(this.filter.getSqlText()));
            this.tableArguments.getQuery().paramByName("PROCEDURE_NAME").setString(this.currentTableName);
            this.tableArguments.getQuery().open();
            if (!this.tableArguments.getQuery().isEmpty()) {
                if (paramName != null && this.tableArguments.getQuery().locate("PARAMETER_NAME", new Variant(paramName))) {
                    this.tableArguments.changeSelection(this.tableArguments.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableArguments.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableArguments.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuComment = new JMenuItem();
        this.cmComment = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableArguments = new ViewTable();
        this.statusBarColumns = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureArgumentsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureArgumentsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuComment.setAction((javax.swing.Action)this.cmComment);
        this.menuActions.add(this.menuComment);
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureArgumentsPanel.this.cmCommentActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ProcedureArgumentsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableArguments);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarColumns.setShowFieldType(false);
        this.statusBarColumns.setShowOpenTime(false);
        this.statusBarColumns.setTable((QueryTable)this.tableArguments);
        this.add((Component)this.statusBarColumns, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableArguments.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableArguments.getQuery().getRecord(this.tableArguments.getSelectionModel().getLeadSelectionIndex());
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), this.tableArguments.getQuery().fieldByName("PROCEDURE_NAME").getString(), this.tableArguments.getQuery().fieldByName("PARAMETER_NAME").getString(), "RDB$PROCEDURE_PARAMETERS"), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

