/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.procedures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.freezing.ProcedureFreezeViewService;
import pl.mpak.orbada.firebird.gui.procedures.ProcedureSourcePanel;
import pl.mpak.orbada.firebird.gui.procedures.ProcedureTabbedPane;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.firebird.gui.wizards.CreateProcedureWizard;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class ProceduresPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmComment;
    private Action cmCreateProcedure;
    private Action cmDropProcedure;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuComment;
    private JMenuItem menuCreateProcedure;
    private JMenuItem menuDropTrigger;
    private JPanel panelTables;
    private JSplitPane splitTables;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableProcedures;
    private JToolBar toolBarTables;

    public ProceduresPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                ProceduresPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaFirebirdPlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new ProcedureTabbedPane(this.accesibilities);
        this.splitTables.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-procedures-panel");
        this.splitTables.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTables.getDividerLocation())).intValue());
        this.currentSchemaName = "USER";
        this.tableProcedures.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                ProcedureSourcePanel panel = (ProcedureSourcePanel)ProceduresPanelView.this.tabbedPane.getComponent(ProcedureSourcePanel.class);
                if (panel != null && this.lastIndex != ProceduresPanelView.this.tableProcedures.getSelectedRow() && !panel.canClose()) {
                    ProceduresPanelView.this.tableProcedures.changeSelection(this.lastIndex, ProceduresPanelView.this.tableProcedures.getSelectedColumn());
                    return;
                }
                this.lastIndex = ProceduresPanelView.this.tableProcedures.getSelectedRow();
                ProceduresPanelView.this.timer.restart();
            }
        });
        this.tableProcedures.getQuery().setDatabase(this.getDatabase());
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("PROCEDURE_NAME", this.stringManager.getString("ProceduresPanelView-procedure-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 250));
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("OWNER_NAME", this.stringManager.getString("ProceduresPanelView-owner"), 120));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("PROCEDURE_NAME", this.stringManager.getString("ProceduresPanelView-procedure-name"), (String[])null));
        def.add(new SqlFilterDefComponent("OWNER_NAME", this.stringManager.getString("ProceduresPanelView-owner"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-procedures-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableProcedures, (JButton)this.buttonActions, this.menuActions, "firebird-procedures-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProceduresPanelView.this.tableProcedures.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase("USER")) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
                this.buttonSelectSchema.setSelected(true);
            } else {
                this.buttonSelectSchema.setSelected(false);
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String procedureName = "";
        int rowIndex = this.tableProcedures.getSelectedRow();
        if (rowIndex >= 0 && this.tableProcedures.getQuery().isActive()) {
            try {
                this.tableProcedures.getQuery().getRecord(rowIndex);
                procedureName = this.tableProcedures.getQuery().fieldByName("PROCEDURE_NAME").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, procedureName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProceduresPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String procedureName = null;
            if (this.tableProcedures.getQuery().isActive() && this.tableProcedures.getSelectedRow() >= 0) {
                this.tableProcedures.getQuery().getRecord(this.tableProcedures.getSelectedRow());
                procedureName = this.tableProcedures.getQuery().fieldByName("PROCEDURE_NAME").getString();
            }
            this.refresh(procedureName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        try {
            int column = this.tableProcedures.getSelectedColumn();
            int index = Math.max(0, this.tableProcedures.getSelectedRow());
            this.tableProcedures.getQuery().close();
            this.tableProcedures.getQuery().setSqlText(Sql.getProcedureList(this.filter.getSqlText()));
            this.tableProcedures.getQuery().paramByName("SYSTEM_FLAG").setString(this.currentSchemaName);
            this.tableProcedures.getQuery().open();
            if (objectName != null && this.tableProcedures.getQuery().locate("PROCEDURE_NAME", new Variant(objectName))) {
                this.tableProcedures.changeSelection(this.tableProcedures.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableProcedures.getQuery().isEmpty()) {
                this.tableProcedures.changeSelection(Math.min(index, this.tableProcedures.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.splitTables.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableProcedures.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateProcedure = new JMenuItem();
        this.menuComment = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropTrigger = new JMenuItem();
        this.cmDropProcedure = new Action();
        this.cmFreezeObject = new Action();
        this.cmComment = new Action();
        this.cmCreateProcedure = new Action();
        this.splitTables = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableProcedures = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuCreateProcedure.setAction((javax.swing.Action)this.cmCreateProcedure);
        this.menuActions.add(this.menuCreateProcedure);
        this.menuComment.setAction((javax.swing.Action)this.cmComment);
        this.menuActions.add(this.menuComment);
        this.menuActions.add(this.jSeparator2);
        this.menuDropTrigger.setAction((javax.swing.Action)this.cmDropProcedure);
        this.menuActions.add(this.menuDropTrigger);
        this.cmDropProcedure.setActionCommandKey("cmDropProcedure");
        this.cmDropProcedure.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropProcedure.setText(this.stringManager.getString("ProceduresPanelView-cmDropProcedure-text"));
        this.cmDropProcedure.setTooltip(this.stringManager.getString("ProceduresPanelView-cmDropProcedure-hint"));
        this.cmDropProcedure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmDropProcedureActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmCreateProcedure.setActionCommandKey("cmCreateProcedure");
        this.cmCreateProcedure.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/procedure.gif"));
        this.cmCreateProcedure.setText(this.stringManager.getString("ProceduresPanelView-cmCreateProcedure-text"));
        this.cmCreateProcedure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmCreateProcedureActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ProceduresPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitTables.setBorder(null);
        this.splitTables.setDividerLocation(200);
        this.splitTables.setContinuousLayout(true);
        this.splitTables.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableProcedures);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableProcedures);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.splitTables.setLeftComponent(this.panelTables);
        this.add((Component)this.splitTables, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableProcedures.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        if (StringUtil.equalsIgnoreCase((String)this.currentSchemaName, (String)"USER")) {
            this.setCurrentSchemaName("SYSTEM");
        } else {
            this.setCurrentSchemaName("USER");
        }
        this.refresh();
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmDropProcedureActionPerformed(ActionEvent evt) {
        if (this.tableProcedures.getSelectedRow() >= 0) {
            try {
                this.tableProcedures.getQuery().getRecord(this.tableProcedures.getSelectedRow());
                String procedureName = this.tableProcedures.getQuery().fieldByName("PROCEDURE_NAME").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)this.stringManager.getString("ProceduresPanelView-drop-procedure-q"), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop procedure " + SQLUtil.createSqlName((String)procedureName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableProcedures.getSelectedRow() >= 0) {
            try {
                this.tableProcedures.getQuery().getRecord(this.tableProcedures.getSelectedRow());
                String triggerName = this.tableProcedures.getQuery().fieldByName("PROCEDURE_NAME").getString();
                this.accesibilities.createView((ViewProvider)new ProcedureFreezeViewService(this.accesibilities, null, triggerName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableProcedures.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableProcedures.getQuery().getRecord(this.tableProcedures.getSelectionModel().getLeadSelectionIndex());
                String functionName = this.tableProcedures.getQuery().fieldByName("PROCEDURE_NAME").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), functionName, "RDB$PROCEDURES"), (boolean)true) != null) {
                    this.refresh(functionName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateProcedureActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateProcedureWizard(this.getDatabase()), (boolean)true);
        if (result != null) {
            this.refresh((String)result.getResultMap().get("object_name"));
        }
    }
}

