/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.sequences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.wizards.AlterSequenceWizard;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.firebird.gui.wizards.CreateSequenceWizard;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class SequencesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private boolean generatorDescription;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmAlterSequence;
    private Action cmComment;
    private Action cmCreateSequence;
    private Action cmDropSequence;
    private Action cmFilter;
    private Action cmGeneratorValue;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuDropSequence;
    private QueryTableStatusBar statusBarSequences;
    private ViewTable tableSequences;
    private JToolBar toolBar;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;

    public SequencesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.generatorDescription = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("generator-description", "false"));
        this.currentSchemaName = "USER";
        this.tableSequences.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("GENERATOR_ID", this.stringManager.getString("SequencesPanelView-id"), 70));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("GENERATOR_NAME", this.stringManager.getString("SequencesPanelView-sequence-name"), 190, (TableCellRenderer)new QueryTableCellRenderer(1)));
            if (this.generatorDescription) {
                this.tableSequences.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 250));
            }
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("GENERATOR_NAME", this.stringManager.getString("SequencesPanelView-sequence-name"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-sequences-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.cmComment.setEnabled(this.generatorDescription);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableSequences, (JButton)this.buttonActions, this.menuActions, "firebird-sequences-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase("USER")) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
                this.buttonSelectSchema.setSelected(true);
            } else {
                this.buttonSelectSchema.setSelected(false);
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SequencesPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableSequences.getQuery().isActive() && this.tableSequences.getSelectedRow() >= 0) {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                objectName = this.tableSequences.getQuery().fieldByName("GENERATOR_NAME").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableSequences.getSelectedColumn();
            int index = Math.max(0, this.tableSequences.getSelectedRow());
            this.tableSequences.getQuery().close();
            this.tableSequences.getQuery().setSqlText(Sql.getSequenceList(this.filter.getSqlText(), this.generatorDescription));
            this.tableSequences.getQuery().paramByName("SYSTEM_FLAG").setString(this.currentSchemaName);
            this.tableSequences.getQuery().open();
            if (objectName != null && this.tableSequences.getQuery().locate("GENERATOR_NAME", new Variant(objectName))) {
                this.tableSequences.changeSelection(this.tableSequences.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableSequences.getQuery().isEmpty()) {
                this.tableSequences.changeSelection(Math.min(index, this.tableSequences.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableSequences.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropSequence = new JMenuItem();
        this.cmDropSequence = new Action();
        this.cmGeneratorValue = new Action();
        this.cmComment = new Action();
        this.cmCreateSequence = new Action();
        this.cmAlterSequence = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableSequences = new ViewTable();
        this.statusBarSequences = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.toolButton2 = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCreateSequence);
        this.menuActions.add(this.jMenuItem1);
        this.jMenuItem2.setAction((javax.swing.Action)this.cmAlterSequence);
        this.menuActions.add(this.jMenuItem2);
        this.menuActions.add(this.jSeparator2);
        this.menuDropSequence.setAction((javax.swing.Action)this.cmDropSequence);
        this.menuActions.add(this.menuDropSequence);
        this.cmDropSequence.setActionCommandKey("cmDropSequence");
        this.cmDropSequence.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropSequence.setText(this.stringManager.getString("SequencesPanelView-cmDropSequence-text"));
        this.cmDropSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmDropSequenceActionPerformed(evt);
            }
        });
        this.cmGeneratorValue.setActionCommandKey("cmGeneratorValue");
        this.cmGeneratorValue.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/value.gif"));
        this.cmGeneratorValue.setText(this.stringManager.getString("SequencesPanelView-cmGeneratorValue-text"));
        this.cmGeneratorValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmGeneratorValueActionPerformed(evt);
            }
        });
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmCreateSequence.setActionCommandKey("cmCreateSequence");
        this.cmCreateSequence.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/sequence.gif"));
        this.cmCreateSequence.setText(this.stringManager.getString("SequencesPanelView-cmCreateSequence-text"));
        this.cmCreateSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmCreateSequenceActionPerformed(evt);
            }
        });
        this.cmAlterSequence.setActionCommandKey("cmAlterSequence");
        this.cmAlterSequence.setText(this.stringManager.getString("SequencesPanelView-cmAlterSequence-text"));
        this.cmAlterSequence.setTooltip(this.stringManager.getString("SequencesPanelView-cmAlterSequence-hint"));
        this.cmAlterSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmAlterSequenceActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SequencesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableSequences);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarSequences.setShowFieldType(false);
        this.statusBarSequences.setShowOpenTime(false);
        this.statusBarSequences.setTable((QueryTable)this.tableSequences);
        this.jPanel1.add((Component)this.statusBarSequences, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolButton1.setAction((javax.swing.Action)this.cmGeneratorValue);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton1);
        this.toolButton2.setAction((javax.swing.Action)this.cmComment);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton2);
        this.toolButton3.setAction((javax.swing.Action)this.cmCreateSequence);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton3);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableSequences.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        if (StringUtil.equalsIgnoreCase((String)this.currentSchemaName, (String)"USER")) {
            this.setCurrentSchemaName("SYSTEM");
        } else {
            this.setCurrentSchemaName("USER");
        }
        this.refresh();
    }

    private void cmDropSequenceActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectedRow() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                String sequenceName = this.tableSequences.getQuery().fieldByName("GENERATOR_NAME").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("SequencesPanelView-drop-sequence-q"), sequenceName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop generator " + SQLUtil.createSqlName((String)sequenceName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmGeneratorValueActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectedRow() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                String sequenceName = this.tableSequences.getQuery().fieldByName("GENERATOR_NAME").getString();
                Query query = this.getDatabase().createQuery();
                try {
                    query.open("SELECT GEN_ID( " + SQLUtil.createSqlName((String)sequenceName) + ", 0 ) VAL FROM RDB$DATABASE");
                    MessageBox.show((Component)null, (String)this.stringManager.getString("SequencesPanelView-value"), (String)String.format(this.stringManager.getString("SequencesPanelView-sequence-value"), sequenceName, query.fieldByName("VAL").getLong()), (int)1);
                }
                finally {
                    query.close();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectionModel().getLeadSelectionIndex());
                String sequenceName = this.tableSequences.getQuery().fieldByName("GENERATOR_NAME").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), sequenceName, "RDB$GENERATORS"), (boolean)true) != null) {
                    this.refresh(sequenceName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateSequenceActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateSequenceWizard(this.getDatabase()), (boolean)true);
        if (result != null) {
            this.refresh((String)result.getResultMap().get("object_name"));
        }
    }

    private void cmAlterSequenceActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectionModel().getLeadSelectionIndex());
                String sequenceName = this.tableSequences.getQuery().fieldByName("GENERATOR_NAME").getString();
                SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterSequenceWizard(this.getDatabase(), sequenceName), (boolean)true);
                if (result != null) {
                    this.refresh((String)result.getResultMap().get("object_name"));
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

