/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.firebird.gui.wizards.RenameTableColumnWizard;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintCheckWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintForeignKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintPrimaryKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TableColumnsPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmColumnList;
    private Action cmComment;
    private Action cmCreateConstraintCheck;
    private Action cmCreateConstraintFK;
    private Action cmCreateConstraintPK;
    private Action cmDropColumn;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmRenameColumn;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JSeparator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JSeparator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JPopupMenu menuActions;
    private JMenuItem menuColumnList;
    private JMenuItem menuCommentColumn;
    private JMenuItem menuCreateConstraintCheck;
    private JMenuItem menuDropColumn;
    private JMenuItem menuRenameColumn;
    private QueryTableStatusBar statusBarColumns;
    private ViewTable tableColumns;
    private JToolBar toolBarColumns;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;
    private ToolButton toolButton4;
    private ToolButton toolButton5;
    private ToolButton toolButton6;

    public TableColumnsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("FIELD_POSITION", this.stringManager.getString("TableColumnsPanel-no"), 30));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("FIELD_NAME", this.stringManager.getString("TableColumnsPanel-column-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("DISPLAY_TYPE", this.stringManager.getString("TableColumnsPanel-column-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("DOMAIN_NAME", this.stringManager.getString("TableColumnsPanel-domain"), 120));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("DEFAULT_SOURCE", this.stringManager.getString("TableColumnsPanel-default-value"), 200));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("NULL_FLAG", this.stringManager.getString("TableColumnsPanel-null-short-q"), 30));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("UPDATE_FLAG", this.stringManager.getString("TableColumnsPanel-update-short-q"), 30));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("CHARACTER_SET_NAME", this.stringManager.getString("TableColumnsPanel-charset"), 200));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 300));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("FIELD_NAME", this.stringManager.getString("TableColumnsPanel-column-name"), (String[])null));
            def.add(new SqlFilterDefComponent("DISPLAY_TYPE", this.stringManager.getString("TableColumnsPanel-column-type"), new String[]{"", "'VARYING%'", "'TEXT%'", "'SHORT%'", "'LONG%'", "'TIMESTAMP%'"}));
            def.add(new SqlFilterDefComponent("CHARACTER_SET_NAME", this.stringManager.getString("TableColumnsPanel-charset"), (String[])null));
            def.add(new SqlFilterDefComponent("NULL_FLAG = 'Y'", "NOT NULL"));
            def.add(new SqlFilterDefComponent("UPDATE_FLAG = 'Y'", this.stringManager.getString("TableColumnsPanel-can-update")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-table-columns-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableColumns, (JButton)this.buttonActions, this.menuActions, "firebird-table-columns-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableColumnsPanel-columns");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableColumnsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String columnName = null;
            this.requestRefresh = false;
            if (this.tableColumns.getQuery().isActive() && this.tableColumns.getSelectedRow() >= 0) {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                columnName = this.tableColumns.getQuery().fieldByName("FIELD_NAME").getString();
            }
            this.tableColumns.getQuery().close();
            this.tableColumns.getQuery().setSqlText(Sql.getColumnList(this.filter.getSqlText()));
            this.tableColumns.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableColumns.getQuery().open();
            if (!this.tableColumns.getQuery().isEmpty()) {
                if (columnName != null && this.tableColumns.getQuery().locate("FIELD_NAME", new Variant(columnName))) {
                    this.tableColumns.changeSelection(this.tableColumns.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableColumns.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableColumns.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmCreateConstraintCheck = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCommentColumn = new JMenuItem();
        this.menuRenameColumn = new JMenuItem();
        this.menuColumnList = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.menuCreateConstraintCheck = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropColumn = new JMenuItem();
        this.cmComment = new Action();
        this.cmDropColumn = new Action();
        this.cmColumnList = new Action();
        this.cmRenameColumn = new Action();
        this.cmCreateConstraintFK = new Action();
        this.cmCreateConstraintPK = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new ViewTable();
        this.statusBarColumns = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.toolButton2 = new ToolButton();
        this.toolButton4 = new ToolButton();
        this.toolButton5 = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton6 = new ToolButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmCreateConstraintCheck.setActionCommandKey("cmCreateConstraintCheck");
        this.cmCreateConstraintCheck.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/verify_document_16.gif"));
        this.cmCreateConstraintCheck.setText(this.stringManager.getString("TableColumnsPanel-cmCreateConstraintCheck-text"));
        this.cmCreateConstraintCheck.setTooltip(this.stringManager.getString("TableColumnsPanel-cmCreateConstraintCheck-hint"));
        this.cmCreateConstraintCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmCreateConstraintCheckActionPerformed(evt);
            }
        });
        this.menuCommentColumn.setAction((javax.swing.Action)this.cmComment);
        this.menuActions.add(this.menuCommentColumn);
        this.menuRenameColumn.setAction((javax.swing.Action)this.cmRenameColumn);
        this.menuActions.add(this.menuRenameColumn);
        this.menuColumnList.setAction((javax.swing.Action)this.cmColumnList);
        this.menuActions.add(this.menuColumnList);
        this.menuActions.add(this.jSeparator5);
        this.menuCreateConstraintCheck.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.menuActions.add(this.menuCreateConstraintCheck);
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.menuActions.add(this.jMenuItem1);
        this.jMenuItem2.setAction((javax.swing.Action)this.cmCreateConstraintPK);
        this.menuActions.add(this.jMenuItem2);
        this.menuActions.add(this.jSeparator3);
        this.menuDropColumn.setAction((javax.swing.Action)this.cmDropColumn);
        this.menuActions.add(this.menuDropColumn);
        this.cmComment.setActionCommandKey("cmCommentTable");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmDropColumn.setActionCommandKey("cmDropColumn");
        this.cmDropColumn.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropColumn.setText(this.stringManager.getString("TableColumnsPanel-cmDropColumn-text"));
        this.cmDropColumn.setTooltip(this.stringManager.getString("TableColumnsPanel-cmDropColumn-hint"));
        this.cmDropColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmDropColumnActionPerformed(evt);
            }
        });
        this.cmColumnList.setActionCommandKey("cmColumnList");
        this.cmColumnList.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/copy.gif"));
        this.cmColumnList.setText(this.stringManager.getString("TableColumnsPanel-cmColumnList-text"));
        this.cmColumnList.setTooltip(this.stringManager.getString("TableColumnsPanel-cmColumnList-hint"));
        this.cmColumnList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmColumnListActionPerformed(evt);
            }
        });
        this.cmRenameColumn.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/rename.gif"));
        this.cmRenameColumn.setText(this.stringManager.getString("cmRenameColumn-text"));
        this.cmRenameColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmRenameColumnActionPerformed(evt);
            }
        });
        this.cmCreateConstraintFK.setActionCommandKey("cmCreateConstraintFK");
        this.cmCreateConstraintFK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/foreign_key16.gif"));
        this.cmCreateConstraintFK.setText(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintFK-text"));
        this.cmCreateConstraintFK.setTooltip(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintFK-hint"));
        this.cmCreateConstraintFK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmCreateConstraintFKActionPerformed(evt);
            }
        });
        this.cmCreateConstraintPK.setActionCommandKey("cmCreateConstraintPrimaryKey");
        this.cmCreateConstraintPK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/primary_key16.gif"));
        this.cmCreateConstraintPK.setText(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintPK-text"));
        this.cmCreateConstraintPK.setTooltip(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintPK-hint"));
        this.cmCreateConstraintPK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmCreateConstraintPKActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableColumnsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarColumns.setShowFieldType(false);
        this.statusBarColumns.setShowOpenTime(false);
        this.statusBarColumns.setTable((QueryTable)this.tableColumns);
        this.add((Component)this.statusBarColumns, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator2);
        this.toolButton1.setAction((javax.swing.Action)this.cmComment);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton1);
        this.toolButton3.setAction((javax.swing.Action)this.cmColumnList);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton3);
        this.toolBarColumns.add(this.jSeparator4);
        this.toolButton2.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton2);
        this.toolButton4.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.toolButton4.setHorizontalTextPosition(0);
        this.toolButton4.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton4);
        this.toolButton5.setAction((javax.swing.Action)this.cmCreateConstraintPK);
        this.toolButton5.setHorizontalTextPosition(0);
        this.toolButton5.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton5);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolButton6.setAction((javax.swing.Action)this.cmDropColumn);
        this.toolButton6.setHorizontalTextPosition(0);
        this.toolButton6.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton6);
        this.toolBarColumns.add(this.jSeparator6);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmCreateConstraintCheckActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectedRow() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintCheckWizardPanel(this.getDatabase(), null, this.currentTableName), (boolean)true);
                this.refresh();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectionModel().getLeadSelectionIndex());
                String columnName = this.tableColumns.getQuery().fieldByName("FIELD_NAME").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), this.currentTableName, columnName, "RDB$RELATION_FIELDS"), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmDropColumnActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectedRow() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                String columnName = this.tableColumns.getQuery().fieldByName("FIELD_NAME").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TableColumnsPanel-drop-column-q"), columnName, this.currentTableName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("alter table " + SQLUtil.createSqlName((String)this.currentTableName) + " DROP " + SQLUtil.createSqlName((String)columnName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmColumnListActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getQuery().isActive()) {
            try {
                StringBuffer sb = new StringBuffer();
                int l = 0;
                this.tableColumns.getQuery().first();
                while (!this.tableColumns.getQuery().eof()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                        l += 2;
                    }
                    if (l > 100) {
                        l = 0;
                        sb.append('\n');
                    }
                    String column = SQLUtil.createSqlName((String)this.tableColumns.getQuery().fieldByName("FIELD_NAME").getString());
                    sb.append(column);
                    l += column.length();
                    this.tableColumns.getQuery().next();
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(sb.toString()), null);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmRenameColumnActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectionModel().getLeadSelectionIndex());
                String columnName = this.tableColumns.getQuery().fieldByName("FIELD_NAME").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RenameTableColumnWizard(this.getDatabase(), this.currentTableName, columnName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateConstraintFKActionPerformed(ActionEvent evt) {
        try {
            this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectionModel().getLeadSelectionIndex());
            String columnName = this.tableColumns.getQuery().fieldByName("FIELD_NAME").getString();
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintForeignKeyWizardPanel(this.getDatabase(), null, this.currentTableName, columnName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCreateConstraintPKActionPerformed(ActionEvent evt) {
        try {
            this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectionModel().getLeadSelectionIndex());
            String columnName = this.tableColumns.getQuery().fieldByName("FIELD_NAME").getString();
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintPrimaryKeyWizardPanel(this.getDatabase(), null, this.currentTableName, columnName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

