/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintCheckWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintForeignKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintPrimaryKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableConstraintsPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentTableName = "";
    private boolean closing = false;
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonCreateConstraintCheck;
    private ToolButton buttonCreateConstraintFK;
    private ToolButton buttonCreateConstraintPrimaryKey;
    private ToolButton buttonDtopConstraint;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmCreateConstraintCheck;
    private Action cmCreateConstraintFK;
    private Action cmCreateConstraintPK;
    private Action cmDropConstraint;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarConstraints;
    private ViewTable tableConstraints;
    private JToolBar toolBarConstraints;

    public TableConstraintsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableConstraints.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableConstraintsPanel.this.tableConstraints.getSelectedRow();
                if (rowIndex >= 0 && TableConstraintsPanel.this.tableConstraints.getQuery().isActive()) {
                    try {
                        TableConstraintsPanel.this.tableConstraints.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableConstraints.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("CONSTRAINT_NAME", this.stringManager.getString("TableConstraintsPanel-constraint-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("CONSTRAINT_TYPE", this.stringManager.getString("TableConstraintsPanel-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("COLUMNS", this.stringManager.getString("TableConstraintsPanel-columns"), 150));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("FK_RULE", this.stringManager.getString("TableConstraintsPanel-fk-rule"), 150));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("CHECK_CLAUSE", this.stringManager.getString("TableConstraintsPanel-check-clause"), 150));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("CONSTRAINT_NAME", this.stringManager.getString("TableConstraintsPanel-constraint-name"), (String[])null));
            def.add(new SqlFilterDefComponent("CONSTRAINT_TYPE", this.stringManager.getString("TableConstraintsPanel-constraint-type"), new String[]{"", "'PRIMARY KEY'", "'FOREIGN KEY'", "'CHECK'"}));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-table-constraints-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableConstraints, (JButton)this.buttonActions, this.menuActions, "firebird-table-constraints-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableConstraints.getQuery().close();
            this.tableConstraints.getQuery().setSqlText(Sql.getConstraintList(this.filter.getSqlText()));
            this.tableConstraints.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableConstraints.getQuery().open();
            if (!this.tableConstraints.getQuery().isEmpty()) {
                this.tableConstraints.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableConstraints.getQuery().close();
        this.accesibilities = null;
    }

    public String getTitle() {
        return this.stringManager.getString("TableConstraintsPanel-constraints");
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropConstraint = new Action();
        this.cmCreateConstraintCheck = new Action();
        this.cmCreateConstraintFK = new Action();
        this.cmCreateConstraintPK = new Action();
        this.menuActions = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.tableConstraints = new ViewTable();
        this.statusBarConstraints = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarConstraints = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonCreateConstraintCheck = new ToolButton();
        this.buttonCreateConstraintFK = new ToolButton();
        this.buttonCreateConstraintPrimaryKey = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDtopConstraint = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropConstraint.setActionCommandKey("cmDropConstraint");
        this.cmDropConstraint.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropConstraint.setText(this.stringManager.getString("TableConstraintsPanel-cmDropConstraint-text"));
        this.cmDropConstraint.setTooltip(this.stringManager.getString("TableConstraintsPanel-cmDropConstraint-hint"));
        this.cmDropConstraint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmDropConstraintActionPerformed(evt);
            }
        });
        this.cmCreateConstraintCheck.setActionCommandKey("cmCreateConstraintCheck");
        this.cmCreateConstraintCheck.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/verify_document_16.gif"));
        this.cmCreateConstraintCheck.setText(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintCheck-text"));
        this.cmCreateConstraintCheck.setTooltip(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintCheck-hint"));
        this.cmCreateConstraintCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmCreateConstraintCheckActionPerformed(evt);
            }
        });
        this.cmCreateConstraintFK.setActionCommandKey("cmCreateConstraintFK");
        this.cmCreateConstraintFK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/foreign_key16.gif"));
        this.cmCreateConstraintFK.setText(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintFK-text"));
        this.cmCreateConstraintFK.setTooltip(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintFK-hint"));
        this.cmCreateConstraintFK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmCreateConstraintFKActionPerformed(evt);
            }
        });
        this.cmCreateConstraintPK.setActionCommandKey("cmCreateConstraintPrimaryKey");
        this.cmCreateConstraintPK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/primary_key16.gif"));
        this.cmCreateConstraintPK.setText(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintPK-text"));
        this.cmCreateConstraintPK.setTooltip(this.stringManager.getString("TableConstraintsPanel-cmCreateConstraintPK-hint"));
        this.cmCreateConstraintPK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmCreateConstraintPKActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableConstraintsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableConstraints);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarConstraints.setShowFieldType(false);
        this.statusBarConstraints.setShowOpenTime(false);
        this.statusBarConstraints.setTable((QueryTable)this.tableConstraints);
        this.add((Component)this.statusBarConstraints, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarConstraints.setFloatable(false);
        this.toolBarConstraints.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarConstraints.add(this.jSeparator2);
        this.buttonCreateConstraintCheck.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.buttonCreateConstraintCheck.setHorizontalTextPosition(0);
        this.buttonCreateConstraintCheck.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonCreateConstraintCheck);
        this.buttonCreateConstraintFK.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.buttonCreateConstraintFK.setHorizontalTextPosition(0);
        this.buttonCreateConstraintFK.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonCreateConstraintFK);
        this.buttonCreateConstraintPrimaryKey.setAction((javax.swing.Action)this.cmCreateConstraintPK);
        this.buttonCreateConstraintPrimaryKey.setHorizontalTextPosition(0);
        this.buttonCreateConstraintPrimaryKey.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonCreateConstraintPrimaryKey);
        this.jSeparator1.setOrientation(1);
        this.toolBarConstraints.add(this.jSeparator1);
        this.buttonDtopConstraint.setAction((javax.swing.Action)this.cmDropConstraint);
        this.buttonDtopConstraint.setHorizontalTextPosition(0);
        this.buttonDtopConstraint.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonDtopConstraint);
        this.toolBarConstraints.add(this.jSeparator3);
        this.toolBarConstraints.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmCreateConstraintPKActionPerformed(ActionEvent evt) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintPrimaryKeyWizardPanel(this.getDatabase(), null, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCreateConstraintFKActionPerformed(ActionEvent evt) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintForeignKeyWizardPanel(this.getDatabase(), null, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCreateConstraintCheckActionPerformed(ActionEvent evt) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintCheckWizardPanel(this.getDatabase(), null, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmDropConstraintActionPerformed(ActionEvent evt) {
        if (this.tableConstraints.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableConstraints.getQuery().getRecord(this.tableConstraints.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.tableConstraints.getQuery().fieldByName("constraint_name").getString());
                String tableName = SQLUtil.createSqlName((String)this.currentTableName);
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TableConstraintsPanel-drop-constraint-q"), objectName, tableName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("alter table " + tableName + " drop constraint " + objectName, true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refresh(null, null, this.currentTableName);
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

