/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.CreateIndexWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableIndexesPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmComment;
    private Action cmDropIndex;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSimpleCreateIndex;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JSeparator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JPopupMenu menuActions;
    private JMenuItem menuDropIndex;
    private JMenuItem menuSimpleCreateIndex;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableIndexes;
    private JToolBar toolBarIndexes;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;

    public TableIndexesPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableIndexes.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("INDEX_NAME", this.stringManager.getString("TableIndexesPanel-index-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("COLUMNS", this.stringManager.getString("TableIndexesPanel-columns"), 150));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("UNIQUINES", this.stringManager.getString("TableIndexesPanel-unique"), 50));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("ORDERING", this.stringManager.getString("TableIndexesPanel-order"), 50));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("INDEX_ACTIVE", this.stringManager.getString("TableIndexesPanel-active"), 50));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("EXPRESSION_SOURCE", this.stringManager.getString("computed"), 100));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 250));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("INDEX_NAME", this.stringManager.getString("TableIndexesPanel-index-name"), (String[])null));
            def.add(new SqlFilterDefComponent("COLUMNS", this.stringManager.getString("TableIndexesPanel-columns"), (String[])null));
            def.add(new SqlFilterDefComponent("UNIQUINES = 'Y'", this.stringManager.getString("TableIndexesPanel-uniquenes")));
            def.add(new SqlFilterDefComponent("INDEX_ACTIVE = 'Y'", this.stringManager.getString("TableIndexesPanel-activated")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-table-indexes-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableIndexes, (JButton)this.buttonActions, this.menuActions, "firebird-table-indexes-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableIndexesPanel-indexes");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableIndexesPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableIndexes.getQuery().close();
            this.tableIndexes.getQuery().setSqlText(Sql.getIndexList(this.filter.getSqlText()));
            this.tableIndexes.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableIndexes.getQuery().open();
            if (!this.tableIndexes.getQuery().isEmpty()) {
                this.tableIndexes.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableIndexes.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropIndex = new Action();
        this.cmSimpleCreateIndex = new Action();
        this.menuActions = new JPopupMenu();
        this.menuSimpleCreateIndex = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropIndex = new JMenuItem();
        this.cmComment = new Action();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.toolButton3 = new ToolButton();
        this.toolButton1 = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.toolButton2 = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableIndexes = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropIndex.setActionCommandKey("cmDropIndex");
        this.cmDropIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropIndex.setText(this.stringManager.getString("TableIndexesPanel-cmDropIndex-text"));
        this.cmDropIndex.setTooltip(this.stringManager.getString("TableIndexesPanel-cmDropIndex-hint"));
        this.cmDropIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmDropIndexActionPerformed(evt);
            }
        });
        this.cmSimpleCreateIndex.setActionCommandKey("cmSimpleCreateIndex");
        this.cmSimpleCreateIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/create_index16.gif"));
        this.cmSimpleCreateIndex.setText(this.stringManager.getString("TableIndexesPanel-cmSimpleCreateIndex-text"));
        this.cmSimpleCreateIndex.setTooltip(this.stringManager.getString("TableIndexesPanel-cmSimpleCreateIndex-hint"));
        this.cmSimpleCreateIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmSimpleCreateIndexActionPerformed(evt);
            }
        });
        this.menuSimpleCreateIndex.setAction((javax.swing.Action)this.cmSimpleCreateIndex);
        this.menuActions.add(this.menuSimpleCreateIndex);
        this.jMenuItem1.setAction((javax.swing.Action)this.cmComment);
        this.menuActions.add(this.jMenuItem1);
        this.menuActions.add(this.jSeparator3);
        this.menuDropIndex.setAction((javax.swing.Action)this.cmDropIndex);
        this.menuActions.add(this.menuDropIndex);
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmCommentActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableIndexesPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableIndexes);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonFilter);
        this.toolBarIndexes.add(this.jSeparator4);
        this.toolButton3.setAction((javax.swing.Action)this.cmComment);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.toolButton3);
        this.toolButton1.setAction((javax.swing.Action)this.cmSimpleCreateIndex);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.toolButton1);
        this.toolBarIndexes.add(this.jSeparator2);
        this.toolButton2.setAction((javax.swing.Action)this.cmDropIndex);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.toolButton2);
        this.toolBarIndexes.add(this.jSeparator1);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableIndexes);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cmSimpleCreateIndexActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateIndexWizardPanel(this.getDatabase(), null, this.currentTableName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmDropIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectedRow() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TableIndexesPanel-drop-index-q"), indexName, this.currentTableName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop index " + SQLUtil.createSqlName((String)indexName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectionModel().getLeadSelectionIndex());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), indexName, "RDB$INDICES"), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

