/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.util.SourceCreator;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableSourcePanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentObjectName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JPanel jPanel1;
    private OrbadaSyntaxTextArea syntaxSource;
    private JToolBar toolBarContent;

    public TableSourcePanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void setEditorText(final String objectName, final String text) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableSourcePanel.this.syntaxSource.setDatabaseObject(null, "TABLE", objectName, text);
                TableSourcePanel.this.syntaxSource.getEditorArea().setCaretPosition(0);
            }
        });
    }

    private void init() {
        this.syntaxSource.getStatusBar().addPanel("ddl-status").setText(" ");
        this.syntaxSource.setDatabase(this.getDatabase());
    }

    public String getObjectName() {
        return this.syntaxSource.getObjectName();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableSourcePanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableSourcePanel.this.refresh();
            }
        });
    }

    public void refresh() {
        this.requestRefresh = false;
        new SourceCreator(this.getDatabase(), (SyntaxTextArea)this.syntaxSource).getSource(null, "TABLE", this.currentObjectName);
        this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(" " + this.currentObjectName);
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
                this.setEditorText(null, "");
            }
        }
    }

    public boolean canClose() {
        return this.syntaxSource.canClose();
    }

    public void close() throws IOException {
        this.closing = true;
        this.syntaxSource.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.jPanel1 = new JPanel();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.syntaxSource = new OrbadaSyntaxTextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("ViewSourcePanel-cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableSourcePanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableSourcePanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.jPanel1.add(this.toolBarContent);
        this.add((Component)this.jPanel1, "North");
        this.add((Component)this.syntaxSource, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

