/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.freezing.TriggerFreezeViewService;
import pl.mpak.orbada.firebird.gui.wizards.CreateTriggerWizard;
import pl.mpak.orbada.firebird.syntax.parser.FirebirdPSqlStructureParser;
import pl.mpak.orbada.firebird.util.SourceCreator;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.sky.gui.swing.syntax.structure.StructureParser;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class TableTriggersPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ISettings settings;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmActiveTrigger;
    private Action cmCreateTrigger;
    private Action cmDropTrigger;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JSeparator jSeparator3;
    private JPopupMenu menuActions;
    private JSplitPane splitTriggers;
    private QueryTableStatusBar statusBarTriggers;
    private ViewTable tableTriggers;
    private OrbadaSyntaxTextArea textTrigger;
    private JToolBar toolBarTriggers;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;
    private ToolButton toolButton4;

    public TableTriggersPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-table-triggers-panel");
        this.splitTriggers.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTriggers.getDividerLocation())).intValue());
        this.textTrigger.setDatabase(this.getDatabase());
        this.textTrigger.setStructureParser((StructureParser)new FirebirdPSqlStructureParser());
        this.textTrigger.setEditable(false);
        this.tableTriggers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            String triggerName;

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableTriggersPanel.this.tableTriggers.getSelectedRow();
                if (rowIndex >= 0 && TableTriggersPanel.this.tableTriggers.getQuery().isActive()) {
                    try {
                        TableTriggersPanel.this.tableTriggers.getQuery().getRecord(rowIndex);
                        if (this.triggerName == null || !this.triggerName.equals(TableTriggersPanel.this.tableTriggers.getQuery().fieldByName("trigger_name").getString())) {
                            TableTriggersPanel.this.updateTriggerBody();
                            this.triggerName = TableTriggersPanel.this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    TableTriggersPanel.this.textTrigger.setText("");
                }
            }
        });
        this.tableTriggers.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("TRIGGER_NAME", this.stringManager.getString("TableTriggersPanel-trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("RDB$TRIGGER_TYPE", this.stringManager.getString("TableTriggersPanel-when"), 120, (TableCellRenderer)new QueryTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    label.setForeground(TableTriggersPanel.this.tableTriggers.getForeground());
                    label.setHorizontalAlignment(10);
                    if (value instanceof Variant) {
                        try {
                            label.setText(SourceCreator.decodeTriggerType(null, ((Variant)value).getInteger()));
                        }
                        catch (VariantException ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                    } else {
                        label.setText(SourceCreator.decodeTriggerType(null, ((Short)value).shortValue()));
                    }
                    return label;
                }
            }));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("TRIGGER_SEQUENCE", this.stringManager.getString("TableTriggersPanel-sequence"), 60));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("TRIGGER_ACTIVE", this.stringManager.getString("TableTriggersPanel-active"), 60));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("TRIGGER_NAME", this.stringManager.getString("TableTriggersPanel-trigger-name"), (String[])null));
            def.add(new SqlFilterDefComponent("TRIGGER_ACTIVE <> 'Y'", this.stringManager.getString("TableTriggersPanel-activated")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-table-triggers-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTriggers, (JButton)this.buttonActions, this.menuActions, "firebird-table-triggers-actions");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableTriggersPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableTriggers.getQuery().close();
            this.tableTriggers.getQuery().setSqlText(Sql.getTableTriggerList(this.filter.getSqlText()));
            this.tableTriggers.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableTriggers.getQuery().open();
            if (!this.tableTriggers.getQuery().isEmpty()) {
                this.tableTriggers.changeSelection(0, 0);
                this.updateTriggerBody();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void updateTriggerBody() {
        try {
            new SourceCreator(this.getDatabase(), (SyntaxTextArea)this.textTrigger).getSource(null, "TRIGGER", this.tableTriggers.getQuery().fieldByName("trigger_name").getString());
        }
        catch (Exception ex) {
            this.textTrigger.setDatabaseObject(null, null, null, "");
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableTriggersPanel-title");
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.settings.setValue("split-location", Long.valueOf(this.splitTriggers.getDividerLocation()));
        this.settings.store();
        this.tableTriggers.getQuery().close();
        this.textTrigger.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItem2 = new JMenuItem();
        this.cmFreezeObject = new Action();
        this.cmCreateTrigger = new Action();
        this.cmDropTrigger = new Action();
        this.cmActiveTrigger = new Action();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.toolButton1 = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton4 = new ToolButton();
        this.toolButton2 = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.toolButton3 = new ToolButton();
        this.buttonActions = new ToolButton();
        this.splitTriggers = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTriggers = new ViewTable();
        this.statusBarTriggers = new QueryTableStatusBar();
        this.textTrigger = new OrbadaSyntaxTextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.jMenuItem3.setAction((javax.swing.Action)this.cmActiveTrigger);
        this.menuActions.add(this.jMenuItem3);
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCreateTrigger);
        this.menuActions.add(this.jMenuItem1);
        this.menuActions.add(this.jSeparator3);
        this.jMenuItem2.setAction((javax.swing.Action)this.cmDropTrigger);
        this.menuActions.add(this.jMenuItem2);
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmCreateTrigger.setActionCommandKey("cmCreateTrigger");
        this.cmCreateTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trigger.gif"));
        this.cmCreateTrigger.setText(this.stringManager.getString("TableTriggersPanel-cmCreateTrigger-text"));
        this.cmCreateTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmCreateTriggerActionPerformed(evt);
            }
        });
        this.cmDropTrigger.setActionCommandKey("cmDropTrigger");
        this.cmDropTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTrigger.setText(this.stringManager.getString("TableTriggersPanel-cmDropTrigger-text"));
        this.cmDropTrigger.setTooltip(this.stringManager.getString("TableTriggersPanel-cmDropTrigger-hint"));
        this.cmDropTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmDropTriggerActionPerformed(evt);
            }
        });
        this.cmActiveTrigger.setActionCommandKey("cmActiveTrigger");
        this.cmActiveTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enabled.gif"));
        this.cmActiveTrigger.setText(this.stringManager.getString("TableTriggersPanel-cmActiveTrigger-text"));
        this.cmActiveTrigger.setTooltip(this.stringManager.getString("TableTriggersPanel-cmActiveTrigger-hint"));
        this.cmActiveTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmActiveTriggerActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableTriggersPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonFilter);
        this.toolButton1.setAction((javax.swing.Action)this.cmFreezeObject);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton1);
        this.toolBarTriggers.add(this.jSeparator1);
        this.toolButton4.setAction((javax.swing.Action)this.cmActiveTrigger);
        this.toolButton4.setHorizontalTextPosition(0);
        this.toolButton4.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton4);
        this.toolButton2.setAction((javax.swing.Action)this.cmCreateTrigger);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton2);
        this.toolBarTriggers.add(this.jSeparator2);
        this.toolButton3.setAction((javax.swing.Action)this.cmDropTrigger);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton3);
        this.toolBarTriggers.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
        this.splitTriggers.setBorder(null);
        this.splitTriggers.setDividerLocation(350);
        this.splitTriggers.setOrientation(0);
        this.splitTriggers.setContinuousLayout(true);
        this.splitTriggers.setOneTouchExpandable(true);
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTriggers);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarTriggers.setShowFieldType(false);
        this.statusBarTriggers.setShowOpenTime(false);
        this.statusBarTriggers.setTable((QueryTable)this.tableTriggers);
        this.jPanel1.add((Component)this.statusBarTriggers, "South");
        this.splitTriggers.setLeftComponent(this.jPanel1);
        this.textTrigger.setPreferredSize(new Dimension(81, 150));
        this.splitTriggers.setRightComponent((Component)this.textTrigger);
        this.add((Component)this.splitTriggers, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                this.accesibilities.createView((ViewProvider)new TriggerFreezeViewService(this.accesibilities, null, triggerName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateTriggerActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTriggerWizard(this.getDatabase(), this.currentTableName), (boolean)true);
        if (result != null) {
            this.refresh();
        }
    }

    private void cmDropTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TableTriggersPanel-drop-trigger-q"), triggerName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop trigger " + SQLUtil.createSqlName((String)triggerName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmActiveTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (StringUtil.toBoolean((String)this.tableTriggers.getQuery().fieldByName("trigger_active").getString())) {
                    if (MessageBox.show((Component)null, (String)this.stringManager.getString("TableTriggersPanel-trigger"), (String)String.format(this.stringManager.getString("TableTriggersPanel-inactive-trigger-q"), triggerName), (int[])ModalResult.YESNO) == 5) {
                        this.getDatabase().createCommand("alter trigger " + SQLUtil.createSqlName((String)triggerName) + " INACTIVE", true);
                        this.refresh();
                    }
                } else if (MessageBox.show((Component)null, (String)this.stringManager.getString("TableTriggersPanel-trigger"), (String)String.format(this.stringManager.getString("TableTriggersPanel-active-trigger-q"), triggerName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("alter trigger " + SQLUtil.createSqlName((String)triggerName) + " ACTIVE", true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

