/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.freezing.TableFreezeViewService;
import pl.mpak.orbada.firebird.gui.tables.TableTabbedPane;
import pl.mpak.orbada.firebird.gui.wizards.CommentWizard;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class TablesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmComment;
    private Action cmDropTable;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRecordCount;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuCommentTable;
    private JMenuItem menuDropTable;
    private JMenuItem menuRecordCount;
    private JPanel panelTables;
    private JSplitPane splitTables;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableTables;
    private JToolBar toolBarTables;

    public TablesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TablesPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaFirebirdPlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new TableTabbedPane(this.accesibilities);
        this.splitTables.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-tables-panel");
        this.splitTables.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTables.getDividerLocation())).intValue());
        this.currentSchemaName = "USER";
        this.tableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TablesPanelView.this.timer.restart();
            }
        });
        this.tableTables.getQuery().setDatabase(this.getDatabase());
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("TABLE_NAME", this.stringManager.getString("TablesPanelView-table-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("DESCRIPTION", this.stringManager.getString("comment"), 200));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("OWNER_NAME", this.stringManager.getString("TablesPanelView-owner"), 100));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("TABLE_NAME", this.stringManager.getString("TablesPanelView-table-name"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-tables-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTables, (JButton)this.buttonActions, this.menuActions, "firebird-tables-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TablesPanelView.this.tableTables.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase("USER")) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
                this.buttonSelectSchema.setSelected(true);
            } else {
                this.buttonSelectSchema.setSelected(false);
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String tableName = "";
        int rowIndex = this.tableTables.getSelectedRow();
        if (rowIndex >= 0) {
            try {
                this.tableTables.getQuery().getRecord(rowIndex);
                tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, null, tableName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TablesPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String tableName = null;
            if (this.tableTables.getQuery().isActive() && this.tableTables.getSelectedRow() >= 0) {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                tableName = this.tableTables.getQuery().fieldByName("TABLE_NAME").getString();
            }
            this.refresh(tableName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        try {
            int column = this.tableTables.getSelectedColumn();
            int index = Math.max(0, this.tableTables.getSelectedRow());
            this.tableTables.getQuery().close();
            this.tableTables.getQuery().setSqlText(Sql.getTableList(this.filter.getSqlText()));
            this.tableTables.getQuery().paramByName("SYSTEM_FLAG").setString(this.currentSchemaName);
            this.tableTables.getQuery().open();
            if (objectName != null && this.tableTables.getQuery().locate("TABLE_NAME", new Variant(objectName))) {
                this.tableTables.changeSelection(this.tableTables.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableTables.getQuery().isEmpty()) {
                this.tableTables.changeSelection(Math.min(index, this.tableTables.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.splitTables.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableTables.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.cmDropTable = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCommentTable = new JMenuItem();
        this.menuRecordCount = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropTable = new JMenuItem();
        this.cmComment = new Action();
        this.cmRecordCount = new Action();
        this.cmFreezeObject = new Action();
        this.splitTables = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTables = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropTable.setActionCommandKey("cmDropTable");
        this.cmDropTable.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTable.setText(this.stringManager.getString("TablesPanelView-cmDropTable-text"));
        this.cmDropTable.setTooltip(this.stringManager.getString("TablesPanelView-cmDropTable-hint"));
        this.cmDropTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmDropTableActionPerformed(evt);
            }
        });
        this.menuCommentTable.setAction((javax.swing.Action)this.cmComment);
        this.menuActions.add(this.menuCommentTable);
        this.menuRecordCount.setAction((javax.swing.Action)this.cmRecordCount);
        this.menuActions.add(this.menuRecordCount);
        this.menuActions.add(this.jSeparator2);
        this.menuDropTable.setAction((javax.swing.Action)this.cmDropTable);
        this.menuActions.add(this.menuDropTable);
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmRecordCount.setActionCommandKey("cmRecordCount");
        this.cmRecordCount.setText(this.stringManager.getString("TablesPanelView-cmRecordCount-text"));
        this.cmRecordCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmRecordCountActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TablesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitTables.setBorder(null);
        this.splitTables.setDividerLocation(200);
        this.splitTables.setContinuousLayout(true);
        this.splitTables.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTables);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableTables);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.splitTables.setLeftComponent(this.panelTables);
        this.add((Component)this.splitTables, "Center");
    }

    private void cmDropTableActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TablesPanelView-drop-table-q"), this.tableTables.getQuery().fieldByName("TABLE_NAME").getString()), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop table " + SQLUtil.createSqlName((String)this.tableTables.getQuery().fieldByName("TABLE_NAME").getString()), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableTables.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        if (StringUtil.equalsIgnoreCase((String)this.currentSchemaName, (String)"USER")) {
            this.setCurrentSchemaName("SYSTEM");
        } else {
            this.setCurrentSchemaName("USER");
        }
        this.refresh();
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableListTask();
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectionModel().getLeadSelectionIndex());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentWizard(this.getDatabase(), tableName, "RDB$RELATIONS"), (boolean)true) != null) {
                    this.refresh(tableName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmRecordCountActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            Query query = this.getDatabase().createQuery();
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                query.open("select count( 0 ) cnt from " + SQLUtil.createSqlName((String)tableName));
                MessageBox.show((Component)this, (String)this.stringManager.getString("TablesPanelView-record-count"), (String)String.format(this.stringManager.getString("TablesPanelView-record-count-info"), SQLUtil.createSqlName((String)tableName, (String)query.fieldByName("cnt").getString())), (int)1, (int)1);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
            finally {
                query.close();
            }
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                this.accesibilities.createView((ViewProvider)new TableFreezeViewService(this.accesibilities, null, tableName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

