/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.triggers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.freezing.TriggerFreezeViewService;
import pl.mpak.orbada.firebird.gui.triggers.TriggerSourcePanel;
import pl.mpak.orbada.firebird.gui.triggers.TriggerTabbedPane;
import pl.mpak.orbada.firebird.gui.wizards.CreateTriggerWizard;
import pl.mpak.orbada.firebird.util.SourceCreator;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class TriggersPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmActiveTrigger;
    private Action cmCreateTrigger;
    private Action cmDropTrigger;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuCreateTrigger;
    private JMenuItem menuDropTrigger;
    private JPanel panelTables;
    private JSplitPane splitTables;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableTriggers;
    private JToolBar toolBarTables;

    public TriggersPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TriggersPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaFirebirdPlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new TriggerTabbedPane(this.accesibilities);
        this.splitTables.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-triggers-panel");
        this.splitTables.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTables.getDividerLocation())).intValue());
        this.currentSchemaName = "USER";
        this.tableTriggers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                TriggerSourcePanel panel = (TriggerSourcePanel)TriggersPanelView.this.tabbedPane.getComponent(TriggerSourcePanel.class);
                if (panel != null && this.lastIndex != TriggersPanelView.this.tableTriggers.getSelectedRow() && !panel.canClose()) {
                    TriggersPanelView.this.tableTriggers.changeSelection(this.lastIndex, TriggersPanelView.this.tableTriggers.getSelectedColumn());
                    return;
                }
                this.lastIndex = TriggersPanelView.this.tableTriggers.getSelectedRow();
                TriggersPanelView.this.timer.restart();
            }
        });
        this.tableTriggers.getQuery().setDatabase(this.getDatabase());
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("TRIGGER_NAME", this.stringManager.getString("TriggersPanelView-trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("RDB$TRIGGER_TYPE", this.stringManager.getString("TriggersPanelView-when"), 120, (TableCellRenderer)new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setForeground(TriggersPanelView.this.tableTriggers.getForeground());
                label.setHorizontalAlignment(10);
                if (value instanceof Variant) {
                    try {
                        label.setText(SourceCreator.decodeTriggerType(null, ((Variant)value).getInteger()));
                    }
                    catch (VariantException ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    label.setText(SourceCreator.decodeTriggerType(null, ((Short)value).shortValue()));
                }
                return label;
            }
        }));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("TABLE_NAME", this.stringManager.getString("TriggersPanelView-table-name"), 150));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("TRIGGER_SEQUENCE", this.stringManager.getString("TriggersPanelView-sequence"), 60));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("TRIGGER_ACTIVE", this.stringManager.getString("TriggersPanelView-active"), 60));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("TRIGGER_NAME", this.stringManager.getString("TriggersPanelView-trigger-name"), (String[])null));
        def.add(new SqlFilterDefComponent("TABLE_NAME", this.stringManager.getString("TriggersPanelView-table-name"), (String[])null));
        def.add(new SqlFilterDefComponent("TRIGGER_ACTIVE <> 'Y'", this.stringManager.getString("TriggersPanelView-inactived")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-triggers-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTriggers, (JButton)this.buttonActions, this.menuActions, "firebird-triggers-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TriggersPanelView.this.tableTriggers.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase("USER")) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
                this.buttonSelectSchema.setSelected(true);
            } else {
                this.buttonSelectSchema.setSelected(false);
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String triggerName = "";
        int rowIndex = this.tableTriggers.getSelectedRow();
        if (rowIndex >= 0 && this.tableTriggers.getQuery().isActive()) {
            try {
                this.tableTriggers.getQuery().getRecord(rowIndex);
                triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, triggerName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TriggersPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String triggerName = null;
            if (this.tableTriggers.getQuery().isActive() && this.tableTriggers.getSelectedRow() >= 0) {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                triggerName = this.tableTriggers.getQuery().fieldByName("TRIGGER_NAME").getString();
            }
            this.refresh(triggerName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        try {
            int column = this.tableTriggers.getSelectedColumn();
            int index = Math.max(0, this.tableTriggers.getSelectedRow());
            this.tableTriggers.getQuery().close();
            this.tableTriggers.getQuery().setSqlText(Sql.getAllTriggerList(this.filter.getSqlText()));
            this.tableTriggers.getQuery().paramByName("SYSTEM_FLAG").setString(this.currentSchemaName);
            this.tableTriggers.getQuery().open();
            if (objectName != null && this.tableTriggers.getQuery().locate("TRIGGER_NAME", new Variant(objectName))) {
                this.tableTriggers.changeSelection(this.tableTriggers.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableTriggers.getQuery().isEmpty()) {
                this.tableTriggers.changeSelection(Math.min(index, this.tableTriggers.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.splitTables.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableTriggers.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.menuCreateTrigger = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropTrigger = new JMenuItem();
        this.cmDropTrigger = new Action();
        this.cmFreezeObject = new Action();
        this.cmCreateTrigger = new Action();
        this.cmActiveTrigger = new Action();
        this.splitTables = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTriggers = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.jMenuItem1.setAction((javax.swing.Action)this.cmActiveTrigger);
        this.menuActions.add(this.jMenuItem1);
        this.menuCreateTrigger.setAction((javax.swing.Action)this.cmCreateTrigger);
        this.menuActions.add(this.menuCreateTrigger);
        this.menuActions.add(this.jSeparator2);
        this.menuDropTrigger.setAction((javax.swing.Action)this.cmDropTrigger);
        this.menuActions.add(this.menuDropTrigger);
        this.cmDropTrigger.setActionCommandKey("cmDropTrigger");
        this.cmDropTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTrigger.setText(this.stringManager.getString("TriggersPanelView-cmDropTrigger-text"));
        this.cmDropTrigger.setTooltip(this.stringManager.getString("TriggersPanelView-cmDropTrigger-hint"));
        this.cmDropTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmDropTriggerActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmCreateTrigger.setActionCommandKey("cmCreateTrigger");
        this.cmCreateTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trigger.gif"));
        this.cmCreateTrigger.setText(this.stringManager.getString("TriggersPanelView-cmCreateTrigger-text"));
        this.cmCreateTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmCreateTriggerActionPerformed(evt);
            }
        });
        this.cmActiveTrigger.setActionCommandKey("cmActiveTrigger");
        this.cmActiveTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enabled.gif"));
        this.cmActiveTrigger.setText(this.stringManager.getString("TriggersPanelView-cmActiveTrigger-text"));
        this.cmActiveTrigger.setTooltip(this.stringManager.getString("TriggersPanelView-cmActiveTrigger-hint"));
        this.cmActiveTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmActiveTriggerActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TriggersPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitTables.setBorder(null);
        this.splitTables.setDividerLocation(200);
        this.splitTables.setContinuousLayout(true);
        this.splitTables.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTriggers);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableTriggers);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.splitTables.setLeftComponent(this.panelTables);
        this.add((Component)this.splitTables, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableTriggers.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        if (StringUtil.equalsIgnoreCase((String)this.currentSchemaName, (String)"USER")) {
            this.setCurrentSchemaName("SYSTEM");
        } else {
            this.setCurrentSchemaName("USER");
        }
        this.refresh();
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmDropTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TriggersPanelView-drop-trigger-q"), triggerName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop trigger " + SQLUtil.createSqlName((String)triggerName), true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                this.accesibilities.createView((ViewProvider)new TriggerFreezeViewService(this.accesibilities, null, triggerName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateTriggerActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTriggerWizard(this.getDatabase(), null), (boolean)true);
        if (result != null) {
            this.refresh((String)result.getResultMap().get("object_name"));
        }
    }

    private void cmActiveTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (StringUtil.toBoolean((String)this.tableTriggers.getQuery().fieldByName("trigger_active").getString())) {
                    if (MessageBox.show((Component)null, (String)this.stringManager.getString("TriggersPanelView-trigger"), (String)String.format(this.stringManager.getString("TriggersPanelView-inactive-trigger-q"), triggerName), (int[])ModalResult.YESNO) == 5) {
                        this.getDatabase().createCommand("alter trigger " + SQLUtil.createSqlName((String)triggerName) + " INACTIVE", true);
                        this.refresh();
                    }
                } else if (MessageBox.show((Component)null, (String)this.stringManager.getString("TriggersPanelView-trigger"), (String)String.format(this.stringManager.getString("TriggersPanelView-active-trigger-q"), triggerName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("alter trigger " + SQLUtil.createSqlName((String)triggerName) + " ACTIVE", true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

