/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ViewUsingPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableUsing;
    private JToolBar toolBarIndexes;

    public ViewUsingPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableUsing.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = ViewUsingPanel.this.tableUsing.getSelectedRow();
                if (rowIndex >= 0 && ViewUsingPanel.this.tableUsing.getQuery().isActive()) {
                    try {
                        ViewUsingPanel.this.tableUsing.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableUsing.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableUsing.addColumn((TableColumn)new QueryTableColumn("OBJECT_NAME", this.stringManager.getString("ViewUsingPanel-object"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableUsing.addColumn((TableColumn)new QueryTableColumn("OBJECT_TYPE", this.stringManager.getString("ViewUsingPanel-object-type"), 150));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("OBJECT_NAME", this.stringManager.getString("ViewUsingPanel-object"), (String[])null));
            def.add(new SqlFilterDefComponent("OBJECT_TYPE", this.stringManager.getString("ViewUsingPanel-object-type"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "firebird-view-using-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableUsing, (JButton)this.buttonActions, this.menuActions, "firebird-view-using-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("ViewUsingPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ViewUsingPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableUsing.getQuery().close();
            this.tableUsing.getQuery().setSqlText(Sql.getViewUsingList(this.filter.getSqlText()));
            this.tableUsing.getQuery().paramByName("view_name").setString(this.currentTableName);
            this.tableUsing.getQuery().open();
            if (!this.tableUsing.getQuery().isEmpty()) {
                this.tableUsing.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableUsing.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableUsing = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewUsingPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewUsingPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ViewUsingPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableUsing);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonFilter);
        this.toolBarIndexes.add(this.jSeparator1);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableUsing);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

