/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CommentWizard
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private Database database;
    private String objectName;
    private String columnName;
    private String systemTableName;
    private JLabel jLabel3;
    private TextField textComments;

    public CommentWizard(Database database, String objectName, String columnName, String systemTableName) {
        this.database = database;
        this.systemTableName = systemTableName;
        this.objectName = objectName;
        this.columnName = columnName;
        this.initComponents();
        this.init();
    }

    public CommentWizard(Database database, String objectName, String systemTableName) {
        this(database, objectName, null, systemTableName);
    }

    private String getKeyField() {
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$RELATIONS")) {
            return "RDB$RELATION_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$EXCEPTIONS")) {
            return "RDB$EXCEPTION_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$FIELDS")) {
            return "RDB$FIELD_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$RELATION_FIELDS")) {
            return "RDB$FIELD_NAME = '" + this.columnName + "' AND RDB$RELATION_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$GENERATORS")) {
            return "RDB$GENERATOR_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$INDICES")) {
            return "RDB$INDEX_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$PROCEDURES")) {
            return "RDB$PROCEDURE_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$PROCEDURE_PARAMETERS")) {
            return "RDB$PARAMETER_NAME = '" + this.columnName + "' AND RDB$PROCEDURE_NAME";
        }
        if (StringUtil.equals((String)this.systemTableName, (String)"RDB$TRIGGERS")) {
            return "RDB$TRIGGER_NAME";
        }
        return "UNDEFINED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getComment() {
        Query query = this.database.createQuery();
        try {
            query.setSqlText("SELECT RDB$DESCRIPTION DESCRIPTION FROM " + this.systemTableName + " WHERE " + this.getKeyField() + " = :OBJECT_NAME");
            query.paramByName("OBJECT_NAME").setString(this.objectName);
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("DESCRIPTION").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    private void init() {
    }

    public void wizardShow() {
        this.textComments.setText(this.getComment());
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CommentWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CommentWizard-tab-title");
    }

    public String getSqlCode() {
        return "UPDATE " + this.systemTableName + "\n" + "   SET RDB$DESCRIPTION = '" + this.textComments.getText() + "'\n" + " WHERE " + this.getKeyField() + " = '" + this.objectName + "'\n/\n";
    }

    public boolean execute() {
        try {
            this.database.executeScript(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.textComments = new TextField();
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("comment-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textComments, -1, 274, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textComments, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

